/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.processor.signature;

import de.intarsys.document.model.IDocumentType;
import de.intarsys.processor.document.common.CommonDocumentProcessorFactory;
import de.intarsys.security.processor.signature.IDocumentSigner;
import de.intarsys.security.processor.signature.IDocumentSignerFactory;
import de.intarsys.security.signature.etsi.service.SignatureCreationService;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class CommonDocumentSignerFactory
extends CommonDocumentProcessorFactory
implements IDocumentSignerFactory {
    private static final String ATTR_SUPPORTED = "supported";
    private static final String ATTR_ID = "id";
    private static final String E_DOCUMENT_TYPE = "documentType";
    private static final String E_DOCUMENT_TYPES = "documentTypes";
    private final List<String> supportedDocumentTypes = new ArrayList<String>();
    private final List<String> unsupportedDocumentTypes = new ArrayList<String>();

    protected void checkSignatureFormat(IArgs args) {
        String format = SignatureCreationService.getFormat((IArgs)args, null);
        if (format != null && !this.supports(format)) {
            throw new IllegalArgumentException("'format' " + format + " not supported");
        }
    }

    public void configure(IElement pElement) throws ConfigurationException {
        super.configure(pElement);
        IElement eDocumentTypes = pElement.element(E_DOCUMENT_TYPES);
        if (eDocumentTypes != null) {
            Iterator iDocumentType = eDocumentTypes.elementIterator(E_DOCUMENT_TYPE);
            while (iDocumentType.hasNext()) {
                IElement eDocumentType = (IElement)iDocumentType.next();
                String id = ElementTools.getString((IElement)eDocumentType, (String)ATTR_ID, null);
                if (id == null) {
                    throw new ConfigurationException("Attribute 'id' missing.");
                }
                boolean supported = ElementTools.getBoolean((IElement)eDocumentType, (String)ATTR_SUPPORTED, (boolean)true);
                if (supported) {
                    this.supportedDocumentTypes.add(id);
                    continue;
                }
                this.unsupportedDocumentTypes.add(id);
            }
        }
    }

    public Class getResultType() {
        return IDocumentSigner.class;
    }

    protected List<String> getSupportedDocumentTypes() {
        return this.supportedDocumentTypes;
    }

    protected List<String> getUnsupportedDocumentTypes() {
        return this.unsupportedDocumentTypes;
    }

    @Override
    public boolean supports(IDocumentType docType) {
        if (this.getSupportedDocumentTypes().contains(docType.getId())) {
            return true;
        }
        if (this.getUnsupportedDocumentTypes().contains(docType.getId())) {
            return false;
        }
        return this.getSupportedDocumentTypes().isEmpty();
    }
}

