/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.processor.signature;

import de.intarsys.document.model.IDocument;
import de.intarsys.security.app.signature.ISigner;
import de.intarsys.security.app.signature.SignerTools;
import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.processor.signature.CommonDocumentSigner;
import de.intarsys.security.processor.signature.DocumentSignerException;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.expression.EvaluationException;
import de.intarsys.tools.expression.ExpressionEvaluator;
import de.intarsys.tools.expression.MapResolver;
import de.intarsys.tools.expression.Mode;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.license.ILicenseAccount;
import de.intarsys.tools.license.ILicenseAccountSupport;
import java.util.Collection;

public abstract class DeviceBasedDocumentSigner
extends CommonDocumentSigner {
    private ISigner digestSigner;

    protected DeviceBasedDocumentSigner(IFactory factory, IDocument doc) {
        super(factory, doc);
    }

    @Override
    protected IConversation<Void> basicPrepare() {
        return super.basicPrepare().thenCompose(ignore -> {
            if (this.getDigestSigner() == null) {
                this.setDigestSigner(SignerTools.getSigner((IArgs)this.getArgs(), (String)"digestSigner"));
            }
            if (this.getDigestSigner() == null) {
                throw new IllegalArgumentException("'digestSigner' required");
            }
            return this.basicPrepareDigestSigner();
        }).thenAccept(ignore -> {
            IX509PublicKeyCertificate[] certs = this.getDigestSigner().getCertificatePath();
            IX509PublicKeyCertificate cert = certs == null || certs.length == 0 ? null : certs[0];
            this.setAttributeCertificates(CertificateTools.getAttributeCertificates((IX509PublicKeyCertificate)cert, (IArgs)this.getArgs()));
        });
    }

    protected IConversation<Void> basicPrepareDigestSigner() {
        return this.getDigestSigner().signPrepare();
    }

    protected void basicStop() throws Exception {
        super.basicStop();
        if (this.getDigestSigner() != null) {
            this.getDigestSigner().dispose();
        }
    }

    protected Exception castException(Exception e) {
        if (e instanceof DocumentSignerException) {
            return e;
        }
        return new DocumentSignerException(e.getLocalizedMessage(), e);
    }

    protected void createUnprefixedResolver(MapResolver resolver) {
        super.createUnprefixedResolver(resolver);
        resolver.put("documentSigner", () -> this);
        resolver.put("documentsigner", () -> this);
        resolver.put("digestSigner", this::getDigestSigner);
        resolver.put("digestsigner", this::getDigestSigner);
    }

    protected Object evaluateFallback(String expression, IArgs pArgs) throws EvaluationException {
        try {
            Object tmp = ExpressionEvaluator.get((Mode)Mode.UNTRUSTED).evaluate(expression, pArgs);
            if (tmp != null) {
                return tmp;
            }
        }
        catch (EvaluationException evaluationException) {
            // empty catch block
        }
        return super.evaluateFallback(expression, pArgs);
    }

    public ISigner getDigestSigner() {
        return this.digestSigner;
    }

    @Override
    protected String getPreferredHashAlgorithmName() {
        return this.getDigestSigner().getPreferredHashAlgorithmName();
    }

    @Override
    protected Collection<String> getSupportedHashAlgorithmNames() {
        return this.getDigestSigner().getSupportedHashAlgorithmNames();
    }

    @Override
    protected boolean isAuthorized() {
        ILicenseAccountSupport lics;
        ILicenseAccount account;
        if (!super.isAuthorized()) {
            return false;
        }
        return !(this.getDigestSigner() instanceof ILicenseAccountSupport) || (account = (lics = (ILicenseAccountSupport)this.getDigestSigner()).getLicenseAccount()) == null || !account.getLicenseState().isNotAuthorized();
    }

    public void setDigestSigner(ISigner digestSigner) {
        this.digestSigner = digestSigner;
    }
}

