/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.processor.signature;

import de.intarsys.document.common.DocumentTools;
import de.intarsys.document.model.IDocument;
import de.intarsys.document.model.IDocumentType;
import de.intarsys.processor.document.common.DocumentDispatchingFactory;
import de.intarsys.security.processor.signature.IDocumentSigner;
import de.intarsys.security.processor.signature.IDocumentSignerFactory;
import de.intarsys.security.processor.signature.SignatureEnvironment;
import de.intarsys.security.signature.etsi.service.SignatureCreationService;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.io.IOException;

public class DocumentSignerFactory
extends DocumentDispatchingFactory
implements IDocumentSignerFactory {
    public static final String ID = DocumentSignerFactory.class.getName();
    public static final String METHOD_SIGNER = "Signer";

    public Object createInstance(IArgs args) throws ObjectCreationException {
        String format = SignatureCreationService.getFormat((IArgs)args, null);
        if (format != null) {
            IDocumentSignerFactory[] factories = null;
            try {
                IDocument document = DocumentTools.getDocumentOrCurrent((IArgs)args, (String)"document");
                factories = document == null ? SignatureEnvironment.get().getDocumentSignerFactories() : SignatureEnvironment.get().getDocumentSignerFactories(document.getType());
            }
            catch (IOException e) {
                throw new ObjectCreationException((Throwable)e);
            }
            for (IDocumentSignerFactory factory : factories) {
                if (!factory.supports(format)) continue;
                return factory.createInstance(args);
            }
        }
        return super.createInstance(args);
    }

    protected String getMethodName() {
        return METHOD_SIGNER;
    }

    public Class getResultType() {
        return IDocumentSigner.class;
    }

    @Override
    public boolean supports(IDocumentType docType) {
        return false;
    }

    @Override
    public boolean supports(String format) {
        return false;
    }
}

