/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.processor.signature;

import de.intarsys.document.model.IDocument;
import de.intarsys.processor.common.CommonProcessor;
import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.app.signature.ISigner;
import de.intarsys.security.app.signature.ImmortalSigner;
import de.intarsys.security.app.signature.SignerTools;
import de.intarsys.security.processor.signature.DocumentSignerException;
import de.intarsys.security.processor.signature.IDocumentSigner;
import de.intarsys.security.processor.signature.IDocumentSignerFactory;
import de.intarsys.security.processor.signature.IDocumentSignerSession;
import de.intarsys.security.signature.ISignatureContainer;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.factory.InstanceSpec;
import de.intarsys.tools.functor.FunctorException;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reflect.ObjectCreationException;

public class DocumentSignerSession
extends CommonProcessor
implements IDocumentSignerSession {
    private ImmortalSigner signer;

    public DocumentSignerSession(IFactory factory) {
        super(factory);
    }

    protected void basicStart() throws Exception {
        super.basicStart();
        ISigner digestSigner = SignerTools.getSigner((IArgs)this.getDocumentSignerArgs(), (String)"digestSigner");
        this.setBasicDigestSigner(digestSigner);
    }

    protected void basicStop() throws Exception {
        super.basicStop();
        if (this.getSigner() != null) {
            ((ImmortalSigner)this.getSigner()).disposeReally();
        }
    }

    protected IDocumentSigner createDocumentSigner(IDocument document) throws DocumentSignerException {
        IArgs args = this.getDocumentSignerArgs().copy();
        args.put("document", (Object)document);
        args.put("digestSigner", (Object)this.getSigner());
        IDocumentSignerFactory factory = this.getDocumentSignerFactory();
        if (factory == null) {
            try {
                return (IDocumentSigner)document.invoke("Signer", args);
            }
            catch (Exception e) {
                throw (DocumentSignerException)ExceptionTools.unwrapTyped((Throwable)e, DocumentSignerException.class);
            }
        }
        try {
            return (IDocumentSigner)factory.createInstance(args);
        }
        catch (ObjectCreationException e) {
            throw new DocumentSignerException(e.getLocalizedMessage(), e);
        }
    }

    protected IArgs getDocumentSignerArgs() {
        InstanceSpec spec = InstanceSpec.get((IArgs)this.getArgs(), (String)"documentSigner", Object.class, null);
        if (spec == null || spec.getArgs().size() == 0) {
            return this.getArgs();
        }
        return spec.getArgs();
    }

    protected IDocumentSignerFactory getDocumentSignerFactory() throws DocumentSignerException {
        try {
            InstanceSpec spec = InstanceSpec.get((IArgs)this.getArgs(), (String)"documentSigner", Object.class, (InstanceSpec)InstanceSpec.EMPTY_SPEC);
            return (IDocumentSignerFactory)spec.getRealFactory();
        }
        catch (ObjectCreationException e) {
            throw new DocumentSignerException(e.getLocalizedMessage(), e);
        }
    }

    @Override
    public ISigner getSigner() {
        return this.signer;
    }

    protected void setBasicDigestSigner(ISigner basicDigestSigner) {
        this.signer = basicDigestSigner == null ? null : new ImmortalSigner(basicDigestSigner);
    }

    @Override
    public ISignatureContainer sign(IDocument document) throws DocumentSignerException {
        IDocumentSigner documentSigner = this.createDocumentSigner(document);
        documentSigner.start();
        try {
            this.setResult(documentSigner.getResult());
            return (ISignatureContainer)documentSigner.getResult();
        }
        catch (FunctorException e) {
            DocumentSignerException dse = (DocumentSignerException)ExceptionTools.getFromChain((Throwable)e, DocumentSignerException.class);
            if (dse != null) {
                if (dse.getCause() instanceof SecurityApplicationException) {
                    this.fail(dse);
                }
                throw dse;
            }
            throw new DocumentSignerException(e.getMessage(), e);
        }
    }
}

