/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.processor.signature;

import de.intarsys.document.common.DocumentTools;
import de.intarsys.document.model.DocumentEnvironment;
import de.intarsys.document.model.IDocument;
import de.intarsys.processor.common.CommonProcessor;
import de.intarsys.security.app.IRestrictedApplication;
import de.intarsys.security.app.signature.ISigner;
import de.intarsys.security.app.signature.ImmortalSigner;
import de.intarsys.security.app.signature.SignatureEvidence;
import de.intarsys.security.app.signature.SignatureItemEvidence;
import de.intarsys.security.app.signature.SignerTools;
import de.intarsys.security.processor.signature.DocumentSignerException;
import de.intarsys.security.processor.signature.DocumentSignerFactory;
import de.intarsys.security.processor.signature.IDocumentSigner;
import de.intarsys.security.processor.signature.MultiSignerFactory;
import de.intarsys.security.signature.ISignatureContainer;
import de.intarsys.tools.attribute.IAttributeSupport;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.IConversationSupport;
import de.intarsys.tools.conversation.driver.ConversationDriver;
import de.intarsys.tools.conversation.impl.Conversation;
import de.intarsys.tools.digest.DigestTools;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.digest.IDigester;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.exception.RestartException;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.factory.InstanceSpec;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.license.LicenseEnvironment;
import de.intarsys.tools.license.LicenseProperty;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorFactory;
import de.intarsys.tools.locator.ILocatorNameFilter;
import de.intarsys.tools.locator.LocatorFactory;
import de.intarsys.tools.locator.LocatorTools;
import de.intarsys.tools.progress.ProgressMonitor;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.tag.TagTools;
import de.intarsys.tools.zones.Zone;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiSigner
extends CommonProcessor<IArgs>
implements IConversationSupport<IArgs> {
    private static final String DEFAULT_TAG_ARGS_NAME = "args.documentSigner.args";
    private static final String ARG_TAG_ARGS_NAME = "tagArgsName";
    public static final String ARG_DOCUMENT = "document";
    public static final String ARG_DOCUMENTFOLDER = "documentFolder";
    public static final String ARG_DOCUMENTPATTERN = "documentPattern";
    public static final String ARG_DOCUMENTS = "documents";
    public static final String LICPROP_BATCHSIZE = "batchsize";
    public static final String RESULT_SIGNATURE = "signature";
    public static final String RESULT_SIGNATURES = "signatures";
    private static final Logger Log = LoggerFactory.getLogger(MultiSigner.class);
    private boolean indexed = false;
    private IConversation<IArgs> conversation;
    private boolean conversationRequested;
    private ImmortalSigner signer;

    public MultiSigner(MultiSignerFactory factory) {
        super((IFactory)factory);
    }

    protected void basicRun() throws Exception {
        this.setProgressMonitor(ProgressMonitor.get((IAttributeSupport)Zone.getCurrent()));
        this.conversation = this.createConversation();
        this.conversation.exceptionally(ex -> {
            this.getProgressMonitor().end();
            this.handleThrowable((Throwable)ex);
            return null;
        });
        this.conversation.thenAccept(result -> {
            this.getProgressMonitor().end();
            this.setResult(result);
            this.ok();
        });
        if (!this.conversationRequested) {
            ConversationDriver.get().get(this.conversation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IConversation<ISignatureContainer> basicSignDocument(InstanceSpec<IDocumentSigner> documentSignerSpec, ILocator locator) {
        IDocument iDoc = null;
        try {
            this.getProgressMonitor().subTask(locator.getName());
            iDoc = DocumentTools.createDocument((Object)locator);
            DocumentTools.detectTags((IDocument)iDoc, (IArgs)this.getArgs());
            InstanceSpec<IDocumentSigner> localDocumentSignerSpec = this.createDocumentSignerSpec(documentSignerSpec, iDoc);
            IConversationSupport processor = (IConversationSupport)localDocumentSignerSpec.createInstance();
            IConversation tmpConversation = processor.getConversation();
            Log.debug("{} created document signer conversation {}", (Object)this.getLogLabel(), (Object)tmpConversation.getHandle());
            IConversation iConversation = tmpConversation.exceptionally(e -> {
                Throwable unwrapped = ExceptionTools.unwrap((Throwable)e);
                throw ExceptionTools.wrapWithMessagePrefix((Throwable)unwrapped, (String)(locator.getPath() + " - "));
            });
            return iConversation;
        }
        catch (CancellationException e2) {
            throw e2;
        }
        catch (Exception e3) {
            Throwable unwrapped = ExceptionTools.unwrap((Throwable)e3);
            String msg = locator.getPath() + " - " + ExceptionTools.getMessage((Throwable)unwrapped);
            IConversation iConversation = Conversation.failed((Throwable)new DocumentSignerException(msg, unwrapped));
            return iConversation;
        }
        finally {
            if (iDoc != null) {
                iDoc.release(null);
            }
        }
    }

    protected IConversation<IArgs> basicSignDocuments(InstanceSpec<IDocumentSigner> documentSignerSpec, List<ILocator> locators) {
        return Conversation.completed(null).thenCompose(ignore -> {
            Iterator<ILocator> itLocators = locators.iterator();
            if (itLocators.hasNext()) {
                return this.basicSignDocumentsBatch(itLocators, documentSignerSpec);
            }
            return Conversation.completed(new ArrayList());
        }).thenApply(signatures -> {
            Args resultArgs = Args.create();
            if (this.isIndexed() || signatures.isEmpty()) {
                resultArgs.put(RESULT_SIGNATURES, signatures);
            } else {
                resultArgs.put(RESULT_SIGNATURE, signatures.get(0));
            }
            return resultArgs;
        }).exceptionallyCompose(ex -> {
            Throwable unwrapped = ExceptionTools.unwrap((Throwable)ex);
            if (unwrapped instanceof RestartException) {
                return this.basicSignDocuments(documentSignerSpec, locators);
            }
            throw Conversation.rethrowable((Throwable)unwrapped);
        });
    }

    protected IConversation<List<ISignatureContainer>> basicSignDocumentsBatch(Iterator<ILocator> itLocators, InstanceSpec<IDocumentSigner> documentSignerSpec) {
        return this.getSigner().signPrepare().thenCompose(ignore -> this.getSigner().signBegin()).thenApply(ignore -> {
            ArrayList signatures = new ArrayList();
            IConversation allDocs = Conversation.completed(null);
            while (itLocators.hasNext()) {
                ILocator locator = (ILocator)itLocators.next();
                IConversation docConversation = this.basicSignDocument(documentSignerSpec, locator).thenApply(result -> {
                    this.getProgressMonitor().worked(1.0f);
                    signatures.add(result);
                    return signatures;
                });
                if (docConversation.isCompletedExceptionally()) {
                    docConversation.get();
                }
                allDocs = allDocs.thenCompose(list -> docConversation);
            }
            return allDocs;
        }).thenCompose(allDocs -> this.getSigner().signCommit().thenCompose(ignore -> allDocs)).exceptionally(ex -> {
            this.getSigner().signAbort();
            throw Conversation.rethrowable((Throwable)ex);
        }).thenApply(signatures -> signatures);
    }

    protected void basicStop() throws Exception {
        ImmortalSigner tmpSigner = this.getSigner();
        if (tmpSigner != null) {
            Log.debug("{} dispose immortal signer", (Object)this.getLogLabel());
            tmpSigner.disposeReally();
            this.setSigner(null);
        }
        super.basicStop();
    }

    protected IConversation<IArgs> createConversation() {
        try {
            InstanceSpec digestSignerSpec;
            InstanceSpec documentSignerSpec;
            List<ILocator> locators = this.createLocators();
            this.getProgressMonitor().begin("Sign documents", (float)locators.size());
            SignatureEvidence signatureEvidence = null;
            if (this.isSadRequired()) {
                signatureEvidence = this.createSignatureEvidence(locators);
            }
            if ((documentSignerSpec = InstanceSpec.get((IArgs)this.getArgs(), (String)"documentSigner", IDocumentSigner.class, null)) == null) {
                return Conversation.failed((Throwable)new IllegalArgumentException("'documentSigner' required"));
            }
            if (documentSignerSpec.getFactory() == null) {
                documentSignerSpec.setFactory((Object)DocumentSignerFactory.ID);
            }
            if ((digestSignerSpec = InstanceSpec.get((IArgs)documentSignerSpec.getArgs(), (String)"digestSigner", ISigner.class, null)) == null) {
                return Conversation.failed((Throwable)new IllegalArgumentException("'documentSigner.args.digestSigner' required"));
            }
            if (digestSignerSpec.getFactory() == null) {
                return Conversation.failed((Throwable)new IllegalArgumentException("'documentSigner.args.digestSigner.factory' required"));
            }
            digestSignerSpec.getArgs().put("signatureEvidence", (Object)signatureEvidence);
            ISigner tmpSigner = this.createSigner((InstanceSpec<ISigner>)digestSignerSpec);
            if (tmpSigner == null) {
                return Conversation.cancelled();
            }
            this.setSigner(new ImmortalSigner(tmpSigner));
            documentSignerSpec.getArgs().put("digestSigner", (Object)this.getSigner());
            return this.getSigner().authenticate().thenCompose(ignore -> this.basicSignDocuments((InstanceSpec<IDocumentSigner>)documentSignerSpec, locators));
        }
        catch (Exception e) {
            return Conversation.failed((Throwable)e);
        }
    }

    protected InstanceSpec<IDocumentSigner> createDocumentSignerSpec(InstanceSpec<IDocumentSigner> documentSignerSpec, IDocument<?> iDoc) {
        InstanceSpec tempSignerSpec = documentSignerSpec.copy();
        Consumer argsValidator = (Consumer)ArgTools.get((IArgs)this.getArgs(), (String)"argsValidator", Consumer.class, null);
        IArgs tagArgs = this.getDocumentTagArgs(iDoc);
        if (argsValidator != null) {
            argsValidator.accept(tagArgs);
        }
        ArgTools.putAllDeep((IArgs)tempSignerSpec.getArgs(), (IArgs)tagArgs);
        TagTools.expandArgs(iDoc, (IArgs)tempSignerSpec.getArgs());
        tempSignerSpec.getArgs().put(ARG_DOCUMENT, iDoc);
        return tempSignerSpec;
    }

    protected ILocator createLocator(IArgs.IBinding binding) throws IOException {
        if (binding.getName() != null) {
            throw new IOException("unusable arguments");
        }
        return this.createLocator(binding.getValue());
    }

    protected ILocator createLocator(Object value) throws IOException {
        return LocatorTools.createLocator((Object)value, (ILocatorFactory)LocatorFactory.get(), null);
    }

    protected List<ILocator> createLocators() throws IOException {
        Args undefined = Args.create();
        Object argDocument = ArgTools.getObject((IArgs)this.getArgs(), (String)ARG_DOCUMENT, (Object)undefined);
        Object argFolder = ArgTools.getObject((IArgs)this.getArgs(), (String)ARG_DOCUMENTFOLDER, (Object)undefined);
        IArgs argDocuments = ArgTools.getArgs((IArgs)this.getArgs(), (String)ARG_DOCUMENTS, (IArgs)undefined);
        if (argDocument != undefined) {
            Log.debug("{} create single locator list", (Object)this.getLogLabel());
            return Arrays.asList(this.createLocator(argDocument));
        }
        if (argFolder != undefined) {
            Log.debug("{} create folder locator list", (Object)this.getLogLabel());
            this.setIndexed(true);
            return this.createLocatorsFolder(argFolder);
        }
        if (argDocuments != undefined) {
            Log.debug("{} create enumerated locator list", (Object)this.getLogLabel());
            this.setIndexed(true);
            ArrayList<ILocator> result = new ArrayList<ILocator>();
            Iterator itBindings = argDocuments.bindings();
            while (itBindings.hasNext()) {
                result.add(this.createLocator((IArgs.IBinding)itBindings.next()));
            }
            return result;
        }
        return Collections.emptyList();
    }

    protected List<ILocator> createLocatorsFolder(Object argFolder) throws IOException {
        ILocator folder;
        ILocator[] locators;
        final String argPattern = ArgTools.getString((IArgs)this.getArgs(), (String)ARG_DOCUMENTPATTERN, null);
        ILocatorNameFilter filter = null;
        if (argPattern != null) {
            final Pattern pattern = Pattern.compile(argPattern);
            filter = new ILocatorNameFilter(){

                public boolean accept(ILocator parent, String name) {
                    boolean matches = pattern.matcher(name).matches();
                    if (matches) {
                        Log.debug("candidate {} matches pattern {}", (Object)name, (Object)argPattern);
                    } else {
                        Log.debug("candidate {} does not match pattern {}", (Object)name, (Object)argPattern);
                    }
                    return matches;
                }
            };
        }
        if ((locators = (folder = LocatorTools.createLocator((Object)argFolder, (ILocatorFactory)DocumentEnvironment.get().getLocatorFactory(), null)).listLocators(filter)).length == 0) {
            Log.debug("filtered folder locator list is empty");
        }
        return Arrays.asList(locators);
    }

    protected SignatureEvidence createSignatureEvidence(List<ILocator> locators) throws IOException {
        SignatureEvidence evidence = new SignatureEvidence();
        for (ILocator locator : locators) {
            evidence.addItem(this.createSignatureItemEvidence(locator));
        }
        evidence.finish();
        return evidence;
    }

    private SignatureItemEvidence createSignatureItemEvidence(ILocator locator) throws IOException {
        SignatureItemEvidence signatureItemEvidence;
        block8: {
            InputStream is = locator.getInputStream();
            try {
                IDigester digester = DigestTools.createDigester((String)"SHA256");
                digester.digestUpdate(is);
                IDigest digest = digester.digestFinal();
                SignatureItemEvidence itemEvidence = new SignatureItemEvidence();
                itemEvidence.setDigest(digest);
                itemEvidence.setLabel(locator.getName());
                signatureItemEvidence = itemEvidence;
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IOException("Should never happen", e);
                }
            }
            is.close();
        }
        return signatureItemEvidence;
    }

    protected ISigner createSigner(InstanceSpec<ISigner> signerSpec) throws ObjectCreationException {
        ISigner result = SignerTools.getSignerRaw(signerSpec);
        if (result == null) {
            return null;
        }
        if (result instanceof IRestrictedApplication) {
            IRestrictedApplication restricted = (IRestrictedApplication)result;
            int batchSize = 1;
            LicenseProperty property = LicenseEnvironment.get().getLicensePropertyMaxGlobal(LICPROP_BATCHSIZE);
            if (property != null) {
                batchSize = property.getValueInt();
            }
            restricted.setRestrictionCount(batchSize);
        }
        return result;
    }

    public IConversation<IArgs> getConversation() {
        this.conversationRequested = true;
        this.start();
        return this.conversation;
    }

    protected IArgs getDocumentTagArgs(IDocument<?> iDoc) {
        String tagArgsName = ArgTools.getString((IArgs)this.getArgs(), (String)ARG_TAG_ARGS_NAME, null);
        IArgs tagArgs = null;
        if (tagArgsName == null) {
            tagArgs = TagTools.toArgs(iDoc, (String)"args.documentSigner.args.");
            if (tagArgs.size() == 0) {
                tagArgs = TagTools.toArgs(iDoc, (String)"args.");
            }
        } else {
            tagArgs = TagTools.toArgs(iDoc, (String)(tagArgsName + "."));
        }
        return tagArgs;
    }

    public ImmortalSigner getSigner() {
        return this.signer;
    }

    public boolean isIndexed() {
        return this.indexed;
    }

    protected boolean isSadRequired() {
        return true;
    }

    public void setIndexed(boolean indexed) {
        this.indexed = indexed;
    }

    public void setSigner(ImmortalSigner signer) {
        this.signer = signer;
    }
}

