/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.processor.signature;

import de.intarsys.document.model.IDocumentType;
import de.intarsys.security.app.signature.ISigner;
import de.intarsys.security.app.validation.commonpki.qes.CommonPKIProfile;
import de.intarsys.security.device.processor.ISignerFactory;
import de.intarsys.security.processor.signature.IDocumentSigner;
import de.intarsys.security.processor.signature.IDocumentSignerFactory;
import de.intarsys.tools.collection.ArrayTools;
import de.intarsys.tools.component.SingletonProvider;
import de.intarsys.tools.enumeration.common.EnumIconSize;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.factory.Outlet;
import de.intarsys.tools.functor.FunctorException;
import de.intarsys.tools.functor.IBaseFunctor;
import de.intarsys.tools.preferences.IPreferences;
import de.intarsys.tools.preferences.IPreferencesSupport;
import de.intarsys.tools.preferences.IPreferencesSyncher;
import de.intarsys.tools.preferences.PreferencesFactory;
import de.intarsys.tools.servicelocator.ServiceLocator;
import de.intarsys.tools.tag.TagDeprecated;
import de.intarsys.tools.tag.TagVisible;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.ArrayList;

@SingletonProvider
public class SignatureEnvironment
implements IPreferencesSupport,
IPreferencesSyncher {
    public static final boolean DEFAULT_AUTO_SAVE_DOCUMENTS = false;
    public static final String DEFAULT_STATE_ICON_SIZE = EnumIconSize.XLARGE.getId();
    public static final String PREF_AUTO_SAVE_DOCUMENTS = "auto_save_document";
    public static final String PREF_STATE_ICON_SIZE = "state_icon_size";
    public static final String PREF_POLICY = "policy";
    private boolean autoSaveDocument;
    private EnumIconSize stateIconSize;
    private IPreferences preferences;
    private ISignerFactory[] digestSignerFactories;
    private IDocumentSignerFactory[] documentSignerFactories;

    public static SignatureEnvironment get() {
        return (SignatureEnvironment)ServiceLocator.get().get(SignatureEnvironment.class);
    }

    protected IPreferences createPreferences() {
        String name = this.getPreferencesName();
        IPreferences root = PreferencesFactory.get().getRoot();
        IPreferences result = root.node(name);
        IPreferences defaultPreferences = result.restrict("DEFAULT");
        this.preferencesInit(defaultPreferences);
        return result;
    }

    public ISignerFactory[] getDigestSignerFactories() {
        if (this.digestSignerFactories == null) {
            Object[] factories = Outlet.get().lookupFactories(ISigner.class);
            IFactory[] applicableFactories = (IFactory[])ArrayTools.select((Object[])factories, (IBaseFunctor)new IBaseFunctor<Boolean>(){

                public Boolean perform(Object ... args) throws FunctorException {
                    IFactory fac = (IFactory)args[0];
                    return fac instanceof ISignerFactory && TagVisible.isVisibleAt((Object)fac, (String)"basic") && !TagDeprecated.isDeprecated((Object)fac);
                }
            }, IFactory.class);
            this.digestSignerFactories = new ISignerFactory[applicableFactories.length];
            for (int i = 0; i < applicableFactories.length; ++i) {
                this.digestSignerFactories[i] = (ISignerFactory)applicableFactories[i];
            }
        }
        return this.digestSignerFactories;
    }

    public IDocumentSignerFactory[] getDocumentSignerFactories() {
        if (this.documentSignerFactories == null) {
            Object[] factories = Outlet.get().lookupFactories(IDocumentSigner.class);
            IFactory[] applicableFactories = (IFactory[])ArrayTools.select((Object[])factories, (IBaseFunctor)new IBaseFunctor<Boolean>(){

                public Boolean perform(Object ... args) throws FunctorException {
                    IFactory fac = (IFactory)args[0];
                    return fac instanceof IDocumentSignerFactory && TagVisible.isVisibleAt((Object)fac, (String)"basic") && !TagDeprecated.isDeprecated((Object)fac);
                }
            }, IFactory.class);
            this.documentSignerFactories = new IDocumentSignerFactory[applicableFactories.length];
            for (int i = 0; i < applicableFactories.length; ++i) {
                this.documentSignerFactories[i] = (IDocumentSignerFactory)applicableFactories[i];
            }
        }
        return this.documentSignerFactories;
    }

    public IDocumentSignerFactory[] getDocumentSignerFactories(IDocumentType docType) {
        ArrayList<IDocumentSignerFactory> supporters = new ArrayList<IDocumentSignerFactory>();
        for (IDocumentSignerFactory factory : this.getDocumentSignerFactories()) {
            if (!factory.supports(docType)) continue;
            supporters.add(factory);
        }
        return supporters.toArray(new IDocumentSignerFactory[supporters.size()]);
    }

    public CommonPKIProfile getPolicy() {
        String value = this.getPreferences().get(PREF_POLICY);
        return (CommonPKIProfile)CommonPKIProfile.META.getItemOrDefault(value);
    }

    public final IPreferences getPreferences() {
        if (this.preferences == null) {
            this.preferences = this.createPreferences();
        }
        return this.preferences;
    }

    protected String getPreferencesName() {
        return "de.intarsys.prefs.security.digsig";
    }

    public EnumIconSize getStateIconSize() {
        return this.stateIconSize;
    }

    @PostConstruct
    public void installInstance() {
        this.preferencesRestore();
    }

    public boolean isAutoSaveDocument() {
        return this.autoSaveDocument;
    }

    protected void preferencesInit(IPreferences preferences) {
        preferences.put(PREF_AUTO_SAVE_DOCUMENTS, false);
        preferences.put(PREF_STATE_ICON_SIZE, DEFAULT_STATE_ICON_SIZE);
        preferences.put(PREF_POLICY, CommonPKIProfile.QES_SigG.getId());
    }

    public void preferencesRestore() {
        IPreferences preferences = this.getPreferences();
        this.autoSaveDocument = preferences.getBoolean(PREF_AUTO_SAVE_DOCUMENTS, false);
        String id = preferences.get(PREF_STATE_ICON_SIZE, DEFAULT_STATE_ICON_SIZE);
        this.stateIconSize = (EnumIconSize)EnumIconSize.META.getItem(id);
    }

    public void preferencesStore() {
        IPreferences preferences = this.getPreferences();
        preferences.putBoolean(PREF_AUTO_SAVE_DOCUMENTS, this.autoSaveDocument);
        preferences.put(PREF_STATE_ICON_SIZE, this.stateIconSize.getId());
    }

    public void setAutoSaveDocument(boolean autoSaveDocument) {
        this.autoSaveDocument = autoSaveDocument;
    }

    public void setPolicy(CommonPKIProfile policy) {
        this.getPreferences().put(PREF_POLICY, policy.getId());
    }

    public void setStateIconSize(EnumIconSize stateIconSize) {
        this.stateIconSize = stateIconSize;
    }

    @PreDestroy
    public void uninstallInstance() {
        this.preferencesStore();
    }
}

