/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.processor.timestamp;

import de.intarsys.document.model.IDocument;
import de.intarsys.processor.document.common.CommonDocumentProcessor;
import de.intarsys.security.document.validation.ISignedDocument;
import de.intarsys.security.document.validation.SignedDocument;
import de.intarsys.security.processor.timestamp.DocumentTimestampException;
import de.intarsys.security.processor.timestamp.IDocumentTimestampCreator;
import de.intarsys.security.processor.timestamp.PACKAGE;
import de.intarsys.security.signature.ISignatureContainer;
import de.intarsys.tools.attribute.IAttributeSupport;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.license.LicenseEnvironment;
import de.intarsys.tools.license.LicenseException;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorFactory;
import de.intarsys.tools.locator.LocatorFactory;
import de.intarsys.tools.locator.LocatorTools;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.string.StringTools;

public abstract class CommonDocumentTimestampCreator
extends CommonDocumentProcessor
implements IDocumentTimestampCreator {
    private static final String DEFAULT_LOCATOR_EXTENSION = "ts";
    private static final IMessageBundle Msg = PACKAGE.Messages;

    public CommonDocumentTimestampCreator(IFactory factory, IDocument doc) {
        super(factory, doc);
    }

    protected abstract ISignatureContainer basicCreateTimestamp() throws DocumentTimestampException;

    protected void basicRun() throws Exception {
        if (this.getDocument().isChanged()) {
            throw new DocumentTimestampException(Msg.getString("CommonDocumentTimestampCreator.ExUnsavedChanges", new Object[0]));
        }
        if (!this.isAuthorized()) {
            throw new LicenseException(Msg.getString("CommonDocumentTimestampCreator.ExLicense", new Object[0]));
        }
        ISignatureContainer timestamp = null;
        timestamp = this.basicCreateTimestamp();
        this.setResult(timestamp);
        ISignedDocument signedDoc = SignedDocument.lookupSignedDocument((IAttributeSupport)this.getDocument());
        if (signedDoc != null) {
            signedDoc.addSignatureContainer(timestamp);
        }
        this.ok();
    }

    protected ILocator createDestinationDefaultLocator() {
        return this.getDocument().getLocator();
    }

    protected ILocator createDestinationLocator() throws DocumentTimestampException {
        ILocator destination;
        ILocator tempLocator = this.getLocator();
        ILocator iLocator = destination = tempLocator != null ? tempLocator : this.createDestinationDefaultLocator();
        if (destination.isDirectory()) {
            Object defaultName = this.getDocument().getLocator().getName();
            if (this.isCreateAttachment()) {
                defaultName = (String)defaultName + "." + this.getLocatorExtension();
            }
            destination = destination.getChild((String)defaultName);
        }
        if (destination.exists() && !this.isAppend() && !this.isOverwrite()) {
            int counter = 1;
            ILocator parentLocator = destination.getParent();
            if (parentLocator != null) {
                String basename = LocatorTools.getBaseName((ILocator)destination);
                String extension = LocatorTools.getExtension((ILocator)destination);
                while (destination.exists()) {
                    destination = parentLocator.getChild(basename + "." + counter++ + "." + extension);
                }
            }
        }
        if (destination.isReadOnly()) {
            String msg = Msg.getString("CommonDocumentTimestampCreator.ExFileReadOnly", new Object[]{destination.getPath()});
            throw new DocumentTimestampException(msg);
        }
        return destination;
    }

    protected ILocator getLocator() {
        return ArgTools.getLocator((IArgs)this.getArgs(), (String)"locator", null, (ILocatorFactory)LocatorFactory.get());
    }

    protected String getLocatorExtension() {
        String extension = ArgTools.getString((IArgs)this.getArgs(), (String)"locatorExtension", null);
        if (!StringTools.isEmpty((String)extension)) {
            return extension;
        }
        return this.getLocatorExtensionDefault();
    }

    protected String getLocatorExtensionDefault() {
        return DEFAULT_LOCATOR_EXTENSION;
    }

    protected Object getTimestampDevice() throws ObjectCreationException {
        Object value = this.getArgs().get("timestampDevice");
        if (value == null) {
            value = ArgTools.getString((IArgs)this.getArgs(), (String)"timestampServiceName", null);
        }
        return value;
    }

    public String getTimestampServiceName() {
        return ArgTools.getString((IArgs)this.getArgs(), (String)"timestampServiceName", null);
    }

    protected abstract boolean isAppend();

    protected boolean isAuthorized() {
        return LicenseEnvironment.get().isAuthorizedProfessional();
    }

    protected abstract boolean isCreateAttachment();

    protected abstract boolean isOverwrite();
}

