/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.processor.timestamp;

import de.intarsys.processor.common.CommonProcessor;
import de.intarsys.security.app.timestamp.ITimestampCreator;
import de.intarsys.security.app.timestamp.ITimestampRequest;
import de.intarsys.security.app.timestamp.ITimestampResponse;
import de.intarsys.security.app.timestamp.PlainTimestampRequest;
import de.intarsys.security.device.timestamp.device.TimestampTools;
import de.intarsys.security.digest.DigestTools;
import de.intarsys.security.timestamp.ITimestampToken;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.digest.IDigester;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.io.IOException;
import java.io.InputStream;

public class TimestampCreator
extends CommonProcessor {
    public static final String ARG_DIGEST = "digest";
    public static final String ARG_DATA = "data";
    public static final String ARG_SERVICENAME = "serviceName";
    private ILocator data;
    private ITimestampToken timestamp;
    private String serviceName;

    public TimestampCreator(IFactory factory) {
        super(factory);
    }

    protected Object basicGetResult() {
        return this.getTimestamp();
    }

    protected void basicRun() throws Exception {
        this.timestamp = this.createTimestamp();
        this.ok();
    }

    protected ITimestampToken createTimestamp() throws Exception {
        ITimestampCreator creator = TimestampTools.createTimestampCreator((Object)this.getTimestampDevice());
        if (creator == null) {
            throw new IOException("No such timestamp device: " + this.getServiceName());
        }
        IDigest digest = this.getDigest();
        if (digest == null) {
            try (InputStream is = this.getData().getInputStream();){
                IDigester digester = DigestTools.getDigesterOrSha1((IArgs)this.getArgs(), (String)"SHA-1");
                digest = de.intarsys.tools.digest.DigestTools.digest((IDigester)digester, (InputStream)is);
            }
        }
        ITimestampResponse response = creator.createTimestamp((ITimestampRequest)new PlainTimestampRequest(digest));
        return response.getTimestamp();
    }

    public ILocator getData() {
        return this.data;
    }

    public IDigest getDigest() {
        return (IDigest)this.getArgs().get(ARG_DIGEST);
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public ITimestampToken getTimestamp() {
        return this.timestamp;
    }

    protected Object getTimestampDevice() throws ObjectCreationException {
        Object value = this.getArgs().get("device");
        if (value == null) {
            value = ArgTools.getString((IArgs)this.getArgs(), (String)ARG_SERVICENAME, null);
        }
        return value;
    }

    public void setData(ILocator data) {
        this.data = data;
    }

    public void setServiceName(String serviceId) {
        this.serviceName = serviceId;
    }
}

