/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.processor.timestamp;

import de.intarsys.claptz.IExtension;
import de.intarsys.claptz.impl.ExtensionPointHandlerAdapter;
import de.intarsys.security.device.DeviceTools;
import de.intarsys.security.device.IDeviceProvider;
import de.intarsys.security.device.common.CommonDevice;
import de.intarsys.security.device.common.CommonDeviceProvider;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.string.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class TimestampDeviceInstaller
extends ExtensionPointHandlerAdapter {
    public static final String XP_TIMESTAMPSERVICES = "com.cabaret.security.timestamp.services";
    public static final String XE_TIMESTAMPSERVICE = "service";
    private static final Logger Log = LoggerFactory.getLogger(TimestampDeviceInstaller.class);

    protected Object basicInstallDelete(IExtension extension, IElement element) {
        if (XE_TIMESTAMPSERVICE.equals(element.getName())) {
            try {
                this.fixFactory(element);
                CommonDevice device = (CommonDevice)ElementTools.createObject((IElement)element, CommonDevice.class, (Object)extension.getProvider(), (IArgs)Args.create());
                CommonDeviceProvider deviceProvider = device.getDeviceProvider();
                CommonDevice tempDevice = (CommonDevice)DeviceTools.lookupDevice((IDeviceProvider)deviceProvider, (String)device.getId());
                if (tempDevice != null) {
                    deviceProvider.unregisterDevice(tempDevice);
                }
                return device;
            }
            catch (ObjectCreationException e) {
                String msg = "error installing extension";
                this.log(Log, Level.ERROR, extension, element, msg, e);
            }
        } else {
            return super.basicInstallDelete(extension, element);
        }
        return null;
    }

    protected Object basicInstallInsert(IExtension extension, IElement element) {
        if (XE_TIMESTAMPSERVICE.equals(element.getName())) {
            try {
                this.fixFactory(element);
                CommonDevice device = (CommonDevice)ElementTools.createObject((IElement)element, CommonDevice.class, (Object)extension.getProvider(), (IArgs)Args.create());
                CommonDeviceProvider deviceProvider = device.getDeviceProvider();
                deviceProvider.registerDevice(device);
                return device;
            }
            catch (ObjectCreationException e) {
                String msg = "error installing extension";
                this.log(Log, Level.ERROR, extension, element, msg, e);
            }
        } else {
            return super.basicInstallInsert(extension, element);
        }
        return null;
    }

    protected Object basicInstallUpdate(IExtension extension, IElement element) {
        if (XE_TIMESTAMPSERVICE.equals(element.getName())) {
            try {
                this.fixFactory(element);
                CommonDevice device = (CommonDevice)ElementTools.createObject((IElement)element, CommonDevice.class, (Object)extension.getProvider(), (IArgs)Args.create());
                CommonDeviceProvider deviceProvider = device.getDeviceProvider();
                CommonDevice tempDevice = (CommonDevice)DeviceTools.lookupDevice((IDeviceProvider)deviceProvider, (String)device.getId());
                if (tempDevice != null) {
                    deviceProvider.registerDevice(device);
                }
                return device;
            }
            catch (ObjectCreationException e) {
                String msg = "error installing extension";
                this.log(Log, Level.ERROR, extension, element, msg, e);
            }
        } else {
            return super.basicInstallUpdate(extension, element);
        }
        return null;
    }

    protected void fixFactory(IElement element) {
        String className = element.attributeValue("class", null);
        if ("com.cabaret.security.app.timestamp.http.HTTPTimestampService".equals(className)) {
            className = "de.intarsys.security.device.httptimestamp.device.HttpTimestampDevice";
        }
        if (!StringTools.isEmpty((String)className)) {
            element.setAttributeValue("factory", className);
            element.setAttributeValue("class", null);
        }
    }
}

