/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.processor.timestamp;

import de.intarsys.document.model.IDocumentType;
import de.intarsys.security.processor.timestamp.IDocumentTimestampCreator;
import de.intarsys.security.processor.timestamp.IDocumentTimestampCreatorFactory;
import de.intarsys.tools.component.SingletonProvider;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.factory.Outlet;
import de.intarsys.tools.preferences.IPreferences;
import de.intarsys.tools.preferences.IPreferencesSupport;
import de.intarsys.tools.preferences.IPreferencesSyncher;
import de.intarsys.tools.preferences.PreferencesFactory;
import de.intarsys.tools.servicelocator.ServiceLocator;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.ArrayList;

@SingletonProvider
public class TimestampEnvironment
implements IPreferencesSupport,
IPreferencesSyncher {
    public static final boolean DEFAULT_AUTO_SAVE_DOCUMENTS = false;
    public static final String PREF_AUTO_SAVE_DOCUMENTS = "auto_save_document";
    private IPreferences preferences;
    private IDocumentTimestampCreatorFactory[] documentTimestampCreatorFactories;
    private boolean autoSaveDocument;

    public static TimestampEnvironment get() {
        return (TimestampEnvironment)ServiceLocator.get().get(TimestampEnvironment.class);
    }

    protected IPreferences createPreferences() {
        String name = this.getPreferencesName();
        IPreferences root = PreferencesFactory.get().getRoot();
        IPreferences result = root.node(name);
        IPreferences defaultPreferences = result.restrict("DEFAULT");
        this.preferencesInit(defaultPreferences);
        return result;
    }

    public IDocumentTimestampCreatorFactory[] getDocumentTimestampCreatorFactories() {
        if (this.documentTimestampCreatorFactories == null) {
            IFactory[] factories = Outlet.get().lookupFactories(IDocumentTimestampCreator.class);
            ArrayList<IDocumentTimestampCreatorFactory> temp = new ArrayList<IDocumentTimestampCreatorFactory>(factories.length);
            for (IFactory factory : factories) {
                if (!(factory instanceof IDocumentTimestampCreatorFactory)) continue;
                temp.add((IDocumentTimestampCreatorFactory)factory);
            }
            this.documentTimestampCreatorFactories = temp.toArray(new IDocumentTimestampCreatorFactory[temp.size()]);
        }
        return this.documentTimestampCreatorFactories;
    }

    public IDocumentTimestampCreatorFactory[] getDocumentTimestampCreatorFactories(IDocumentType docType) {
        ArrayList<IDocumentTimestampCreatorFactory> supporters = new ArrayList<IDocumentTimestampCreatorFactory>();
        for (IDocumentTimestampCreatorFactory factory : this.getDocumentTimestampCreatorFactories()) {
            if (!factory.supports(docType)) continue;
            supporters.add(factory);
        }
        return supporters.toArray(new IDocumentTimestampCreatorFactory[supporters.size()]);
    }

    public final IPreferences getPreferences() {
        if (this.preferences == null) {
            this.preferences = this.createPreferences();
        }
        return this.preferences;
    }

    protected String getPreferencesName() {
        return "de.intarsys.prefs.security.timestamp";
    }

    @PostConstruct
    public void installInstance() {
        this.preferencesRestore();
    }

    public boolean isAutoSaveDocument() {
        return this.autoSaveDocument;
    }

    protected void preferencesInit(IPreferences preferences) {
    }

    public void preferencesRestore() {
        IPreferences preferences = this.getPreferences();
        this.autoSaveDocument = preferences.getBoolean(PREF_AUTO_SAVE_DOCUMENTS, false);
    }

    public void preferencesStore() {
        IPreferences preferences = this.getPreferences();
        preferences.putBoolean(PREF_AUTO_SAVE_DOCUMENTS, this.autoSaveDocument);
    }

    public void setAutoSaveDocument(boolean autoSaveDocument) {
        this.autoSaveDocument = autoSaveDocument;
    }

    @PreDestroy
    public void uninstallInstance() {
        this.preferencesStore();
    }
}

