/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.etsi.rdsc.api.common;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.intarsys.etsi.rdsc.api.common.CertificateStatus;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;

@Schema(description="Used to return signing certificate chain information")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CertificateInfo {
    @Schema(description="X.509v3 certificates from the certificate chain.\nDepending on the value of the parameter `certificates`, the\narray will either contain the entire certificate chain beginning with\nthe end entity certificate (`chain`), contain only the end entity\ncertificate (`single`), or not be included in the response at all (`none`).", format="Base64")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<byte[]> certificates;
    @Schema(description="Status of validity of the end entity certificate. The SCS shall only\nreturn a value that is accurate and consistent with the actual\nvalidity status of the certificate at the time the response is\ngenerated. Otherwise this parameter shall not be included in the\nresponse. \n\nThe valid status shall be returned when the certificate is\nin the validity period, is generated by a CA trusted by the SCS, and is\nnot revoked or suspended. Therefore the SCS shall not include this\nparameter in the response if it cannot check if the signing\ncertificate is revoked, suspended or not.", example="valid")
    private CertificateStatus status;
    @Schema(description="Validity start date of the X.509v3 signing certificate", required=true, format="GeneralizedTime (IETF RFC 5280), `yyyyMMddHHmmss'Z'`", example="20211227235959Z")
    private String validFrom;
    @Schema(description="Validity end date of the X.509v3 signing certificate", required=true, format="GeneralizedTime (IETF RFC 5280), `yyyyMMddHHmmss'Z'`", example="20211227235959Z")
    private String validTo;
    @Schema(description="Issuer of the X.509v3 certificate", required=true, format="Distinguished name in printable string format, UTF-8-encoded according to IETF RFC 4514", example="CN=ACME Root,O=ACME Inc,C=DE")
    @JsonProperty(value="issuerDN")
    private String issuerDn;
    @Schema(description="Subject of the X.509v3 certificate", required=true, format="Distinguished name in printable string format, UTF-8-encoded according to IETF RFC 4514", example="CN=James \\\"Jim\\\" Smith\\, III.,DC=example,DC=net,C=US")
    @JsonProperty(value="subjectDN")
    private String subjectDn;
    @Schema(description="Serial number of the X.509v3 certificate", required=true, format="hex-encoded", example="022af1e62a7839fff82264b11d09fae5")
    private String serialNumber;

    public List<byte[]> getCertificates() {
        return this.certificates;
    }

    public void setCertificates(List<byte[]> certificates) {
        this.certificates = certificates;
    }

    public CertificateStatus getStatus() {
        return this.status;
    }

    public void setStatus(CertificateStatus status) {
        this.status = status;
    }

    public String getValidFrom() {
        return this.validFrom;
    }

    public void setValidFrom(String validFrom) {
        this.validFrom = validFrom;
    }

    public String getValidTo() {
        return this.validTo;
    }

    public void setValidTo(String validTo) {
        this.validTo = validTo;
    }

    public String getIssuerDn() {
        return this.issuerDn;
    }

    public void setIssuerDn(String issuerDn) {
        this.issuerDn = issuerDn;
    }

    public String getSubjectDn() {
        return this.subjectDn;
    }

    public void setSubjectDn(String subjectDn) {
        this.subjectDn = subjectDn;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }
}

