/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.etsi.rdsc.api.common;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;

@Schema(description="Outcome of operations with an HTTP status different from 200 OK")
public class ErrorResponse {
    @Schema(description="Error code. Common codes are:\n\n* `invalid_request`: The request is missing a required parameter,\n  includes an invalid parameter value, includes a parameter more than\n  once, or is otherwise malformed.\n* `unauthorized_client`: The client is not authorized to call the API\n  method.\n* `access_denied`: The user, authorization server, or remote service\n  denied the request.\n* `unsupported_response_type`: The authorization server does not\n  support obtaining an authorization code using this method.\n* `invalid_scope`: The requested scope is invalid, unknown, or\n  malformed.\n* `server_error`: The authorization server encountered an unexpected\n  condition that prevented it from fulfilling the request.\n* `temporarily_unavailable`: The authorization server is currently\n  unable to handle the request due to a temporary overloading or\n  maintenance of the server.\n* `expired_token`: The access or refresh token is expired or has been\n  revoked.\n* `invalid_token`: The token provided is not a valid OAuth access or\n  refresh token.", required=true, example="invalid_request")
    @JsonProperty(value="error")
    private String errorCode;
    @Schema(description="Human readable description, written in a language that considers the\nrequested language, which provides additional information on the\nerror.", example="Required parameter `SAD` is missing")
    @JsonProperty(value="error_description")
    private String errorDescription;

    public ErrorResponse() {
    }

    public ErrorResponse(String errorCode, String errorDescription) {
        this.errorCode = errorCode;
        this.errorDescription = errorDescription;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorDescription() {
        return this.errorDescription;
    }

    public void setErrorDescription(String errorDescription) {
        this.errorDescription = errorDescription;
    }
}

