/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.etsi.rdsc.api.info;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.intarsys.etsi.rdsc.api.common.AuthMode;
import de.intarsys.etsi.rdsc.api.common.OperationMode;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collection;

@Schema(description="Service information response")
public class InfoResponse {
    @Schema(description="Short description of the service", required=true)
    private String description;
    @Schema(description="Name of the service", required=true)
    private String name;
    @Schema(description="URL of a logo for the service", required=true, format="JPEG or PNG, not larger than 256x256 pixels", example="https://example.org/rdsc/logo.png")
    private String logo;
    @Schema(description="Region where the service is operating", required=true, format="ISO 3166-1 alpha-2 country code", example="DE")
    private String region;
    @Schema(description="URI identifying the protocol supported by the SCS", required=true, example="http://uri.etsi.org/19342/v1.1.1/creationprofile#")
    private String protocol;
    @Schema(description="Versions of the protocol specifications supported by the SCS", required=true, format="major.minor.patch")
    private Collection<String> versions;
    @Schema(description="Collection of supported languages", required=true, format="RFC 5646 language tags")
    @JsonProperty(value="lang")
    private Collection<String> languages;
    @Schema(description="Collection of supported signature policies", required=true)
    private Collection<String> signaturePolicies;
    @Schema(description="Collection of supported service policies", required=true)
    private Collection<String> servicePolicies;
    @Schema(description="Collection of supported operation modes", required=true)
    private Collection<OperationMode> operationModes;
    @Schema(description="Collection of supported authentication mechanisms for API access", required=true)
    @JsonProperty(value="authType")
    private Collection<AuthMode> authModes;
    @Schema(description="Collection of supported API method names", required=true)
    private Collection<String> methods;

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLogo() {
        return this.logo;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public Collection<String> getVersions() {
        return this.versions;
    }

    public void setVersions(Collection<String> versions) {
        this.versions = versions;
    }

    public Collection<String> getLanguages() {
        return this.languages;
    }

    public void setLanguages(Collection<String> languages) {
        this.languages = languages;
    }

    public Collection<String> getSignaturePolicies() {
        return this.signaturePolicies;
    }

    public void setSignaturePolicies(Collection<String> signaturePolicies) {
        this.signaturePolicies = signaturePolicies;
    }

    public Collection<String> getServicePolicies() {
        return this.servicePolicies;
    }

    public void setServicePolicies(Collection<String> servicePolicies) {
        this.servicePolicies = servicePolicies;
    }

    public Collection<OperationMode> getOperationModes() {
        return this.operationModes;
    }

    public void setOperationModes(Collection<OperationMode> operationModes) {
        this.operationModes = operationModes;
    }

    public Collection<AuthMode> getAuthModes() {
        return this.authModes;
    }

    public void setAuthModes(Collection<AuthMode> authModes) {
        this.authModes = authModes;
    }

    public Collection<String> getMethods() {
        return this.methods;
    }

    public void setMethods(Collection<String> methods) {
        this.methods = methods;
    }
}

