/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.etsi.rdsc.api.signatures;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.intarsys.etsi.rdsc.api.common.OperationMode;
import de.intarsys.etsi.rdsc.api.signatures.Attribute;
import de.intarsys.etsi.rdsc.api.signatures.Certificates;
import de.intarsys.etsi.rdsc.api.signatures.ConformanceLevel;
import de.intarsys.etsi.rdsc.api.signatures.DocumentDigests;
import de.intarsys.etsi.rdsc.api.signatures.SignatureFormat;
import de.intarsys.etsi.rdsc.api.signatures.SignedEnvelopeProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;

@Schema(description="AdES signature creation request to the signature creation service (SCS)")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SignDocRequest {
    @Schema(description="Operation mode requested to the SCS. One of the following values:\n\n* `A`: asynchronous\n* `S`: synchronous\n", example="S")
    private OperationMode operationMode;
    @Schema(description="Data from the client application generally used to handle a signature\ntransaction identifier")
    @JsonProperty(value="requestID")
    private String requestId;
    @Schema(description="Authentication data used to authorize the use of the signing key", required=true)
    @JsonProperty(value="SAD")
    private String sad;
    @Schema(description="Whether the SCS shall return information about the signing certificate\nchain specified by `certificates` and `certInfo`", defaultValue="false")
    private Boolean returnSigningCertificateInfo;
    @Schema(description="Maximum period of time in milliseconds until which the signature\ncreation service shall keep the request outcome(s) of an asynchronous\nfor the client application retrieval. The period shall be calculated\nstarting from the moment of the asynchronous request acceptance.", example="60000")
    private Integer validityPeriod;
    @Schema(description="Identifier associated to the private key and corresponding certificate")
    @JsonProperty(value="credentialID")
    private String credentialId;
    @Schema(description="Preferred language of the SCS responses.\nIf the requested language is not supported then no error will be raised\nand the response will be produced in the SCS's default language instead.", format="RFC 5646 language tag", example="de-DE")
    private String lang;
    @Schema(description="Specifies which certificates from the certificates chain shall be\nreturned in the SCS response. One of the following values:\n\n* `none`: return no certificate\n* `single`: return only the end entity certificate\n* `chain`: return the full certificate chain", defaultValue="single")
    private Certificates certificates;
    @Schema(description="Whether the SCS shall return information on the end entity certificate\nas printable strings. This parameter shall only be used if `certificates`\nhas a value different from `none`.", defaultValue="false")
    private Boolean certInfo;
    @Schema(description="The number of signatures to be performed in the context of the\ntransaction. This parameter may be used to initiate and manage a\nsequence of an agreed number of signatures to be regarded as a single\nunit of work between the client and SCS. The transaction shall be\nidentified by the `requestID` parameter.")
    private Integer numSignatures;
    @Schema(description="The service policy associated with the SCS. This parameter may be used\nto select a specific service policy if the SCS supports multiple\npolicies, or as a sanity-check to make sure the SCS implements the\nservice policy the client expects.")
    private String policy;
    @Schema(description="The signature creation policy associated with the SCS. This parameter\nshall have a value if `signAlgo` is not specified.")
    @JsonProperty(value="signaturePolicyID")
    private String signaturePolicyId;
    @Schema(description="The OID of the algorithm to be used for signing. This parameter shall\nhave a value if `signaturePolicyID` is not specified.")
    private String signAlgo;
    @Schema(description="Signature parameters. This parameter may only have a value if required\nand/or allowed by the signature algorithm like, for example, the RSAPSS\ncryptographic signature scheme.", format="DER-encoded ASN.1, then Base64-encoded")
    private byte[] signAlgoParams;
    @Schema(description="List of signed attributes. See clause 7.14 of ETSI TS 119 432 for a\nlist of possible attributes.")
    private List<Attribute> signedProps;
    @Schema(description="Identifies the protocol being used by the client application to\ncommunicate with the SCS.", example="http://uri.etsi.org/19432/v1.1.1#/creationprofile#")
    private String profile;
    @Schema(description="Signature format. One of the following values:\n\n* `C`: CAdES\n* `X`: XAdES\n* `P`: PAdES")
    private SignatureFormat signatureFormat;
    @Schema(description="Signature conformance level. One of the following values:\n\n* `AdES-B-B`: 191x2 level B\n* `AdES-B-T`: 191x2 level T\n* `AdES-B-LT`: 191x2 level LT\n* `AdES-B-LTA`: 191x2 level LTA\n* `AdES-B`: etsits level B\n* `AdES-T`: etsits level T\n* `AdES-LT`: etsits level LT\n* `AdES-LTA`: etsits level LTA", defaultValue="AdES-B-B")
    private ConformanceLevel conformanceLevel;
    @Schema(description="Signed envelope type. Possible values depend on the signature format:\n\n* Signature format `CAdES`\n  - `Detached`\n  - `Attached`\n  - `Parallel`\n* Signature format `PAdES`\n  - `Certification`\n  - `Revision`\n* Signature format `XAdES`\n  - `Enveloped`\n  - `Enveloping`\n  - `Detached`")
    private SignedEnvelopeProperty signedEnvelopeProperty;
    @Schema(description="Location where the client expects to receive a notification when the\nSCS has completed the requested operation.")
    private String responseUri;
    @Schema(description="Document content(s) to be signed. Either `documents` or\n`documentDigests` must be given -- they are mutually exclusive.", format="Base64")
    private List<byte[]> documents;
    @Schema(description="Hashes to be signed and the algorithm OID used to calculate those\nhashes. Either `documents` or `documentDigests` must be given --\nthey are mutually exclusive.")
    private DocumentDigests documentDigests;

    public OperationMode getOperationMode() {
        return this.operationMode;
    }

    public void setOperationMode(OperationMode operationMode) {
        this.operationMode = operationMode;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public String getSad() {
        return this.sad;
    }

    public void setSad(String sad) {
        this.sad = sad;
    }

    public Boolean getReturnSigningCertificateInfo() {
        return this.returnSigningCertificateInfo;
    }

    public void setReturnSigningCertificateInfo(Boolean returnSigningCertificateInfo) {
        this.returnSigningCertificateInfo = returnSigningCertificateInfo;
    }

    public Integer getValidityPeriod() {
        return this.validityPeriod;
    }

    public void setValidityPeriod(Integer validityPeriod) {
        this.validityPeriod = validityPeriod;
    }

    public String getCredentialId() {
        return this.credentialId;
    }

    public void setCredentialId(String credentialId) {
        this.credentialId = credentialId;
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public Certificates getCertificates() {
        return this.certificates;
    }

    public void setCertificates(Certificates certificates) {
        this.certificates = certificates;
    }

    public Boolean getCertInfo() {
        return this.certInfo;
    }

    public void setCertInfo(Boolean certInfo) {
        this.certInfo = certInfo;
    }

    public Integer getNumSignatures() {
        return this.numSignatures;
    }

    public void setNumSignatures(Integer numSignatures) {
        this.numSignatures = numSignatures;
    }

    public String getPolicy() {
        return this.policy;
    }

    public void setPolicy(String policy) {
        this.policy = policy;
    }

    public String getSignaturePolicyId() {
        return this.signaturePolicyId;
    }

    public void setSignaturePolicyId(String signaturePolicyId) {
        this.signaturePolicyId = signaturePolicyId;
    }

    public String getSignAlgo() {
        return this.signAlgo;
    }

    public void setSignAlgo(String signAlgo) {
        this.signAlgo = signAlgo;
    }

    public byte[] getSignAlgoParams() {
        return this.signAlgoParams;
    }

    public void setSignAlgoParams(byte[] signAlgoParams) {
        this.signAlgoParams = signAlgoParams;
    }

    public List<Attribute> getSignedProps() {
        return this.signedProps;
    }

    public void setSignedProps(List<Attribute> signedProps) {
        this.signedProps = signedProps;
    }

    public String getProfile() {
        return this.profile;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public SignatureFormat getSignatureFormat() {
        return this.signatureFormat;
    }

    public void setSignatureFormat(SignatureFormat signatureFormat) {
        this.signatureFormat = signatureFormat;
    }

    public ConformanceLevel getConformanceLevel() {
        return this.conformanceLevel;
    }

    public void setConformanceLevel(ConformanceLevel conformanceLevel) {
        this.conformanceLevel = conformanceLevel;
    }

    public SignedEnvelopeProperty getSignedEnvelopeProperty() {
        return this.signedEnvelopeProperty;
    }

    public void setSignedEnvelopeProperty(SignedEnvelopeProperty signedEnvelopeProperty) {
        this.signedEnvelopeProperty = signedEnvelopeProperty;
    }

    public String getResponseUri() {
        return this.responseUri;
    }

    public void setResponseUri(String responseUri) {
        this.responseUri = responseUri;
    }

    public List<byte[]> getDocuments() {
        return this.documents;
    }

    public void setDocuments(List<byte[]> documents) {
        this.documents = documents;
    }

    public DocumentDigests getDocumentDigests() {
        return this.documentDigests;
    }

    public void setDocumentDigests(DocumentDigests documentDigests) {
        this.documentDigests = documentDigests;
    }
}

