/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.etsi.rdsc.api.signatures;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.intarsys.etsi.rdsc.api.common.CertificateInfo;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;

@Schema(description="AdES signature creation response from signature creation service (SCS)")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(value={"policy", "signaturePolicyID", "signaturePolicyLocations"})
public class SignDocResponse {
    @Schema(description="Signatures enveloped within the documents. Only returned, if the\nclient application requested the creation of signature(s) enveloped within\nthe signed document(s).", format="Base64")
    @JsonProperty(value="DocumentWithSignature")
    private List<byte[]> envelopedSignatures;
    @Schema(description="Signatures detached from the documents. Only returned, if the client\napplication requested the creation of signature(s) not enveloped within the\nsigned document(s).", format="Base64")
    @JsonProperty(value="SignatureObject")
    private List<byte[]> detachedSignatures;
    private String policy;
    @Schema(description="Information about the signing certificate chain use for the signature\ncreation. This information is only returned if the parameter `certInfo`\nin the signature creation request is true.")
    @JsonProperty(value="cert")
    private CertificateInfo certificateInfo;
    @Schema(description="Arbitrary value generated by the SCS uniquely identifying the response\noriginated from the SCS itself. This value is mainly used in\nasynchronous operation mode where the client application shall provide\nthe `responseID` value received with the initial response as\n`requestID` of any subsequent request polling the pending signature\nresults.")
    @JsonProperty(value="responseID")
    private String responseId;

    public List<byte[]> getEnvelopedSignatures() {
        return this.envelopedSignatures;
    }

    public void setEnvelopedSignatures(List<byte[]> envelopedSignatures) {
        this.envelopedSignatures = envelopedSignatures;
    }

    public List<byte[]> getDetachedSignatures() {
        return this.detachedSignatures;
    }

    public void setDetachedSignatures(List<byte[]> detachedSignatures) {
        this.detachedSignatures = detachedSignatures;
    }

    public String getPolicy() {
        return this.policy;
    }

    public void setPolicy(String policy) {
        this.policy = policy;
    }

    public CertificateInfo getCertificateInfo() {
        return this.certificateInfo;
    }

    public void setCertificateInfo(CertificateInfo certificateInfo) {
        this.certificateInfo = certificateInfo;
    }

    public String getResponseId() {
        return this.responseId;
    }

    public void setResponseId(String responseId) {
        this.responseId = responseId;
    }
}

