/*
 * Decompiled with CFR 0.152.
 */
package de.bdr.signme.api;

import jakarta.xml.ws.BindingProvider;
import jakarta.xml.ws.Service;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClient<SRV extends Service, SRV_IF> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractClient.class);
    private static final int TCP_TIMEOUT_MS_MIN = 5000;
    private static final int TCP_CONNECT_TIMOUT_MS_DEF = 5000;
    private static final int TCP_READ_TIMOUT_MS_DEF = 60000;
    private final String endpointAddrStr;
    private final Class<? extends Service> serviceClass;
    private final Class<SRV_IF> serviceInterfaceClass;
    private SRV_IF service = null;
    private final String clientIpAddress;
    private List<String> allClientIpAddresses;
    private String basicAuthUsername;
    private String basicAuthPw;
    private String proxyIpAddress;
    private int proxyPort;
    private String proxyUsername;
    private String proxyPw;
    private int connectTimeoutMs = 5000;
    private int readTimeoutMs = 60000;
    private SSLContext sslContext;

    public AbstractClient(String endpointAddrStr, Class<? extends Service> serviceClass, Class<SRV_IF> serviceInterfaceClass) {
        if (endpointAddrStr == null || endpointAddrStr.length() <= 0) {
            throw new IllegalArgumentException("endpointAddrStr must not be null or empty");
        }
        if (serviceClass == null) {
            throw new IllegalArgumentException("serviceClass must not be null");
        }
        if (serviceInterfaceClass == null) {
            throw new IllegalArgumentException("serviceInterfaceClass must not be null");
        }
        try {
            new URL(endpointAddrStr);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("endpointAddrStr is not a correct service URL: " + e.getMessage());
        }
        LOG.info("Using service URL: " + endpointAddrStr);
        this.endpointAddrStr = endpointAddrStr;
        this.serviceClass = serviceClass;
        this.serviceInterfaceClass = serviceInterfaceClass;
        try {
            this.clientIpAddress = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException("cannot read clientIpAddress (no interface configured?): " + e.getMessage());
        }
    }

    public final List<String> getAllClientIpAddresses() {
        if (this.allClientIpAddresses == null) {
            try {
                String hostname = InetAddress.getLocalHost().getHostName();
                InetAddress[] clientInetAddresses = InetAddress.getAllByName(hostname);
                ArrayList<String> allClientIpAddressesMtbl = new ArrayList<String>(clientInetAddresses.length);
                for (InetAddress clientInetAddress : clientInetAddresses) {
                    allClientIpAddressesMtbl.add(clientInetAddress.getHostAddress());
                }
                this.allClientIpAddresses = Collections.unmodifiableList(allClientIpAddressesMtbl);
            }
            catch (UnknownHostException e) {
                throw new IllegalStateException("cannot read allClientIpAddresses (no interface configured?): " + e.getMessage());
            }
        }
        return this.allClientIpAddresses;
    }

    public final String getClientIpAddress() {
        return this.clientIpAddress;
    }

    public final int getConnectTimeoutMs() {
        return this.connectTimeoutMs;
    }

    protected final String getEndpointAddrStr() {
        return this.endpointAddrStr;
    }

    protected final String getName() {
        return this.serviceInterfaceClass.getSimpleName();
    }

    public final int getReadTimeoutMs() {
        return this.readTimeoutMs;
    }

    protected final SRV_IF getService() {
        if (this.service == null) {
            this.getServiceAndSetEndpointAddress();
            LOG.info("service: " + this.service.toString());
            Client client = ClientProxy.getClient(this.service);
            this.initTimeoutConfiguration(client);
            this.initProxyConfigurationIfNeeded(client);
            this.initTlsConfigurationIfNeeded(client);
        }
        return this.service;
    }

    private void getServiceAndSetEndpointAddress() {
        Service service_Service;
        try {
            service_Service = this.serviceClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            LOG.error("service error in instantiation");
            throw new IllegalStateException(e);
        }
        this.service = service_Service.getPort(this.serviceInterfaceClass);
        this.setEndpointAddress(this.service);
        LOG.info("service (from getPort()): " + this.service.toString());
    }

    protected SSLContext getSslContext() {
        return this.sslContext;
    }

    private void initProxyConfigurationIfNeeded(Client client) {
        if (client == null) {
            throw new IllegalArgumentException("client must not be null");
        }
        if (this.proxyIpAddress != null && !this.proxyIpAddress.isEmpty()) {
            Client proxyClient = client;
            HTTPConduit proxyClientConduit = (HTTPConduit)proxyClient.getConduit();
            proxyClientConduit.getClient().setProxyServer(this.proxyIpAddress);
            if (this.proxyPort > 0) {
                proxyClientConduit.getClient().setProxyServerPort(Integer.valueOf(this.proxyPort));
            }
            if (this.proxyUsername != null && !this.proxyUsername.isEmpty()) {
                proxyClientConduit.getProxyAuthorization().setUserName(this.proxyUsername);
            }
            if (this.proxyPw != null && !this.proxyPw.isEmpty()) {
                proxyClientConduit.getProxyAuthorization().setPassword(this.proxyPw);
            }
        }
    }

    private void initTimeoutConfiguration(Client client) {
        if (client == null) {
            throw new IllegalArgumentException("client must not be null");
        }
        HTTPConduit httpConduit = (HTTPConduit)client.getConduit();
        HTTPClientPolicy clientPolicy = httpConduit.getClient();
        clientPolicy.setConnectionTimeout((long)this.connectTimeoutMs);
        clientPolicy.setReceiveTimeout((long)this.readTimeoutMs);
    }

    private void initTlsConfigurationIfNeeded(Client client) {
        if (this.getSslContext() == null) {
            return;
        }
        HTTPConduit conduit = (HTTPConduit)client.getConduit();
        TLSClientParameters tlsClientParameters = conduit.getTlsClientParameters();
        if (tlsClientParameters == null) {
            tlsClientParameters = new TLSClientParameters();
            conduit.setTlsClientParameters(tlsClientParameters);
        }
        tlsClientParameters.setSSLSocketFactory(this.getSslContext().getSocketFactory());
    }

    public final void resetService() {
        this.service = null;
    }

    public final void setBasicAuthConfiguration(String basicAuthUsername, String basicAuthPw) {
        this.basicAuthUsername = basicAuthUsername;
        this.basicAuthPw = basicAuthPw;
        this.resetService();
    }

    private void setEndpointAddress(SRV_IF service) {
        Map requestContext = ((BindingProvider)service).getRequestContext();
        requestContext.put("jakarta.xml.ws.service.endpoint.address", this.endpointAddrStr);
        if (this.basicAuthUsername != null) {
            requestContext.put("jakarta.xml.ws.security.auth.username", this.basicAuthUsername);
            requestContext.put("jakarta.xml.ws.security.auth.password", this.basicAuthPw);
        }
    }

    public final void setProxyConfiguration(String proxyIpAddress, int proxyPort, String proxyUsername, String proxyPw) {
        this.proxyIpAddress = proxyIpAddress;
        this.proxyPort = proxyPort;
        this.proxyUsername = proxyUsername;
        this.proxyPw = proxyPw;
        this.resetService();
    }

    public void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public final void setTcpTimeoutsMs(int connectTimeoutMs, int readTimeoutMs) {
        if (connectTimeoutMs < 5000) {
            throw new IllegalArgumentException("connectTimeoutMs must be >=5000ms, but was: " + connectTimeoutMs);
        }
        if (readTimeoutMs < 5000) {
            throw new IllegalArgumentException("readTimeoutMs must be >=5000ms, but was: " + readTimeoutMs);
        }
        this.connectTimeoutMs = connectTimeoutMs;
        this.readTimeoutMs = readTimeoutMs;
        this.resetService();
    }

    public final String toString() {
        return this.getName() + ": " + this.getClientIpAddress() + "-->>" + this.getEndpointAddrStr();
    }
}

