/*
 * Decompiled with CFR 0.152.
 */
package de.bdr.signme.api.v2;

import java.math.BigInteger;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.datatype.XMLGregorianCalendar;

public final class ApiStringifier {
    private static final int MAX_LIST_LEN = 20;
    private static final int MAX_BYTEARRAY_LEN = 12;
    private static final int MAX_STRING_LEN = 256;
    private static final DateTimeFormatter DTFMT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss,SSSX");
    private final List<JSONValueAppender> appenderChain = new ArrayList<JSONValueAppender>();
    private final Map<String, SpecialContentType> specials = new HashMap<String, SpecialContentType>(200);

    public ApiStringifier() {
        this.appenderChain.add(this::appendValue);
    }

    public void initialAdd(JSONValueAppender appender) {
        Objects.requireNonNull(appender);
        this.appenderChain.add(0, appender);
        appender.setApiStringifier(this);
        this.addSpecialContentTypeMappings(appender.getSpecialContentTypes());
    }

    private SpecialContentType getSpecialContentType(String name) {
        SpecialContentType sct = this.specials.get(name.toLowerCase());
        if (sct != null) {
            return sct;
        }
        return SpecialContentType.NONE;
    }

    private void addSpecialContentTypeMappings(List<JSONValueAppender.SpecialContentTypeMapping> mappings) {
        for (JSONValueAppender.SpecialContentTypeMapping newMapping : mappings) {
            SpecialContentType existingType = this.specials.get(newMapping.contentName);
            if (existingType != null) {
                if (existingType == newMapping.specialContentType) continue;
                throw new IllegalArgumentException("inconsistent special content type mapping for " + newMapping.contentName + " new: " + newMapping.specialContentType + " existing: " + existingType);
            }
            this.specials.put(newMapping.contentName, newMapping.specialContentType);
        }
    }

    public String toStringWithMsg(String message, Object ... nameValues) {
        StringBuilder builder = new StringBuilder();
        if (message != null) {
            builder.append(message);
            builder.append(' ');
        }
        this.appendAsNameValues(builder, nameValues);
        return builder.toString();
    }

    public String toString(Object ... nameValues) {
        return this.toStringWithMsg(null, nameValues);
    }

    private void appendAsNameValues(StringBuilder sb, Object ... nameValues) {
        int i;
        Objects.requireNonNull(sb);
        if (nameValues == null) {
            throw new IllegalArgumentException("nameValues must not be null");
        }
        if (nameValues.length < 2) {
            throw new IllegalArgumentException("nameValues must contain at least 2 arguments as name value pair (String,Object)");
        }
        this.appendOpenList(sb);
        for (i = 0; i < Math.min(nameValues.length, 20); i += 2) {
            Object nameObj = nameValues[i];
            if (nameObj == null) {
                throw new IllegalArgumentException("nameValues argument at index " + i + " must contain name of class String of value pair (String,Object), but was null");
            }
            if (!(nameObj instanceof String)) {
                throw new IllegalArgumentException("nameValues argument at index " + i + " must contain name of class String of value pair (String,Object), but was of class " + nameObj.getClass());
            }
            String name = (String)nameObj;
            if (i + 1 >= nameValues.length) {
                throw new IllegalArgumentException("nameValues argument at index " + (i + 1) + " must contain value of value pair (String,Object), but not present in list");
            }
            Object value = nameValues[i + 1];
            this.appendAsNameValue(sb, name, value, i == 0);
        }
        this.appendCloseList(sb, i == 0);
    }

    public void appendAsNameValue(StringBuilder sb, String name, Object value) {
        this.appendAsNameValue(sb, name, value, false);
    }

    public void appendAsNameValue(StringBuilder sb, String name, Object value, boolean first) {
        Objects.requireNonNull(sb);
        Objects.requireNonNull(name);
        if (value != null || first) {
            if (!first) {
                this.appendContinue(sb);
            } else {
                this.appendFirst(sb);
            }
            this.appendNameOpen(sb);
            sb.append(name);
            this.appendNameClose(sb);
            this.appendNVSeparator(sb);
            if (value != null) {
                this.appendValueByChain(sb, name, value);
            } else {
                this.appendNullValue(sb);
            }
        }
    }

    private void appendValueByChain(StringBuilder sb, String name, Object value) {
        JSONValueAppender appender;
        boolean appended;
        Iterator<JSONValueAppender> iterator = this.appenderChain.iterator();
        while (iterator.hasNext() && !(appended = (appender = iterator.next()).appendValue(sb, name, value))) {
        }
    }

    private boolean appendValue(StringBuilder sb, String name, Object value) {
        Objects.requireNonNull(value);
        if (value instanceof List) {
            this.appendList(sb, name, (List)value);
        } else if (value instanceof String) {
            SpecialContentType specialContentType = this.getSpecialContentType(name);
            switch (specialContentType) {
                case ID: {
                    this.appendId(sb, (String)value);
                    break;
                }
                case PDATA: {
                    this.appendAnon(sb, (String)value);
                    break;
                }
                case SECRET: {
                    this.appendSecret(sb);
                    break;
                }
                default: {
                    this.appendString(sb, (String)value);
                    break;
                }
            }
        } else if (value instanceof byte[]) {
            SpecialContentType specialContentType = this.getSpecialContentType(name);
            switch (specialContentType) {
                case SECRET: {
                    this.appendSecret(sb);
                    break;
                }
                default: {
                    this.appendBytesAsHexBin(sb, (byte[])value);
                    break;
                }
            }
        } else if (value instanceof Number) {
            this.appendNumber(sb, (Number)value);
        } else if (value instanceof Boolean) {
            this.appendBoolean(sb, (Boolean)value);
        } else if (value instanceof XMLGregorianCalendar) {
            this.appendXMLDateTime(sb, (XMLGregorianCalendar)value);
        } else if (value instanceof ZonedDateTime) {
            this.appendZonedDateTime(sb, (ZonedDateTime)value);
        } else if (value instanceof Date) {
            this.appendDate(sb, (Date)value);
        } else if (value instanceof Enum) {
            this.appendString(sb, value.toString());
        } else {
            this.appendJSONValue(sb, value.toString());
        }
        return true;
    }

    private <T> void appendList(StringBuilder sb, String name, List<T> values) {
        this.appendOpenList(sb);
        int i = 0;
        for (T value : values) {
            if (i > 0) {
                this.appendContinue(sb);
            } else {
                this.appendFirst(sb);
            }
            if (i++ < 20) {
                if (value != null) {
                    this.appendValueByChain(sb, name, value);
                    continue;
                }
                this.appendNullValue(sb);
                continue;
            }
            sb.append("...(");
            sb.append(values.size());
            sb.append(")");
            break;
        }
        this.appendCloseList(sb, i == 0);
    }

    private void appendJSONValue(StringBuilder sb, String value) {
        sb.append(value);
    }

    private void appendString(StringBuilder sb, String value) {
        this.appendQuoteOpen(sb);
        if (value.length() > 256) {
            sb.append(value.substring(0, 256));
            sb.append("...(");
            sb.append(value.length());
            sb.append(")");
        } else {
            sb.append(value);
        }
        this.appendQuoteClose(sb);
    }

    private void appendNumber(StringBuilder sb, Number value) {
        sb.append(value);
    }

    private void appendBoolean(StringBuilder sb, Boolean value) {
        sb.append(value);
    }

    private void appendBytesAsHexBin(StringBuilder sb, byte[] value) {
        this.appendQuoteOpen(sb);
        if (value.length > 12) {
            sb.append(new BigInteger(1, value, 0, 12).toString(16));
            sb.append("...(");
            sb.append(value.length);
            sb.append(")");
        } else {
            sb.append(new BigInteger(1, value).toString(16));
        }
        this.appendQuoteClose(sb);
    }

    private void appendId(StringBuilder sb, String value) {
        this.appendQuoteOpen(sb);
        int len = value.length();
        if (len <= 7) {
            sb.append(value);
        } else {
            sb.append(value.substring(0, 3));
            sb.append('%');
            sb.append(value.substring(len - 3));
        }
        this.appendQuoteClose(sb);
    }

    private void appendAnon(StringBuilder sb, String value) {
        this.appendQuoteOpen(sb);
        int len = value.length();
        if (len <= 3) {
            sb.append("...");
        } else {
            sb.append(value.charAt(0));
            sb.append("...");
            sb.append(value.charAt(len - 1));
        }
        this.appendQuoteClose(sb);
    }

    private void appendSecret(StringBuilder sb) {
        this.appendQuoteOpen(sb);
        sb.append("***");
        this.appendQuoteClose(sb);
    }

    private void appendXMLDateTime(StringBuilder sb, XMLGregorianCalendar value) {
        Instant instValue = value.toGregorianCalendar().getTime().toInstant();
        ZonedDateTime zdtValue = ZonedDateTime.ofInstant(instValue, value.getTimeZone(0).toZoneId());
        this.appendZonedDateTime(sb, zdtValue);
    }

    private void appendZonedDateTime(StringBuilder sb, ZonedDateTime zdtValue) {
        this.appendQuoteOpen(sb);
        sb.append(DTFMT.format(zdtValue));
        this.appendQuoteClose(sb);
    }

    private void appendDate(StringBuilder sb, Date value) {
        Instant instValue = Instant.ofEpochMilli(value.getTime());
        ZonedDateTime zdtValue = ZonedDateTime.ofInstant(instValue, ZoneId.systemDefault());
        this.appendZonedDateTime(sb, zdtValue);
    }

    public void appendOpenStruct(StringBuilder sb) {
        sb.append("{");
    }

    public void appendCloseStruct(StringBuilder sb) {
        sb.append(" }");
    }

    public void appendOpenList(StringBuilder sb) {
        sb.append("[");
    }

    public void appendCloseList(StringBuilder sb, boolean wasEmpty) {
        if (wasEmpty) {
            sb.append("]");
        } else {
            sb.append(" ]");
        }
    }

    public void appendFirst(StringBuilder sb) {
        sb.append(" ");
    }

    public void appendContinue(StringBuilder sb) {
        sb.append(", ");
    }

    public void appendNameOpen(StringBuilder sb) {
        sb.append("\"");
    }

    public void appendNameClose(StringBuilder sb) {
        sb.append("\"");
    }

    public void appendNVSeparator(StringBuilder sb) {
        sb.append(": ");
    }

    public void appendQuoteOpen(StringBuilder sb) {
        sb.append("\"");
    }

    public void appendQuoteClose(StringBuilder sb) {
        sb.append("\"");
    }

    private void appendNullValue(StringBuilder sb) {
        sb.append("null");
    }

    @FunctionalInterface
    public static interface JSONValueAppender {
        public <T> boolean appendValue(StringBuilder var1, String var2, T var3);

        default public void setApiStringifier(ApiStringifier apiStringifier) {
        }

        default public List<SpecialContentTypeMapping> getSpecialContentTypes() {
            return Collections.emptyList();
        }

        public static class SpecialContentTypeMapping {
            public final String contentName;
            public final SpecialContentType specialContentType;

            public SpecialContentTypeMapping(String contentName, SpecialContentType specialContentType) {
                this.contentName = Objects.requireNonNull(contentName).toLowerCase();
                this.specialContentType = Objects.requireNonNull(specialContentType);
            }
        }
    }

    public static enum SpecialContentType {
        NONE,
        ID,
        PDATA,
        SECRET;

    }
}

