/*
 * Decompiled with CFR 0.152.
 */
package de.bdr.signme.api.v2;

import de.bdr.signme.api.v2.ECDSAChallengeSignerDNScanner;
import de.bdr.signme.api.v2.ECDSAKeyStore;
import java.io.File;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.util.Objects;

public final class ECDSAChallengeSigner {
    public static final String SIGN_ALGO = "SHA512withECDSA";
    private static final SecureRandom secureRandom = new SecureRandom();
    private final ECDSAKeyStore keyStore;
    private final X509Certificate x509Certificate;
    private final ECDSAChallengeSignerDNScanner subjectDNScanner;

    public ECDSAChallengeSigner(File keyStoreFile, char[] keystorePw, String keyPairAlias) throws IllegalArgumentException, IllegalStateException {
        this.keyStore = new ECDSAKeyStore(keyStoreFile, keystorePw, keyPairAlias);
        this.x509Certificate = this.keyStore.getX509Certificate();
        this.subjectDNScanner = new ECDSAChallengeSignerDNScanner(this.x509Certificate);
    }

    public ECPublicKey getPublicKey() {
        return this.keyStore.getPublicKey();
    }

    public X509Certificate getX509Certificate() {
        return this.x509Certificate;
    }

    public final String getUsername() {
        return this.subjectDNScanner.getUsername();
    }

    public String getSignAlgo() {
        return SIGN_ALGO;
    }

    public byte[] sign(byte[] challengeToBeSigned) throws IllegalStateException {
        Objects.requireNonNull(challengeToBeSigned, "digest");
        try {
            Signature signatureGenerator = Signature.getInstance(SIGN_ALGO);
            signatureGenerator.initSign(this.keyStore.getPrivate(), secureRandom);
            signatureGenerator.update(challengeToBeSigned);
            byte[] signature = signatureGenerator.sign();
            return signature;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new IllegalStateException("challenge sign does not work", e);
        }
    }

    public void destroy() {
        this.keyStore.destroy();
    }
}

