/*
 * Decompiled with CFR 0.152.
 */
package de.bdr.signme.api.v2;

import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ECDSAChallengeSignerDNScanner {
    private final Logger LOG = LoggerFactory.getLogger(ECDSAChallengeSignerDNScanner.class);
    private static final int MAX_USERNAME_LEN = 80;
    private final String serialNumber;
    private final String commonName;
    private final String organization;
    private final String organizationUnit;
    private final String subjectSerialId_oid2_5_4_5;
    private final String orgId_oid2_5_4_97;
    private final String country;
    private final String locality;
    private final String username;

    public ECDSAChallengeSignerDNScanner(X509Certificate x509Certificate) {
        Objects.requireNonNull(x509Certificate, "x509Certificate");
        this.serialNumber = this.getSerialNumber(x509Certificate);
        Map<String, String> subjectDNPartsMap = this.getSubjectDNPartsMap(x509Certificate);
        this.commonName = this.getValueForLabel(subjectDNPartsMap, "CN", "commonName");
        this.organization = this.getValueForLabel(subjectDNPartsMap, "O", "organization");
        this.organizationUnit = this.getValueForLabel(subjectDNPartsMap, "OU", "organizationUnit");
        this.country = this.getValueForLabel(subjectDNPartsMap, "C", "country");
        this.locality = this.getValueForLabel(subjectDNPartsMap, "L", "locality");
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("commonName: " + this.commonName + " organization: " + this.organization + " organizationUnit: " + this.organizationUnit + " country: " + this.country + " locality: " + this.locality);
        }
        this.subjectSerialId_oid2_5_4_5 = this.getSubjectSerialId_oid2_5_4_5(subjectDNPartsMap);
        this.orgId_oid2_5_4_97 = this.getOrgId_oid2_5_4_97(subjectDNPartsMap);
        this.username = ECDSAChallengeSignerDNScanner.getUsername(this.commonName, this.serialNumber);
    }

    @Nonnull
    protected static final String getUsername(String commonName, String serialNumber) {
        int snLen = serialNumber.length();
        int cnMaxLen = 80 - snLen - 1;
        return ECDSAChallengeSignerDNScanner.transformCommonName(commonName, cnMaxLen) + "_" + serialNumber;
    }

    private static String transformCommonName(String cn, int maxLen) {
        int cnPartLen = Math.min(maxLen, cn.length());
        StringBuffer sb = new StringBuffer(cnPartLen);
        block3: for (int i = 0; i < cnPartLen; ++i) {
            char ch = cn.charAt(i);
            if (Character.isLetterOrDigit(ch)) {
                sb.append(Character.toLowerCase(ch));
                continue;
            }
            switch (ch) {
                case '&': 
                case '+': 
                case '-': 
                case '.': 
                case '_': {
                    sb.append(ch);
                    continue block3;
                }
                default: {
                    sb.append('_');
                }
            }
        }
        return sb.toString();
    }

    @Nonnull
    private String getSerialNumber(X509Certificate x509Certificate) {
        String serialNumber = x509Certificate.getSerialNumber().toString();
        if (serialNumber == null || serialNumber.isEmpty()) {
            String message = "serialNumber cannot be decoded: " + serialNumber;
            this.LOG.error(message);
            throw new IllegalStateException(message);
        }
        return serialNumber;
    }

    @Nonnull
    private Map<String, String> getSubjectDNPartsMap(X509Certificate x509Certificate) {
        String subjectDN = x509Certificate.getSubjectX500Principal().getName();
        this.LOG.info("subjectDN: " + subjectDN);
        String[] subjectDNParts = subjectDN.split(",");
        Map<String, String> subjectDNPartsMap = Stream.of(subjectDNParts).map(e -> e.split("=")).collect(Collectors.toUnmodifiableMap(nvp -> nvp[0], nvp -> nvp[1]));
        return subjectDNPartsMap;
    }

    @Nonnull
    private String getValueForLabel(Map<String, String> subjectDNPartsMap, String labelInCert, String labelInLog) {
        String value = subjectDNPartsMap.get(labelInCert);
        if (value == null || value.isEmpty()) {
            String message = labelInLog + " cannot be decoded: " + value;
            this.LOG.error(message);
            throw new IllegalStateException(message);
        }
        return value;
    }

    @Nonnull
    private String getSubjectSerialId_oid2_5_4_5(Map<String, String> subjectDNPartsMap) {
        String oid2_5_4_5 = subjectDNPartsMap.get("2.5.4.5");
        try {
            String oid2_5_4_5x = oid2_5_4_5.substring(1);
            String subjectSerialId_oid2_5_4_5 = new String(new BigInteger(oid2_5_4_5x, 16).toByteArray()).trim();
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("subjectSerialId_oid2_5_4_5: " + subjectSerialId_oid2_5_4_5);
            }
            return subjectSerialId_oid2_5_4_5;
        }
        catch (Exception e) {
            String message = "subjectSerialId_oid2_5_4_5 cannot be decoded: " + oid2_5_4_5;
            this.LOG.error(message, (Throwable)e);
            throw new IllegalStateException(message, e);
        }
    }

    @Nonnull
    private String getOrgId_oid2_5_4_97(Map<String, String> subjectDNPartsMap) {
        String oid2_5_4_97 = subjectDNPartsMap.get("2.5.4.97");
        try {
            String oid2_5_4_97x = oid2_5_4_97.substring(1);
            String orgId_oid2_5_4_97 = new String(new BigInteger(oid2_5_4_97x, 16).toByteArray()).trim();
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("orgId_oid2_5_4_97: " + orgId_oid2_5_4_97);
            }
            return orgId_oid2_5_4_97;
        }
        catch (Exception e) {
            String message = "orgId_oid2_5_4_97 cannot be decoded: " + oid2_5_4_97;
            this.LOG.error(message, (Throwable)e);
            throw new IllegalStateException(message, e);
        }
    }

    @Nonnull
    public String getSerialNumber() {
        return this.serialNumber;
    }

    @Nonnull
    public String getCommonName() {
        return this.commonName;
    }

    @Nonnull
    public String getOrganization() {
        return this.organization;
    }

    @Nonnull
    public String getOrganizationUnit() {
        return this.organizationUnit;
    }

    @Nonnull
    public String getCountry() {
        return this.country;
    }

    @Nonnull
    public String getLocality() {
        return this.locality;
    }

    @Nonnull
    public String getSubjectSerialId_oid2_5_4_5() {
        return this.subjectSerialId_oid2_5_4_5;
    }

    @Nonnull
    public String getOrgId_oid2_5_4_97() {
        return this.orgId_oid2_5_4_97;
    }

    @Nonnull
    public String getUsername() {
        return this.username;
    }
}

