/*
 * Decompiled with CFR 0.152.
 */
package de.bdr.signme.api.v2;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.Objects;

public class HashedIdHelper {
    private static final String SHA_256_ALGO = "SHA-256";
    private static final String OID_ADDITIONAL_INFO_EXT_1_3_36_8_3_15 = "1.3.36.8.3.15";
    private static final String HASHED_ID_PREFIX = "ID:";
    private static final int HASHED_ID_PREFIX_LEN = "ID:".length();
    private static final int EXT_HEADER_LEN = 4;
    private static final String ERROR_MSG = "certificate does not contain hashed id prefix in extension with OID=1.3.36.8.3.15";

    public static String getHashedIdFromIdentityId(String identityId) throws NoSuchAlgorithmException {
        Objects.requireNonNull(identityId, "identityId");
        MessageDigest sha256 = MessageDigest.getInstance(SHA_256_ALGO);
        byte[] hashedId = sha256.digest(identityId.getBytes());
        String hashedIdBase64 = new String(Base64.getEncoder().encode(hashedId));
        return hashedIdBase64;
    }

    public static String getHashedIdFromCertificate(X509Certificate certificate) throws IllegalArgumentException {
        String hashedIdFromCertBase64;
        Objects.requireNonNull(certificate, "certificate");
        byte[] extensionAdditionalInformation = certificate.getExtensionValue(OID_ADDITIONAL_INFO_EXT_1_3_36_8_3_15);
        String additionalInformation = new String(extensionAdditionalInformation, 4, extensionAdditionalInformation.length - 4, StandardCharsets.UTF_8);
        int idIndex = additionalInformation.indexOf(HASHED_ID_PREFIX);
        if (idIndex == -1) {
            throw new IllegalArgumentException(ERROR_MSG);
        }
        int semiIndex = additionalInformation.indexOf(59);
        if (semiIndex == -1) {
            throw new IllegalArgumentException(ERROR_MSG);
        }
        try {
            hashedIdFromCertBase64 = additionalInformation.substring(idIndex + HASHED_ID_PREFIX_LEN, semiIndex);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException(ERROR_MSG, e);
        }
        return hashedIdFromCertBase64;
    }
}

