/*
 * Decompiled with CFR 0.152.
 */
package de.bdr.signme.api.v2.impl;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.google.common.base.Preconditions;
import de.bdr.signme.api.v2.ApiSession;
import de.bdr.signme.api.v2.Credentials;
import de.bdr.signme.api.v2.LtvInfoManager;
import de.bdr.signme.api.v2.SignMeApiV2Ext;
import de.bdr.signme.api.v2.StringHelper;
import de.bdr.signme.api.v2.gen.AccessTokenGrant;
import de.bdr.signme.api.v2.gen.AuthenticationQualityLevel;
import de.bdr.signme.api.v2.gen.AuthenticationTokenSelector;
import de.bdr.signme.api.v2.gen.Certificate;
import de.bdr.signme.api.v2.gen.GetIdentity;
import de.bdr.signme.api.v2.gen.GetIdentityResponse;
import de.bdr.signme.api.v2.gen.IdentitySelector;
import de.bdr.signme.api.v2.gen.IdentityVerificationProcess;
import de.bdr.signme.api.v2.gen.ItemToBeProcessed;
import de.bdr.signme.api.v2.gen.ManageIdentityChangeSet;
import de.bdr.signme.api.v2.gen.ManageTokenParameters;
import de.bdr.signme.api.v2.gen.ManageTokenResult;
import de.bdr.signme.api.v2.gen.Person;
import de.bdr.signme.api.v2.gen.RedirectURLs;
import de.bdr.signme.api.v2.gen.RegisterIdentity;
import de.bdr.signme.api.v2.gen.RegisterIdentityResponse;
import de.bdr.signme.api.v2.gen.RegistrationProcess;
import de.bdr.signme.api.v2.gen.SecurityHeader;
import de.bdr.signme.api.v2.gen.SignMeException;
import de.bdr.signme.api.v2.gen.SignatureParameters;
import de.bdr.signme.api.v2.gen.SignatureProcess;
import de.bdr.signme.api.v2.gen.SignatureTemplate;
import de.bdr.signme.api.v2.gen.SignerStatus;
import de.bdr.signme.api.v2.gen.Subscription;
import de.bdr.signme.api.v2.gen.Token;
import de.bdr.signme.api.v2.gen.TokenActivationProcess;
import de.bdr.signme.api.v2.gen.TokenCapability;
import de.bdr.signme.api.v2.gen.VersionAndDate;
import de.bdr.signme.api.v2.impl.CredentialsIdentityIdImpl;
import de.bdr.signme.api.v2.impl.CredentialsImpl;
import de.bdr.signme.api.v2.impl.CredentialsUidEmailAddrImpl;
import de.bdr.signme.api.v2.impl.CredentialsUidPwImpl;
import de.bdr.signme.api.v2.impl.LtvInfoManagerImpl;
import de.bdr.signme.api.v2.impl.SignMeApiV2ExtImpl;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Objects;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ApiSessionImpl
implements ApiSession {
    private static final Logger LOG = LoggerFactory.getLogger(ApiSessionImpl.class);
    private static final long REFRESH_AT_MILLISECONDS_BEFORE_TIMEOUT = 60000L;
    private static final long SESSION_TIMEOUT_MS = 600000L;
    private static final long MIN_TIME_BEFORE_FORCED_REFRESH_MS = 10000L;
    private static final long MIN_VALIDITY_DURATION_FOR_LOGOUT_MS = 1000L;
    private static final String DEC_UNAUTHORIZED = "E001.000.01/040001";
    private static final String DEC_INVALID_PARAM_CODE = "E001.000.04/040004";
    private static final String DEC_WRONG_AUTH_CODE = "E002.000.17/080011";
    private static final String DEC_TERMS_AND_COND_NOT_ACCEPTED = "E002.001.16/081010";
    private final SignMeApiV2ExtImpl signMeApiV2;
    private final ApiSessionImpl appProviderApiSession;
    public final Credentials credentials;
    private final String clientIpAddress;
    private AccessTokenGrant accessTokenGrant;
    private SecurityHeader securityHeader;
    private String identityIdLoggedIn;
    private SignMeException lastSignmeException;
    private final DatatypeFactory calFactory;
    private final CertificateFactory certFactory;
    private final LtvInfoManager ltvInfoManager;

    public ApiSessionImpl(SignMeApiV2Ext signMeApiV2, ApiSession appProviderApiSession, Credentials credentials, String clientIpAddress) {
        Objects.requireNonNull(signMeApiV2, "signMeApiV2 must not be null");
        Objects.requireNonNull(credentials, "credentials must not be null");
        if (!(credentials instanceof CredentialsImpl)) {
            throw new IllegalStateException("credentials must be created by factory method in " + SignMeApiV2Ext.class.getName());
        }
        Objects.requireNonNull(clientIpAddress, "clientIpAddress must not be null");
        this.signMeApiV2 = (SignMeApiV2ExtImpl)signMeApiV2;
        if (appProviderApiSession != null) {
            this.appProviderApiSession = (ApiSessionImpl)appProviderApiSession;
            if (this.appProviderApiSession.appProviderApiSession != null) {
                throw new IllegalArgumentException("appProviderApiSession does not seem to be a session logged in at least with PARTNER role");
            }
            this.ltvInfoManager = this.appProviderApiSession.getLtvInfoManager();
        } else {
            this.appProviderApiSession = null;
            this.ltvInfoManager = new LtvInfoManagerImpl(this);
        }
        this.credentials = credentials;
        this.clientIpAddress = clientIpAddress;
        try {
            this.calFactory = DatatypeFactory.newInstance();
            this.certFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException | DatatypeConfigurationException e) {
            throw new IllegalStateException("problem creating client instance", e);
        }
    }

    @Override
    public synchronized byte[] toExtern(boolean doRefreshFirst) {
        if (doRefreshFirst) {
            this.forceRefresh();
        }
        byte[] contextExternalized = new Context(this.credentials, this.clientIpAddress, this.accessTokenGrant).toExtern();
        return contextExternalized;
    }

    public static ApiSessionImpl toIntern(SignMeApiV2Ext signMeApiV2, byte[] contextExternalized) {
        Objects.requireNonNull(contextExternalized, "contextExternalized must not be null");
        Context context = Context.fromExtern(contextExternalized);
        Arrays.fill(contextExternalized, (byte)0);
        CredentialsUidPwImpl credentials = new CredentialsUidPwImpl(context.role, context.username, (String)null);
        ApiSessionImpl loginSession = new ApiSessionImpl(signMeApiV2, null, credentials, context.clientIpAddress);
        AccessTokenGrant accessTokenGrant = new AccessTokenGrant();
        accessTokenGrant.setAccessToken(context.accessToken);
        accessTokenGrant.setReachedAuthenticationQualityLevel(context.reachedAuthenticationQualityLevel);
        accessTokenGrant.setNeedsStep2(context.needsStep2);
        accessTokenGrant.setTokenGrantedAtUTCMillsec(context.tokenGrantedAtUTCMillsec);
        accessTokenGrant.setValidityDurationMillsec(context.validityDurationMillsec);
        if (context.authenticationData != null) {
            for (byte[] data : context.authenticationData) {
                accessTokenGrant.getAuthenticationData().add(data);
            }
        }
        loginSession.accessTokenGrant = accessTokenGrant;
        loginSession.securityHeader = loginSession.getSecurityHeader(accessTokenGrant, context.clientIpAddress);
        return loginSession;
    }

    @Override
    public void close() {
        this.logout();
    }

    @Override
    public synchronized long getTokenGrantedAtUTCMillsec() {
        if (this.accessTokenGrant != null) {
            return this.accessTokenGrant.getTokenGrantedAtUTCMillsec();
        }
        return 0L;
    }

    @Override
    public synchronized long getTokenValidityDurationMillsec() {
        if (this.accessTokenGrant != null) {
            return this.accessTokenGrant.getValidityDurationMillsec();
        }
        return 0L;
    }

    @Override
    public synchronized long getTokenValidUntilUTCMillsec() {
        if (this.accessTokenGrant != null) {
            return this.accessTokenGrant.getTokenGrantedAtUTCMillsec() + this.accessTokenGrant.getValidityDurationMillsec();
        }
        return 0L;
    }

    @Override
    public String getRole() {
        return this.credentials.getRole();
    }

    @Override
    public String getUsername() {
        return this.credentials.getUsername();
    }

    @Override
    public String getIdentityId() {
        if (this.credentials instanceof CredentialsIdentityIdImpl) {
            return ((CredentialsIdentityIdImpl)this.credentials).getIdentityId();
        }
        return null;
    }

    @Override
    public String getAccessTokenShort() {
        if (this.accessTokenGrant != null && this.accessTokenGrant.getAccessToken() != null) {
            return StringHelper.toShortId(this.accessTokenGrant.getAccessToken());
        }
        return null;
    }

    @Override
    public final String getIdentityIdLoggedIn() {
        return this.identityIdLoggedIn;
    }

    @Override
    public SignatureProcess createSignatureProcess(String signatureType, SignatureParameters signatureParameters, String signerUsername, String tokenId, List<ItemToBeProcessed> itemsToBeProcessed, RedirectURLs redirectURLs, Boolean suppressFinalDialog) throws SignMeException {
        try {
            return this.signMeApiV2.createSignatureProcess(this.getSecurityHeader(), signatureType, signatureParameters, signerUsername, null, tokenId, itemsToBeProcessed, redirectURLs, suppressFinalDialog);
        }
        catch (SignMeException e) {
            throw this.handleUnauthorized("createSignatureProcess", e);
        }
    }

    @Override
    public SignatureProcess createSignatureProcessWithSignerIdentityId(String signatureType, SignatureParameters signatureParameters, String signerIdentityId, String tokenId, List<ItemToBeProcessed> itemsToBeProcessed, RedirectURLs redirectURLs, Boolean suppressFinalDialog) throws SignMeException {
        try {
            return this.signMeApiV2.createSignatureProcess(this.getSecurityHeader(), signatureType, signatureParameters, null, signerIdentityId, tokenId, itemsToBeProcessed, redirectURLs, suppressFinalDialog);
        }
        catch (SignMeException e) {
            throw this.handleUnauthorized("createSignatureProcess", e);
        }
    }

    @Override
    public void updateSignatureProcess(String signatureProcessId, List<ItemToBeProcessed> itemsToBeProcessed) throws SignMeException {
        try {
            this.signMeApiV2.updateSignatureProcess(this.getSecurityHeader(), signatureProcessId, itemsToBeProcessed);
        }
        catch (SignMeException e) {
            throw this.handleUnauthorized("updateSignatureProcess", e);
        }
    }

    @Override
    public void cancelSignatureProcess(String signatureProcessId) throws SignMeException {
        try {
            this.signMeApiV2.cancelSignatureProcess(this.getSecurityHeader(), signatureProcessId);
        }
        catch (SignMeException e) {
            throw this.handleUnauthorized("cancelSignatureProcess", e);
        }
    }

    @Override
    public SignatureProcess getSignatureProcess(String signatureProcessId, boolean getContentOrSignedContent, boolean getVerificationReport, boolean getSignerIdentity) throws SignMeException {
        try {
            return this.signMeApiV2.getSignatureProcess(this.getSecurityHeader(), signatureProcessId, getContentOrSignedContent, getVerificationReport, getSignerIdentity);
        }
        catch (SignMeException e) {
            throw this.handleUnauthorized("getSignatureProcess", e);
        }
    }

    @Override
    public final LtvInfoManager getLtvInfoManager() {
        return this.ltvInfoManager;
    }

    @Override
    public SignerStatus getSignerStatus(String signatureType, String signerUsername, XMLGregorianCalendar validAtTimestamp, BigInteger minimumValidityDurationSec, BigInteger maxActiveSignatureProcesses, BigInteger maxFinalSignatureProcesses) throws SignMeException {
        try {
            return this.signMeApiV2.getSignerStatus(this.getSecurityHeader(), signatureType, signerUsername, null, validAtTimestamp, minimumValidityDurationSec, maxActiveSignatureProcesses, maxFinalSignatureProcesses);
        }
        catch (SignMeException e) {
            throw this.handleUnauthorized("getSignerStatus", e);
        }
    }

    @Override
    public SignerStatus getSignerStatus(String signatureType, String signerUsername, XMLGregorianCalendar validAtTimestamp, BigInteger minimumValidityDurationSec) throws SignMeException {
        return this.getSignerStatus(signatureType, signerUsername, validAtTimestamp, minimumValidityDurationSec, null, null);
    }

    @Override
    public SignerStatus getSignerStatusWithSignerIdentityId(String signatureType, String signerIdentityId, XMLGregorianCalendar validAtTimestamp, BigInteger minimumValidityDurationSec, BigInteger maxActiveSignatureProcesses, BigInteger maxFinalSignatureProcesses) throws SignMeException {
        try {
            return this.signMeApiV2.getSignerStatus(this.getSecurityHeader(), signatureType, null, signerIdentityId, validAtTimestamp, minimumValidityDurationSec, maxActiveSignatureProcesses, maxFinalSignatureProcesses);
        }
        catch (SignMeException e) {
            throw this.handleUnauthorized("getSignerStatusWithSignerIdentityId", e);
        }
    }

    @Override
    public SignerStatus getSignerStatusWithSignerIdentityId(String signatureType, String signerIdentityId, XMLGregorianCalendar validAtTimestamp, BigInteger minimumValidityDurationSec) throws SignMeException {
        return this.getSignerStatusWithSignerIdentityId(signatureType, signerIdentityId, validAtTimestamp, minimumValidityDurationSec, null, null);
    }

    @Override
    public SignatureTemplate getSignatureTemplate(String signatureTemplateId, Boolean includeCoins) throws SignMeException {
        try {
            return this.signMeApiV2.getSignatureTemplate(this.getSecurityHeader(), signatureTemplateId, includeCoins);
        }
        catch (SignMeException e) {
            throw this.handleUnauthorized("getSignatureTemplate", e);
        }
    }

    @Override
    public TokenActivationProcess createTokenActivationProcess(String certificateType, String purchaserEmailAddress, String requesterUsername, RedirectURLs redirectURLs) throws SignMeException {
        throw new UnsupportedOperationException("createTokenActivationProcess");
    }

    @Override
    public void cancelTokenActivationProcess(String activationProcessId) throws SignMeException {
        throw new UnsupportedOperationException("cancelTokenActivationProcess");
    }

    @Override
    public TokenActivationProcess getTokenActivationProcess(String activationProcessId) throws SignMeException {
        throw new UnsupportedOperationException("getTokenActivationProcess");
    }

    @Override
    public void reportUserConfirmationInTokenActivationProcess(String activationProcessId) throws SignMeException {
        throw new UnsupportedOperationException("reportUserConfirmationInTokenActivationProcess");
    }

    @Override
    public void revokeCertificateOfTokenActivationProcess(String activationProcessId) throws SignMeException {
        try {
            this.signMeApiV2.revokeCertificateOfTokenActivationProcess(this.getSecurityHeader(), activationProcessId);
        }
        catch (SignMeException e) {
            throw this.handleUnauthorized("revokeCertificateOfTokenActivationProcess", e);
        }
    }

    @Override
    public List<Token> getTokensForIdentity(IdentitySelector identitySelector, List<TokenCapability> havingTokenCapabilities, Boolean includeOnlyIfDefaultToken, Boolean includeOnlyIfHasValidCertificateOnly, Boolean includeSubjectCertificateIfAny, Boolean includeActivationProcessIfAny) throws SignMeException {
        try {
            return this.signMeApiV2.getTokensForIdentity(this.getSecurityHeader(), identitySelector, havingTokenCapabilities, includeOnlyIfDefaultToken, includeOnlyIfHasValidCertificateOnly, includeSubjectCertificateIfAny, includeActivationProcessIfAny);
        }
        catch (SignMeException e) {
            throw this.handleUnauthorized("getTokensForIdentity", e);
        }
    }

    @Override
    public Token getToken(String tokenId, Boolean includeSubjectCertificateIfAny, Boolean includeActivationProcessIfAny) throws SignMeException {
        try {
            return this.signMeApiV2.getToken(this.getSecurityHeader(), tokenId, includeSubjectCertificateIfAny, includeActivationProcessIfAny);
        }
        catch (SignMeException e) {
            throw this.handleUnauthorized("getToken", e);
        }
    }

    @Override
    public List<Certificate> getCertificate(String certificateId, boolean includeChain) throws SignMeException {
        try {
            return this.signMeApiV2.getCertificate(this.getSecurityHeader(), certificateId, includeChain);
        }
        catch (SignMeException e) {
            throw this.handleUnauthorized("getCertificate", e);
        }
    }

    @Override
    public RegistrationProcess createRegistrationProcess(RedirectURLs redirectURLs, Person person) throws SignMeException {
        try {
            return this.signMeApiV2.createRegistrationProcess(this.getSecurityHeader(), redirectURLs, person);
        }
        catch (SignMeException e) {
            throw this.handleUnauthorized("createRegistrationProcess", e);
        }
    }

    @Override
    public void updateRegistrationProcess(String registrationProcessId, Person person, Boolean complete, Boolean suppressConfirmationEmail) throws SignMeException {
        try {
            this.signMeApiV2.updateRegistrationProcess(this.getSecurityHeader(), registrationProcessId, person, complete, suppressConfirmationEmail);
        }
        catch (SignMeException e) {
            throw this.handleUnauthorized("updateRegistrationProcess", e);
        }
    }

    @Override
    public RegistrationProcess getRegistrationProcess(String registrationProcessId) throws SignMeException {
        try {
            return this.signMeApiV2.getRegistrationProcess(this.getSecurityHeader(), registrationProcessId);
        }
        catch (SignMeException e) {
            throw this.handleUnauthorized("getRegistrationProcess", e);
        }
    }

    @Override
    public RegisterIdentityResponse registerIdentity(RegisterIdentity parameter) throws SignMeException {
        try {
            parameter.setSecurityHeader(this.getSecurityHeader());
            return this.signMeApiV2.registerIdentity(parameter);
        }
        catch (SignMeException e) {
            throw this.handleUnauthorized("registerIdentity", e);
        }
    }

    @Override
    public GetIdentityResponse getIdentity(GetIdentity parameter) throws SignMeException {
        parameter.setSecurityHeader(this.getSecurityHeader());
        try {
            return this.signMeApiV2.getIdentity(parameter);
        }
        catch (SignMeException e) {
            throw this.handleUnauthorized("getIdentity", e);
        }
    }

    @Override
    public void confirmCommunication(String code) throws SignMeException {
        try {
            this.signMeApiV2.confirmCommunication(this.getSecurityHeader(), code);
        }
        catch (SignMeException e) {
            throw this.handleUnauthorized("confirmCommunication", e);
        }
    }

    @Override
    public IdentityVerificationProcess createIdentityVerificationProcess(String preferredIdentityVerificationType, String username, RedirectURLs redirectURLs) throws SignMeException {
        try {
            return this.signMeApiV2.createIdentityVerificationProcess(this.getSecurityHeader(), preferredIdentityVerificationType, username, null, null, null, redirectURLs);
        }
        catch (SignMeException e) {
            throw this.handleUnauthorized("createIdentityVerificationProcess", e);
        }
    }

    @Override
    public IdentityVerificationProcess createIdentityVerificationProcessWithSignerIdentityId(String preferredIdentityVerificationType, String identityId, Boolean suppressConfirmationEmail, RedirectURLs redirectURLs) throws SignMeException {
        try {
            return this.signMeApiV2.createIdentityVerificationProcess(this.getSecurityHeader(), preferredIdentityVerificationType, null, identityId, null, suppressConfirmationEmail, redirectURLs);
        }
        catch (SignMeException e) {
            throw this.handleUnauthorized("createIdentityVerificationProcessWithSignerIdentityId", e);
        }
    }

    @Override
    public IdentityVerificationProcess createIdentityVerificationProcess(String preferredIdentityVerificationType, Person person, Boolean suppressConfirmationEmail, RedirectURLs redirectURLs) throws SignMeException {
        try {
            return this.signMeApiV2.createIdentityVerificationProcess(this.getSecurityHeader(), preferredIdentityVerificationType, null, null, person, suppressConfirmationEmail, redirectURLs);
        }
        catch (SignMeException e) {
            throw this.handleUnauthorized("createIdentityVerificationProcess", e);
        }
    }

    @Override
    public IdentityVerificationProcess createIdentityVerificationProcess(String preferredIdentityVerificationType, String username, Person person, Boolean suppressConfirmationEmail, RedirectURLs redirectURLs) throws SignMeException {
        try {
            return this.signMeApiV2.createIdentityVerificationProcess(this.getSecurityHeader(), preferredIdentityVerificationType, username, null, person, suppressConfirmationEmail, redirectURLs);
        }
        catch (SignMeException e) {
            throw this.handleUnauthorized("createIdentityVerificationProcess", e);
        }
    }

    @Override
    public void cancelIdentityVerificationProcess(String identityVerificationProcessId) throws SignMeException {
        try {
            this.signMeApiV2.cancelIdentityVerificationProcess(this.getSecurityHeader(), identityVerificationProcessId);
        }
        catch (SignMeException e) {
            throw this.handleUnauthorized("cancelIdentityVerificationProcess", e);
        }
    }

    @Override
    public IdentityVerificationProcess getIdentityVerificationProcess(String identityVerificationProcessId, Boolean includeCoins) throws SignMeException {
        try {
            return this.signMeApiV2.getIdentityVerificationProcess(this.getSecurityHeader(), identityVerificationProcessId, includeCoins, null);
        }
        catch (SignMeException e) {
            throw this.handleUnauthorized("getIdentityVerificationProcess", e);
        }
    }

    @Override
    public IdentityVerificationProcess getIdentityVerificationProcess(String identityVerificationProcessId) throws SignMeException {
        try {
            return this.signMeApiV2.getIdentityVerificationProcess(this.getSecurityHeader(), identityVerificationProcessId, false, null);
        }
        catch (SignMeException e) {
            throw this.handleUnauthorized("getIdentityVerificationProcess", e);
        }
    }

    @Override
    public IdentityVerificationProcess getIdentityVerificationProcess(String identityVerificationProcessId, List<byte[]> authenticationData) throws SignMeException {
        try {
            return this.signMeApiV2.getIdentityVerificationProcess(this.getSecurityHeader(), identityVerificationProcessId, true, authenticationData);
        }
        catch (SignMeException e) {
            throw this.handleUnauthorized("getIdentityVerificationProcess", e);
        }
    }

    @Override
    public void manageIdentity(String identityId, ManageIdentityChangeSet changeSet) throws SignMeException {
        try {
            this.signMeApiV2.manageIdentity(this.getSecurityHeader(), identityId, null, changeSet);
        }
        catch (SignMeException e) {
            throw this.handleUnauthorized("manageIdentity", e);
        }
    }

    @Override
    public void manageIdentityByUsername(String username, ManageIdentityChangeSet changeSet) throws SignMeException {
        try {
            this.signMeApiV2.manageIdentity(this.getSecurityHeader(), null, username, changeSet);
        }
        catch (SignMeException e) {
            throw this.handleUnauthorized("manageIdentityByUsername", e);
        }
    }

    @Override
    public Subscription manageSubscription(String identityId, int startingOffset, int duration) throws SignMeException {
        try {
            return this.signMeApiV2.manageSubscription(this.getSecurityHeader(), identityId, null, startingOffset, duration);
        }
        catch (SignMeException e) {
            throw this.handleUnauthorized("manageSubscription", e);
        }
    }

    @Override
    public Subscription manageSubscriptionByUsername(String username, int startingOffset, int duration) throws SignMeException {
        try {
            return this.signMeApiV2.manageSubscription(this.getSecurityHeader(), null, username, startingOffset, duration);
        }
        catch (SignMeException e) {
            throw this.handleUnauthorized("manageSubscriptionByUsername", e);
        }
    }

    @Override
    public ManageTokenResult manageToken(String identityId, ManageTokenParameters manageTokenParameters) throws SignMeException {
        try {
            return this.signMeApiV2.manageToken(this.getSecurityHeader(), identityId, manageTokenParameters);
        }
        catch (SignMeException e) {
            throw this.handleUnauthorized("manageToken", e);
        }
    }

    @Override
    public List<String> getAuthenticationTokenTypesForIdentity(IdentitySelector identitySelector) throws SignMeException {
        try {
            return this.signMeApiV2.getAuthenticationTokenTypesForIdentity(this.getSecurityHeader(), identitySelector);
        }
        catch (SignMeException e) {
            throw this.handleUnauthorized("getAuthenticationTokenTypesForIdentity", e);
        }
    }

    @Override
    public synchronized AccessTokenGrant authorizeProcess(String roleName, AuthenticationTokenSelector authenticationTokenSelector, String processId) throws SignMeException, IllegalStateException {
        try {
            this.accessTokenGrant = this.signMeApiV2.authorizeProcess(this.getSecurityHeader(), roleName, authenticationTokenSelector, processId);
            this.securityHeader = this.getSecurityHeader(this.accessTokenGrant, this.clientIpAddress);
            return this.copyAccessTokenGrant(this.accessTokenGrant);
        }
        catch (SignMeException e) {
            throw this.handleUnauthorized("authorizeProcessStep1", e);
        }
    }

    private synchronized SignMeException handleUnauthorized(String methodName, SignMeException e) {
        this.lastSignmeException = e;
        if (DEC_UNAUTHORIZED.equals(e.getFaultInfo().getDetailedErrorId())) {
            this.accessTokenGrant = null;
            this.securityHeader = null;
        }
        LOG.warn("problem in " + methodName + " for: " + this.credentials + "; exception: " + e.getMessage());
        return e;
    }

    @Override
    public synchronized AccessTokenGrant authorizeProcessStep2(List<byte[]> authenticationData) throws SignMeException, IllegalStateException {
        try {
            this.accessTokenGrant = this.signMeApiV2.authorizeProcessStep2(this.getSecurityHeader(), authenticationData);
            this.securityHeader = this.getSecurityHeader(this.accessTokenGrant, this.clientIpAddress);
            return this.copyAccessTokenGrant(this.accessTokenGrant);
        }
        catch (SignMeException e) {
            throw this.handleUnauthorized("authorizeProcessStep2", e);
        }
    }

    private AccessTokenGrant copyAccessTokenGrant(AccessTokenGrant accessTokenGrant) {
        AccessTokenGrant accessTokenGrantCopy = new AccessTokenGrant();
        accessTokenGrantCopy.setAccessToken(StringHelper.toAnon(accessTokenGrant.getAccessToken(), 3, "%"));
        accessTokenGrantCopy.setNeedsStep2(accessTokenGrant.isNeedsStep2());
        accessTokenGrantCopy.setReachedAuthenticationQualityLevel(accessTokenGrant.getReachedAuthenticationQualityLevel());
        accessTokenGrantCopy.setTokenGrantedAtUTCMillsec(accessTokenGrant.getTokenGrantedAtUTCMillsec());
        accessTokenGrantCopy.setValidityDurationMillsec(accessTokenGrant.getValidityDurationMillsec());
        if (accessTokenGrant.getAuthenticationData() != null) {
            for (byte[] authData : accessTokenGrant.getAuthenticationData()) {
                if (authData == null) continue;
                accessTokenGrantCopy.getAuthenticationData().add(Arrays.copyOf(authData, authData.length));
            }
        }
        return accessTokenGrantCopy;
    }

    @Override
    public synchronized VersionAndDate getVersion() throws SignMeException {
        try {
            return this.signMeApiV2.getVersion(this.getSecurityHeader());
        }
        catch (SignMeException e) {
            throw this.handleUnauthorized("getVersion", e);
        }
    }

    @Override
    public byte[] getHashedSecretSha512(String secret, byte[] optSalt) {
        Objects.requireNonNull(secret, "secret must not be null");
        return this.getHashedSecret("SHA-512", secret, optSalt);
    }

    @Override
    public byte[] getHashedSecretSha512(byte[] secretBytes, byte[] optSalt) {
        Objects.requireNonNull(secretBytes, "secret must not be null");
        return this.getHashedSecret("SHA-512", secretBytes, optSalt);
    }

    @Override
    public byte[] getHashedSecretSha1(String secret, byte[] optSalt) {
        Objects.requireNonNull(secret, "secret must not be null");
        return this.getHashedSecret("SHA-1", secret, optSalt);
    }

    @Override
    public byte[] getHashedSecret(String algo, String secret, byte[] optSalt) {
        Objects.requireNonNull(algo, "algo must not be null");
        Objects.requireNonNull(secret, "secret must not be null");
        byte[] secretBytes = secret.getBytes(StandardCharsets.UTF_8);
        return this.getHashedSecret(algo, secretBytes, optSalt);
    }

    private byte[] getHashedSecret(String algo, byte[] secretBytes, byte[] optSalt) {
        Objects.requireNonNull(algo, "algo must not be null");
        Objects.requireNonNull(secretBytes, "secretBytes must not be null");
        try {
            MessageDigest shaMd = MessageDigest.getInstance(algo);
            if (optSalt != null) {
                shaMd.update(optSalt);
            }
            shaMd.update(secretBytes);
            return shaMd.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("wrong algo or charset used", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XMLGregorianCalendar getXMLGregorianCalendarFromDate(Date date) {
        Objects.requireNonNull(date, "date must not be null");
        GregorianCalendar calendar = (GregorianCalendar)Calendar.getInstance();
        calendar.setTime(date);
        DatatypeFactory datatypeFactory = this.calFactory;
        synchronized (datatypeFactory) {
            return this.calFactory.newXMLGregorianCalendar(calendar);
        }
    }

    @Override
    public Date getDateFromXMLGregorianCalendar(XMLGregorianCalendar xmlGregorianCalendar) {
        Objects.requireNonNull(xmlGregorianCalendar, "xmlGregorianCalendar must not be null");
        return xmlGregorianCalendar.toGregorianCalendar().getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public X509Certificate getX509CertificateFromBinaryForm(byte[] certificateBin) {
        Objects.requireNonNull(certificateBin, "certificateBin must not be null");
        try {
            ByteArrayInputStream inStream = new ByteArrayInputStream(certificateBin);
            CertificateFactory certificateFactory = this.certFactory;
            synchronized (certificateFactory) {
                return (X509Certificate)this.certFactory.generateCertificate(inStream);
            }
        }
        catch (Exception e) {
            String message = "certificates delivered from CA cannot be decoded";
            throw new IllegalStateException("certificates delivered from CA cannot be decoded", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SecurityHeader getSecurityHeader() throws IllegalStateException {
        this.ensureAccessTokenIsValid();
        SecurityHeader securityHeaderCopy = new SecurityHeader();
        ApiSessionImpl apiSessionImpl = this;
        synchronized (apiSessionImpl) {
            securityHeaderCopy.setAccessToken(this.securityHeader.getAccessToken());
            securityHeaderCopy.setClientIpAddress(this.securityHeader.getClientIpAddress());
        }
        return securityHeaderCopy;
    }

    @Override
    public void forceRefresh() throws IllegalStateException {
        this.refreshAccessToken(590000L);
        this.ensureAccessTokenIsValid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ensureAccessTokenIsValid() throws IllegalStateException {
        boolean accessTokenValid;
        long tokenValidUntilUTCMillsec;
        this.lastSignmeException = null;
        ApiSessionImpl apiSessionImpl = this;
        synchronized (apiSessionImpl) {
            if (this.accessTokenGrant != null) {
                boolean accessTokenValidQuickCheck;
                tokenValidUntilUTCMillsec = this.accessTokenGrant.getTokenGrantedAtUTCMillsec() + this.accessTokenGrant.getValidityDurationMillsec();
                boolean bl = accessTokenValidQuickCheck = System.currentTimeMillis() <= tokenValidUntilUTCMillsec - 60000L;
                if (accessTokenValidQuickCheck) {
                    return;
                }
            }
        }
        apiSessionImpl = this;
        synchronized (apiSessionImpl) {
            if (this.accessTokenGrant != null) {
                tokenValidUntilUTCMillsec = this.accessTokenGrant.getTokenGrantedAtUTCMillsec() + this.accessTokenGrant.getValidityDurationMillsec();
                if (System.currentTimeMillis() > tokenValidUntilUTCMillsec) {
                    LOG.info("access token too old -> we do login first: " + this.credentials);
                    accessTokenValid = this.login();
                } else {
                    boolean refreshSuccess = this.refreshAccessToken(60000L);
                    if (!refreshSuccess) {
                        LOG.info("refresh failed -> we do login: " + this.credentials);
                        accessTokenValid = this.login();
                    } else {
                        LOG.info("refresh ok: " + this.credentials);
                        accessTokenValid = refreshSuccess;
                    }
                }
            } else {
                LOG.info("no access token available -> we do login first: " + this.credentials);
                accessTokenValid = this.login();
            }
        }
        if (!accessTokenValid) {
            String message = "could not ensure validity of access token; check configuration of credentials and state of the account (locked or insufficient rights/role?)";
            throw new IllegalStateException("could not ensure validity of access token; check configuration of credentials and state of the account (locked or insufficient rights/role?)" + (String)(this.lastSignmeException != null ? "; cause: " + this.lastSignmeException.getMessage() : ""), this.lastSignmeException);
        }
    }

    protected synchronized boolean login() {
        boolean success = false;
        try {
            this.accessTokenGrant = this.login(this.credentials);
            this.securityHeader = this.getSecurityHeader(this.accessTokenGrant, this.clientIpAddress);
            this.identityIdLoggedIn = this.accessTokenGrant.getAuthenticationData().size() > 0 ? new String(this.accessTokenGrant.getAuthenticationData().get(0)) : null;
            success = true;
            LOG.info("logged in into sign-me: " + this.credentials);
        }
        catch (SignMeException e) {
            this.lastSignmeException = e;
            this.accessTokenGrant = null;
            this.securityHeader = null;
            this.identityIdLoggedIn = null;
            LOG.warn("problem logging in into sign-me: " + this.credentials + "; exception: " + e.getMessage());
        }
        return success;
    }

    private AccessTokenGrant login(Credentials credentials) throws SignMeException {
        String authenticationTokenType;
        String pw;
        Objects.requireNonNull(credentials, "credentials must not be null");
        AuthenticationTokenSelector authenticationTokenSelector = new AuthenticationTokenSelector();
        if (credentials instanceof CredentialsUidPwImpl) {
            authenticationTokenSelector.setAuthenticationTokenType("UIDPW");
            authenticationTokenSelector.setUsername(credentials.getUsername());
            pw = ((CredentialsUidPwImpl)credentials).getPw();
        } else if (credentials instanceof CredentialsUidEmailAddrImpl) {
            authenticationTokenSelector.setAuthenticationTokenType("UIDEMAIL");
            authenticationTokenSelector.setUsername(credentials.getUsername());
            pw = null;
        } else if (credentials instanceof CredentialsIdentityIdImpl) {
            authenticationTokenSelector.setAuthenticationTokenType("IID");
            authenticationTokenSelector.setIdentityId(((CredentialsIdentityIdImpl)credentials).getIdentityId());
            pw = null;
        } else {
            throw new IllegalArgumentException("credentials must be created by factory method in " + SignMeApiV2Ext.class.getName());
        }
        SecurityHeader optAppProviderSecurityHeader = this.appProviderApiSession != null ? this.appProviderApiSession.getSecurityHeader() : null;
        AccessTokenGrant accessTokenGrant = this.signMeApiV2.login(optAppProviderSecurityHeader, this.clientIpAddress, credentials.getRole(), authenticationTokenSelector, this.signMeApiV2.getClientInterfaceRevision());
        switch (authenticationTokenType = authenticationTokenSelector.getAuthenticationTokenType()) {
            case "UIDPW": {
                byte[] salt = accessTokenGrant.getAuthenticationData().get(0);
                byte[] pwHash = this.getHashedSecretSha512(pw, salt);
                ArrayList<byte[]> authenticationData = new ArrayList<byte[]>();
                authenticationData.add(0, pwHash);
                SecurityHeader securityHeader = this.getSecurityHeader(accessTokenGrant, this.clientIpAddress);
                AccessTokenGrant accessTokenGrant2 = this.signMeApiV2.loginStep2(securityHeader, authenticationData);
                return accessTokenGrant2;
            }
            case "UIDEMAIL": 
            case "IID": {
                return accessTokenGrant;
            }
        }
        throw new IllegalStateException("illegal AuthenticationTokenType " + authenticationTokenType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized boolean logout() {
        boolean success = false;
        try {
            if (this.accessTokenGrant != null) {
                long tokenValidUntilUTCMillsec = this.accessTokenGrant.getTokenGrantedAtUTCMillsec() + this.accessTokenGrant.getValidityDurationMillsec();
                if (System.currentTimeMillis() < tokenValidUntilUTCMillsec - 1000L) {
                    LOG.debug("logout: " + this.credentials);
                    this.logoutExt(this.accessTokenGrant, this.clientIpAddress);
                } else {
                    LOG.debug("logout not needed, because invalid (or nearly invalid) access token: " + this.credentials);
                }
            } else {
                LOG.debug("logout not needed, because no access token: " + this.credentials);
            }
            success = true;
            LOG.info("logged out from sign-me: " + this.credentials);
        }
        catch (SignMeException e) {
            this.lastSignmeException = e;
            LOG.warn("problem logging out from sign-me: " + this.credentials + "; exception: " + e.getMessage() + " (ignored)");
        }
        finally {
            this.accessTokenGrant = null;
            this.securityHeader = null;
        }
        return success;
    }

    private void logoutExt(AccessTokenGrant accessTokenGrant, String clientIpAddress) throws SignMeException {
        Objects.requireNonNull(accessTokenGrant, "accessTokenGrant must not be null");
        Objects.requireNonNull(clientIpAddress, "clientIpAddress must not be null");
        String accessToken = accessTokenGrant.getAccessToken();
        SecurityHeader securityHeader = new SecurityHeader();
        securityHeader.setAccessToken(accessToken);
        securityHeader.setClientIpAddress(clientIpAddress);
        this.signMeApiV2.logout(securityHeader);
    }

    protected synchronized boolean refreshAccessToken(long refreshAtMillisecondsBeforeTimeout) {
        boolean success = false;
        try {
            this.accessTokenGrant = this.refreshLoginExt(this.accessTokenGrant, this.clientIpAddress, refreshAtMillisecondsBeforeTimeout);
            this.securityHeader = this.getSecurityHeader(this.accessTokenGrant, this.clientIpAddress);
            success = true;
            LOG.debug("refreshed access token at sign-me: " + this.credentials);
        }
        catch (SignMeException e) {
            this.lastSignmeException = e;
            this.accessTokenGrant = null;
            this.securityHeader = null;
            LOG.warn("problem refreshing access token in sign-me: " + this.credentials + "; exception: " + e.getMessage());
        }
        return success;
    }

    private AccessTokenGrant refreshLoginExt(AccessTokenGrant accessTokenGrant, String clientIpAddress, long doAtMillisecondsBeforeTimeout) throws SignMeException {
        Objects.requireNonNull(accessTokenGrant, "accessTokenGrant must not be null");
        Objects.requireNonNull(clientIpAddress, "clientIpAddress must not be null");
        Preconditions.checkArgument((doAtMillisecondsBeforeTimeout == -1L || doAtMillisecondsBeforeTimeout >= 0L ? 1 : 0) != 0, (Object)"doAtMillisecondsBeforeTimeout must be -1 for 'refresh always' or > 0");
        long accessTokenTimeout = accessTokenGrant.getTokenGrantedAtUTCMillsec() + accessTokenGrant.getValidityDurationMillsec();
        if (doAtMillisecondsBeforeTimeout == -1L || System.currentTimeMillis() > accessTokenTimeout - doAtMillisecondsBeforeTimeout) {
            AccessTokenGrant newAccessTokenGrant = this.signMeApiV2.refreshLogin(this.getSecurityHeader(accessTokenGrant, clientIpAddress));
            return newAccessTokenGrant;
        }
        return accessTokenGrant;
    }

    private SecurityHeader getSecurityHeader(AccessTokenGrant accessTokenGrant, String clientIpAddress) {
        Objects.requireNonNull(accessTokenGrant, "accessTokenGrant must not be null");
        Objects.requireNonNull(clientIpAddress, "clientIpAddress must not be null");
        SecurityHeader securityHeader = new SecurityHeader();
        securityHeader.setAccessToken(accessTokenGrant.getAccessToken());
        securityHeader.setClientIpAddress(clientIpAddress);
        return securityHeader;
    }

    @JsonNaming(value=PropertyNamingStrategy.LowerCaseWithUnderscoresStrategy.class)
    @JsonInclude
    private static class Context {
        private static final ObjectMapper JSON_OM = new ObjectMapper();
        public String username;
        public String role;
        public String clientIpAddress;
        public String accessToken;
        public AuthenticationQualityLevel reachedAuthenticationQualityLevel;
        public boolean needsStep2;
        public long tokenGrantedAtUTCMillsec;
        public long validityDurationMillsec;
        public List<byte[]> authenticationData;

        public final byte[] toExtern() {
            try {
                return JSON_OM.writeValueAsBytes((Object)this);
            }
            catch (JsonProcessingException e) {
                throw new IllegalStateException("cannot serialize context to JSON representation", e);
            }
        }

        public static final Context fromExtern(byte[] contextAsJsonString) {
            try {
                return (Context)JSON_OM.readValue(contextAsJsonString, Context.class);
            }
            catch (IOException e) {
                throw new IllegalStateException("cannot deserialize context from JSON representation", e);
            }
        }

        public Context() {
        }

        public Context(Credentials credentials, String clientIpAddress, AccessTokenGrant accessTokenGrant) {
            this.username = credentials.getUsername();
            this.role = credentials.getRole();
            this.clientIpAddress = clientIpAddress;
            if (accessTokenGrant != null) {
                this.accessToken = accessTokenGrant.getAccessToken();
                this.reachedAuthenticationQualityLevel = accessTokenGrant.getReachedAuthenticationQualityLevel();
                this.needsStep2 = accessTokenGrant.isNeedsStep2();
                this.tokenGrantedAtUTCMillsec = accessTokenGrant.getTokenGrantedAtUTCMillsec();
                this.validityDurationMillsec = accessTokenGrant.getValidityDurationMillsec();
                this.authenticationData = accessTokenGrant.getAuthenticationData();
            }
        }

        static {
            JSON_OM.enable(SerializationFeature.INDENT_OUTPUT);
            JSON_OM.enable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        }
    }
}

