/*
 * Decompiled with CFR 0.152.
 */
package de.bdr.signme.api.v2.impl;

import de.bdr.signme.api.v2.gen.Certificate;
import de.bdr.signme.api.v2.impl.CertificateRank;
import de.bdr.signme.api.v2.impl.CertificateRole;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CertificateUsage {
    private static final Logger LOG = LoggerFactory.getLogger(CertificateUsage.class);
    private final Certificate certificate;
    private final List<CertificateRole> roles;
    private final CertificateRank rank;
    private final boolean mustHaveOcspResp;
    private final boolean mustHaveCRL;
    private final boolean revocationInfoComplete;

    CertificateUsage(Certificate certificate, CertificateRole role, CertificateRank level, boolean mustHaveOcspResp, boolean mustHaveCRL) {
        this.certificate = Objects.requireNonNull(certificate);
        this.roles = new ArrayList<CertificateRole>();
        this.rank = Objects.requireNonNull(level);
        this.addUsage(Objects.requireNonNull(role), level);
        this.mustHaveOcspResp = mustHaveOcspResp;
        this.mustHaveCRL = mustHaveCRL;
        this.revocationInfoComplete = !(mustHaveOcspResp && certificate.getOcspResponse() == null || mustHaveCRL && certificate.getX509CRL() == null);
    }

    void addUsage(CertificateRole role, CertificateRank level) {
        if (Objects.requireNonNull(level) != this.rank) {
            throw new IllegalArgumentException("cannot change level " + this.rank + " to " + level + " for certifcate " + this.certificate.getSubjectDN());
        }
        this.roles.add(Objects.requireNonNull(role));
    }

    public final Certificate getCertificate() {
        return this.certificate;
    }

    public final CertificateRank getRank() {
        return this.rank;
    }

    public final List<CertificateRole> getRoles() {
        return Collections.unmodifiableList(this.roles);
    }

    public final String getRoleRankString() {
        String roleRankString = this.roles.stream().map(r -> r.name().toLowerCase()).collect(Collectors.joining("+"));
        return roleRankString + "-" + this.rank.name().toLowerCase();
    }

    public boolean mustHaveOcspResp() {
        return this.mustHaveOcspResp;
    }

    public boolean mustHaveCRL() {
        return this.mustHaveCRL;
    }

    public final boolean isRevocationInfoComplete() {
        return this.revocationInfoComplete;
    }

    public void storeCertPlusCrlOcsp(File storagePath) throws IOException {
        Objects.requireNonNull(storagePath);
        String certFilenameBase = this.getRoleRankString() + "-" + this.certificate.getSubjectDN();
        CertificateUsage.store(this.certificate.getCertificate(), new File(storagePath, certFilenameBase + ".crt"));
        if (this.mustHaveOcspResp) {
            if (this.certificate.getOcspResponse() != null) {
                CertificateUsage.store(this.certificate.getOcspResponse(), new File(storagePath, certFilenameBase + ".ocsp"));
            } else {
                LOG.warn("no OCSP response for subject cert: " + certFilenameBase);
            }
        }
        if (this.mustHaveCRL) {
            if (this.certificate.getX509CRL() != null) {
                CertificateUsage.store(this.certificate.getX509CRL(), new File(storagePath, certFilenameBase + ".crl"));
            } else {
                LOG.warn("no CRL for issuer/root cert:" + certFilenameBase);
            }
        }
    }

    private static void store(byte[] content, File file) throws IOException {
        File dir = file.getParentFile();
        if (dir != null) {
            dir.mkdirs();
        }
        Files.write(file.toPath(), content, new OpenOption[0]);
    }
}

