/*
 * Decompiled with CFR 0.152.
 */
package de.bdr.signme.api.v2.impl;

import de.bdr.signme.api.v2.CertificateUsages;
import de.bdr.signme.api.v2.gen.Certificate;
import de.bdr.signme.api.v2.gen.SignMeException;
import de.bdr.signme.api.v2.impl.CertificateRank;
import de.bdr.signme.api.v2.impl.CertificateRole;
import de.bdr.signme.api.v2.impl.CertificateUsage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CertificateUsagesImpl
implements CertificateUsages {
    private static final Logger LOG = LoggerFactory.getLogger(CertificateUsagesImpl.class);
    private final HashMap<String, CertificateUsage> certificateUses;
    private final Function<Certificate, List<Certificate>> chainSupplier;
    private boolean subjectCertsComplete = true;
    private boolean issuerChainCertsComplete = true;
    private boolean revocationInfoComplete = true;

    public static Builder newBuilder(Function<Certificate, List<Certificate>> chainSupplier) {
        return new Builder(chainSupplier);
    }

    private CertificateUsagesImpl(Function<Certificate, List<Certificate>> chainSupplier) {
        this.chainSupplier = Objects.requireNonNull(chainSupplier);
        this.certificateUses = new HashMap();
    }

    private void addSubjectAndChainUsage(Certificate certificate, CertificateRole role, boolean mustHaveOcspResp) throws SignMeException {
        Optional<CertificateUsage> newSubjectCertUsage = this.addUsage(certificate, role, CertificateRank.SUBJECT, mustHaveOcspResp, false);
        if (newSubjectCertUsage.isPresent()) {
            boolean bl = this.revocationInfoComplete = this.revocationInfoComplete && newSubjectCertUsage.get().isRevocationInfoComplete();
            if (certificate.getIssuerCertificateId() != null) {
                List<Certificate> issuerCertificates = this.chainSupplier.apply(certificate);
                int level = 1;
                int maxLevel = issuerCertificates.size();
                for (Certificate issuerCertificate : issuerCertificates) {
                    CertificateRank certificateRank;
                    Optional<CertificateUsage> newIssuerCertUsage = this.addUsage(issuerCertificate, role, certificateRank = level < maxLevel ? CertificateRank.ISSUER : CertificateRank.ROOT, false, true);
                    if (newIssuerCertUsage.isPresent()) {
                        this.revocationInfoComplete = this.revocationInfoComplete && newIssuerCertUsage.get().isRevocationInfoComplete();
                    } else {
                        this.issuerChainCertsComplete = false;
                        this.revocationInfoComplete = false;
                    }
                    ++level;
                }
            } else {
                LOG.info("no issuer for " + certificate.getSubjectDN() + " in " + role);
            }
        } else {
            this.subjectCertsComplete = false;
        }
    }

    private Optional<CertificateUsage> addUsage(Certificate certificate, CertificateRole role, CertificateRank level, boolean isSubject, boolean mustHaveCRL) {
        Objects.requireNonNull(role);
        if (certificate != null) {
            String certificateId = certificate.getCertificateId();
            CertificateUsage certificateUseExisting = this.certificateUses.get(certificateId);
            if (certificateUseExisting != null) {
                certificateUseExisting.addUsage(role, level);
                return Optional.of(certificateUseExisting);
            }
            CertificateUsage certificateUsage = new CertificateUsage(certificate, role, level, isSubject, mustHaveCRL);
            this.certificateUses.put(certificateId, certificateUsage);
            return Optional.of(certificateUsage);
        }
        LOG.info("no " + role + " certificate available!");
        return Optional.empty();
    }

    @Override
    public final boolean isLtvInfoComplete() {
        return this.subjectCertsComplete && this.issuerChainCertsComplete && this.revocationInfoComplete;
    }

    @Override
    public final boolean isSubjectCertsComplete() {
        return this.subjectCertsComplete;
    }

    @Override
    public final boolean isIssuerChainCertsComplete() {
        return this.issuerChainCertsComplete;
    }

    @Override
    public final boolean isRevocationInfoComplete() {
        return this.revocationInfoComplete;
    }

    @Override
    public CertificateUsages.LtvInfo toLtvInfo() {
        ArrayList<byte[]> x509Certificates = new ArrayList<byte[]>();
        ArrayList<byte[]> ocspResponses = new ArrayList<byte[]>();
        ArrayList<byte[]> crls = new ArrayList<byte[]>();
        for (CertificateUsage certificateUse : this.certificateUses.values()) {
            Certificate certificate = certificateUse.getCertificate();
            if (certificate.getCertificate() != null) {
                x509Certificates.add((byte[])certificate.getCertificate().clone());
            }
            if (certificateUse.mustHaveOcspResp() && certificate.getOcspResponse() != null) {
                ocspResponses.add((byte[])certificate.getOcspResponse().clone());
            }
            if (!certificateUse.mustHaveCRL() || certificate.getX509CRL() == null) continue;
            crls.add((byte[])certificate.getX509CRL().clone());
        }
        return new LtvInfoImpl(x509Certificates, ocspResponses, crls);
    }

    @Override
    public CertificateUsages.LtvInfoBase64 toLtvInfoBase64() {
        ArrayList<String> x509Certificates = new ArrayList<String>();
        ArrayList<String> ocspResponses = new ArrayList<String>();
        ArrayList<String> crls = new ArrayList<String>();
        Base64.Encoder encoder = Base64.getEncoder();
        for (CertificateUsage certificateUse : this.certificateUses.values()) {
            Certificate certificate = certificateUse.getCertificate();
            if (certificate.getCertificate() != null) {
                x509Certificates.add(encoder.encodeToString(certificate.getCertificate()));
            }
            if (certificateUse.mustHaveOcspResp() && certificate.getOcspResponse() != null) {
                ocspResponses.add(encoder.encodeToString(certificate.getOcspResponse()));
            }
            if (!certificateUse.mustHaveCRL() || certificate.getX509CRL() == null) continue;
            crls.add(encoder.encodeToString(certificate.getX509CRL()));
        }
        return new LtvInfoBase64Impl(x509Certificates, ocspResponses, crls);
    }

    @Override
    public void storeLtvInfoToFiles(File storagePath) throws IOException {
        Objects.requireNonNull(storagePath);
        for (CertificateUsage certificateUse : this.certificateUses.values()) {
            certificateUse.storeCertPlusCrlOcsp(storagePath);
        }
    }

    public static final class Builder {
        private boolean built = false;
        private final CertificateUsagesImpl certificateUsages;

        private Builder(Function<Certificate, List<Certificate>> chainSupplier) {
            this.certificateUsages = new CertificateUsagesImpl(chainSupplier);
        }

        public Builder addSubjectUsage(Certificate certificate, CertificateRole role, boolean mustHaveOcspResp) throws SignMeException {
            if (certificate != null) {
                Objects.requireNonNull(role);
                if (this.built) {
                    throw new IllegalStateException("CertificateUsages already built -create a new builder for creating a new one.");
                }
                this.certificateUsages.addSubjectAndChainUsage(certificate, role, mustHaveOcspResp);
            } else {
                LOG.info(role + " certificate not available");
            }
            return this;
        }

        public CertificateUsages build() {
            this.built = true;
            return this.certificateUsages;
        }
    }

    public static class LtvInfoImpl
    implements CertificateUsages.LtvInfo {
        private final List<byte[]> x509Certificates;
        private final List<byte[]> ocspResponses;
        private final List<byte[]> crls;

        private LtvInfoImpl(List<byte[]> x509Certificates, List<byte[]> ocspResponses, List<byte[]> crls) {
            this.x509Certificates = Collections.unmodifiableList(Objects.requireNonNull(x509Certificates));
            this.ocspResponses = Collections.unmodifiableList(Objects.requireNonNull(ocspResponses));
            this.crls = Collections.unmodifiableList(Objects.requireNonNull(crls));
        }

        @Override
        public final List<byte[]> getX509Certificates() {
            return this.x509Certificates;
        }

        @Override
        public final List<byte[]> getOcspResponses() {
            return this.ocspResponses;
        }

        @Override
        public final List<byte[]> getCrls() {
            return this.crls;
        }
    }

    public static class LtvInfoBase64Impl
    implements CertificateUsages.LtvInfoBase64 {
        private final List<String> x509Certificates;
        private final List<String> ocspResponses;
        private final List<String> crls;

        private LtvInfoBase64Impl(List<String> x509Certificates, List<String> ocspResponses, List<String> crls) {
            this.x509Certificates = Collections.unmodifiableList(Objects.requireNonNull(x509Certificates));
            this.ocspResponses = Collections.unmodifiableList(Objects.requireNonNull(ocspResponses));
            this.crls = Collections.unmodifiableList(Objects.requireNonNull(crls));
        }

        @Override
        public final List<String> getX509Certificates() {
            return this.x509Certificates;
        }

        @Override
        public final List<String> getOcspResponses() {
            return this.ocspResponses;
        }

        @Override
        public final List<String> getCrls() {
            return this.crls;
        }
    }
}

