/*
 * Decompiled with CFR 0.152.
 */
package de.bdr.signme.api.v2.impl;

import de.bdr.signme.api.v2.StringHelper;
import de.bdr.signme.api.v2.impl.CredentialsImpl;
import java.util.Objects;
import java.util.regex.Pattern;

final class CredentialsIdentityIdImpl
extends CredentialsImpl {
    private static final Pattern IID_PATTERN = Pattern.compile("[A-Fa-f0-9]{64}");
    private final String identityId;
    private String identityIdAnonymized;

    public CredentialsIdentityIdImpl(String role, String identityId) {
        super(role);
        Objects.requireNonNull(identityId, "identityId must not be null");
        this.checkIIDPreconditions(identityId);
        this.identityId = identityId;
    }

    private void checkIIDPreconditions(String identityId) {
        if (!IID_PATTERN.matcher(identityId).matches()) {
            throw new IllegalArgumentException("identityId is not valid: " + identityId);
        }
    }

    public final String getIdentityId() {
        return this.identityId;
    }

    @Override
    public String getUsernameAnonymized() {
        if (this.identityIdAnonymized == null) {
            this.identityIdAnonymized = StringHelper.toShortId(this.getIdentityId());
        }
        return this.identityIdAnonymized;
    }
}

