/*
 * Decompiled with CFR 0.152.
 */
package de.bdr.signme.api.v2.impl;

import de.bdr.signme.api.v2.Credentials;
import de.bdr.signme.api.v2.StringHelper;
import java.util.Objects;

abstract class CredentialsImpl
implements Credentials {
    private final String role;
    private String usernameAnonymized;

    public CredentialsImpl(String role) {
        Objects.requireNonNull(role, "role must not be null");
        this.role = role;
    }

    @Override
    public final String getRole() {
        return this.role;
    }

    @Override
    public String getUsernameAnonymized() {
        if (this.usernameAnonymized == null) {
            this.usernameAnonymized = StringHelper.toAnonData(this.getUsername());
        }
        return this.usernameAnonymized;
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{ ");
        if (this.role != null) {
            builder.append("\"role\" : \"");
            builder.append(this.role);
            builder.append("\"");
        }
        if (this.getUsernameAnonymized() != null) {
            builder.append(", \"username\" : \"");
            builder.append(this.getUsernameAnonymized());
            builder.append("\"");
        }
        builder.append(" }");
        return builder.toString();
    }
}

