/*
 * Decompiled with CFR 0.152.
 */
package de.bdr.signme.api.v2.impl;

import de.bdr.signme.api.v2.impl.CredentialsImpl;
import java.util.Objects;
import java.util.regex.Pattern;

final class CredentialsUidEmailAddrImpl
extends CredentialsImpl {
    private static final Pattern MINIMUM_EMAIL_PATTERN = Pattern.compile("[a-zA-z\\.0-9\\-\\+_]+@[^@.]{1,}\\.[^@]{2,}");
    private final String usernameAsEmailAddress;

    public CredentialsUidEmailAddrImpl(String role, String usernameAsEmailAddress) {
        super(role);
        Objects.requireNonNull(usernameAsEmailAddress, "usernameAsEmailAddress must not be null");
        this.checkMinimumEmailPreconditions(usernameAsEmailAddress);
        this.usernameAsEmailAddress = usernameAsEmailAddress;
    }

    private void checkMinimumEmailPreconditions(String usernameAsEmailAddress) {
        if (!MINIMUM_EMAIL_PATTERN.matcher(usernameAsEmailAddress).matches()) {
            throw new IllegalArgumentException("usernameAsEmailAddress does not seem to be an email-address: " + usernameAsEmailAddress);
        }
    }

    @Override
    public final String getUsername() {
        return this.usernameAsEmailAddress;
    }
}

