/*
 * Decompiled with CFR 0.152.
 */
package de.bdr.signme.api.v2.impl;

import de.bdr.signme.api.v2.ApiSession;
import de.bdr.signme.api.v2.CertificateUsages;
import de.bdr.signme.api.v2.LtvInfoManager;
import de.bdr.signme.api.v2.gen.Certificate;
import de.bdr.signme.api.v2.gen.SignMeException;
import de.bdr.signme.api.v2.gen.SignatureProcess;
import de.bdr.signme.api.v2.impl.CertificateRole;
import de.bdr.signme.api.v2.impl.CertificateUsagesImpl;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LtvInfoManagerImpl
implements LtvInfoManager {
    private static final Logger LOG = LoggerFactory.getLogger(LtvInfoManagerImpl.class);
    private final Function<Certificate, List<Certificate>> chainSupplier;
    private final HashMap<String, CachedChainEntry> cachedIssuerChains = new HashMap();

    public LtvInfoManagerImpl(ApiSession partnerSession) {
        Objects.requireNonNull(partnerSession);
        this.chainSupplier = certificate -> this.getCachedIssuerChain(partnerSession, (Certificate)certificate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Certificate> getCachedIssuerChain(ApiSession partnerSession, Certificate certificate) {
        List<Certificate> issuerChain;
        block13: {
            Objects.requireNonNull(partnerSession);
            Objects.requireNonNull(certificate);
            issuerChain = null;
            try {
                String issuerCertificateId = certificate.getIssuerCertificateId();
                HashMap<String, CachedChainEntry> hashMap = this.cachedIssuerChains;
                synchronized (hashMap) {
                    CachedChainEntry cachedChainEntry = this.cachedIssuerChains.get(issuerCertificateId);
                    if (cachedChainEntry != null) {
                        if (Instant.now().isBefore(cachedChainEntry.expiresAtTimestamp)) {
                            issuerChain = cachedChainEntry.chain;
                        } else {
                            this.cachedIssuerChains.remove(issuerCertificateId);
                        }
                    }
                }
                if (issuerChain != null) break block13;
                issuerChain = partnerSession.getCertificate(issuerCertificateId, true);
                boolean sizeSufficient = issuerChain != null && issuerChain.size() >= 2;
                boolean crlPresent = issuerChain.stream().allMatch(c -> c.getX509CRL() != null);
                if (sizeSufficient && crlPresent) {
                    HashMap<String, CachedChainEntry> hashMap2 = this.cachedIssuerChains;
                    synchronized (hashMap2) {
                        this.cachedIssuerChains.put(issuerCertificateId, new CachedChainEntry(issuerChain));
                        break block13;
                    }
                }
                LOG.info("issuer chain will not be cached because sizeSufficient=" + sizeSufficient + " crlPresent=" + crlPresent);
            }
            catch (SignMeException e) {
                LOG.warn("problem accessing certificate chain supplier", (Throwable)e);
            }
        }
        if (issuerChain != null) {
            return issuerChain;
        }
        return Collections.emptyList();
    }

    @Override
    public CertificateUsages getCertificateUsagesFor(SignatureProcess signatureProcess) throws SignMeException {
        CertificateUsagesImpl.Builder builder = CertificateUsagesImpl.newBuilder(this.chainSupplier);
        builder.addSubjectUsage(signatureProcess.getCertificateV2(), CertificateRole.SIGNATURE, true);
        builder.addSubjectUsage(signatureProcess.getOcspCertificate(), CertificateRole.OCSP, false);
        builder.addSubjectUsage(signatureProcess.getTimestampCertificate(), CertificateRole.SIGNATURE_TIMESTAMP, false);
        CertificateUsages certificateUsages = builder.build();
        return certificateUsages;
    }

    private static class CachedChainEntry {
        private static final int ISSUER_CHAIN_CACHE_LIFETIME_SEC = 3600;
        private final Instant expiresAtTimestamp = Instant.now().plusSeconds(3600L);
        private final List<Certificate> chain;

        private CachedChainEntry(List<Certificate> chain) {
            this.chain = Objects.requireNonNull(chain);
            if (chain.size() < 2) {
                throw new IllegalArgumentException("chain length not sufficient (min=2): " + chain.size());
            }
        }
    }
}

