/*
 * Decompiled with CFR 0.152.
 */
package de.bdr.signme.api.v2.impl;

import de.bdr.signme.api.v2.ApiSession;
import de.bdr.signme.api.v2.Credentials;
import de.bdr.signme.api.v2.SignMeApiV2Ext;
import de.bdr.signme.api.v2.gen.Specinfo;
import de.bdr.signme.api.v2.impl.ApiSessionImpl;
import de.bdr.signme.api.v2.impl.CredentialsIdentityIdImpl;
import de.bdr.signme.api.v2.impl.CredentialsImpl;
import de.bdr.signme.api.v2.impl.CredentialsUidEmailAddrImpl;
import de.bdr.signme.api.v2.impl.CredentialsUidPwImpl;
import de.bdr.signme.api.v2.impl.SignMeApiV2Impl;
import java.util.Objects;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SignMeApiV2ExtImpl
extends SignMeApiV2Impl
implements SignMeApiV2Ext {
    private static final Logger LOG = LoggerFactory.getLogger(SignMeApiV2ExtImpl.class);
    private final Specinfo specinfo = new Specinfo();
    private String clientInterfaceRevision = this.specinfo.getRevision();

    protected SignMeApiV2ExtImpl(String endpointAddrStr) {
        super(endpointAddrStr);
        if (this.clientInterfaceRevision == null || this.clientInterfaceRevision.isEmpty()) {
            LOG.warn("clientInterfaceRevision is null or empty; please check your WSDL compiler to generate those infos from the WSDL Spec/Element \"SpecInfo\" into the code!");
        }
    }

    public static SignMeApiV2ExtImpl create(String endpointAddrStr) {
        return new SignMeApiV2ExtImpl(endpointAddrStr);
    }

    @Override
    public Credentials createCredentialsUidPw(String roleName, String username, String password) {
        Objects.requireNonNull(password, "password must not be null");
        return new CredentialsUidPwImpl(roleName, username, password);
    }

    @Override
    public Credentials createCredentialsUidPw(String roleName, String username, Supplier<String> pwSupplier) {
        return new CredentialsUidPwImpl(roleName, username, pwSupplier);
    }

    @Override
    public Credentials createCredentialsUidEmail(String roleName, String usernameAsEmailAddress) {
        return new CredentialsUidEmailAddrImpl(roleName, usernameAsEmailAddress);
    }

    @Override
    public Credentials createCredentialsIdentityId(String roleName, String identityId) {
        return new CredentialsIdentityIdImpl(roleName, identityId);
    }

    @Override
    public ApiSession openAppProviderSession(Credentials credentials) {
        return this.openAppProviderSession(credentials, this.getClientIpAddress());
    }

    @Override
    public ApiSession openAppProviderSession(Credentials credentials, String clientIpAddress) {
        Objects.requireNonNull(credentials, "credentials must not be null");
        if (credentials instanceof CredentialsUidPwImpl) {
            ApiSessionImpl apiSession = new ApiSessionImpl(this, null, credentials, clientIpAddress);
            apiSession.ensureAccessTokenIsValid();
            return apiSession;
        }
        throw new IllegalArgumentException("credentials type not supported; supported credentials must be created by factory method in " + SignMeApiV2Ext.class.getName());
    }

    @Override
    public ApiSession openUserSession(ApiSession appProviderSession, Credentials credentials) {
        return this.openUserSession(appProviderSession, credentials, this.getClientIpAddress());
    }

    @Override
    public ApiSession openUserSession(ApiSession appProviderSession, Credentials credentials, String clientIpAddress) {
        Objects.requireNonNull(credentials, "appProviderSession must not be null - the login for the appProviderSession must at least be made of role PARTNER");
        Objects.requireNonNull(credentials, "credentials must not be null");
        if (credentials instanceof CredentialsImpl) {
            ApiSessionImpl apiSession = new ApiSessionImpl(this, appProviderSession, credentials, clientIpAddress);
            apiSession.ensureAccessTokenIsValid();
            return apiSession;
        }
        throw new IllegalArgumentException("credentials type not supported; supported credentials must be created by factory method in " + SignMeApiV2Ext.class.getName());
    }

    @Override
    public ApiSession toIntern(byte[] contextExternalized) {
        ApiSessionImpl apiSession = ApiSessionImpl.toIntern(this, contextExternalized);
        apiSession.ensureAccessTokenIsValid();
        return apiSession;
    }

    String getClientInterfaceRevision() {
        return this.clientInterfaceRevision;
    }
}

