/*
 * Decompiled with CFR 0.152.
 */
package de.bdr.signme.api.v2.impl;

import de.bdr.signme.api.AbstractClient;
import de.bdr.signme.api.v2.ApiStringifier;
import de.bdr.signme.api.v2.SignMeApiV2ValueAppender;
import de.bdr.signme.api.v2.gen.AccessTokenGrant;
import de.bdr.signme.api.v2.gen.AuthenticationTokenSelector;
import de.bdr.signme.api.v2.gen.Certificate;
import de.bdr.signme.api.v2.gen.CertificateTemplate;
import de.bdr.signme.api.v2.gen.GetIdentity;
import de.bdr.signme.api.v2.gen.GetIdentityResponse;
import de.bdr.signme.api.v2.gen.IdentificationTemplate;
import de.bdr.signme.api.v2.gen.IdentitySelector;
import de.bdr.signme.api.v2.gen.IdentityVerificationProcess;
import de.bdr.signme.api.v2.gen.ItemToBeProcessed;
import de.bdr.signme.api.v2.gen.ManageIdentityChangeSet;
import de.bdr.signme.api.v2.gen.ManageTokenParameters;
import de.bdr.signme.api.v2.gen.ManageTokenResult;
import de.bdr.signme.api.v2.gen.Person;
import de.bdr.signme.api.v2.gen.RedirectURLs;
import de.bdr.signme.api.v2.gen.RegisterIdentity;
import de.bdr.signme.api.v2.gen.RegisterIdentityResponse;
import de.bdr.signme.api.v2.gen.RegistrationProcess;
import de.bdr.signme.api.v2.gen.SecurityHeader;
import de.bdr.signme.api.v2.gen.SignMeApiV2;
import de.bdr.signme.api.v2.gen.SignMeApiV2_Service;
import de.bdr.signme.api.v2.gen.SignMeException;
import de.bdr.signme.api.v2.gen.SignatureParameters;
import de.bdr.signme.api.v2.gen.SignatureProcess;
import de.bdr.signme.api.v2.gen.SignatureTemplate;
import de.bdr.signme.api.v2.gen.SignerStatus;
import de.bdr.signme.api.v2.gen.Subscription;
import de.bdr.signme.api.v2.gen.Token;
import de.bdr.signme.api.v2.gen.TokenCapability;
import de.bdr.signme.api.v2.gen.VersionAndDate;
import java.math.BigInteger;
import java.util.List;
import javax.xml.datatype.XMLGregorianCalendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignMeApiV2Impl
extends AbstractClient<SignMeApiV2_Service, SignMeApiV2>
implements SignMeApiV2 {
    private final Logger LOG;
    private final ApiStringifier apiStringifier;

    public SignMeApiV2Impl(String endpointAddrStr) {
        this(endpointAddrStr, LoggerFactory.getLogger(SignMeApiV2Impl.class));
    }

    public SignMeApiV2Impl(String endpointAddrStr, Logger customLogger) {
        super(endpointAddrStr, SignMeApiV2_Service.class, SignMeApiV2.class);
        this.LOG = customLogger;
        this.apiStringifier = new ApiStringifier();
        this.apiStringifier.initialAdd(new SignMeApiV2ValueAppender());
    }

    @Override
    public SignatureProcess createSignatureProcess(SecurityHeader securityHeader, String signatureType, SignatureParameters signatureParameters, String signerUsername, String signerIdentityId, String tokenId, List<ItemToBeProcessed> itemsToBeProcessed, RedirectURLs redirectURLs, Boolean suppressFinalDialog) throws SignMeException {
        try {
            this.logBegin("createSignatureProcess", "securityHeader", securityHeader, "signatureType", signatureType, "signatureParameters", signatureParameters, "signerUsername", signerUsername, "signerIdentityId", signerIdentityId, "itemsToBeProcessed", itemsToBeProcessed, "redirectURLs", redirectURLs, "suppressFinalDialog", suppressFinalDialog);
            SignatureProcess signatureProcess = ((SignMeApiV2)this.getService()).createSignatureProcess(securityHeader, signatureType, signatureParameters, signerUsername, signerIdentityId, tokenId, itemsToBeProcessed, redirectURLs, suppressFinalDialog);
            this.logReturn("createSignatureProcess", "signatureProcess", signatureProcess);
            return signatureProcess;
        }
        catch (SignMeException e) {
            this.LOG.info("usage error at endpoint=" + this.getEndpointAddrStr() + " error=" + e.getMessage());
            throw e;
        }
        catch (Exception e) {
            this.LOG.error("unexpected problem with endpoint=" + this.getEndpointAddrStr(), (Throwable)e);
            this.resetService();
            throw e;
        }
    }

    @Override
    public void updateSignatureProcess(SecurityHeader securityHeader, String signatureProcessId, List<ItemToBeProcessed> itemsToBeProcessed) throws SignMeException {
        try {
            this.logBegin("updateSignatureProcess", "securityHeader", securityHeader, "signatureProcessId", signatureProcessId, "itemsToBeProcessed", itemsToBeProcessed);
            ((SignMeApiV2)this.getService()).updateSignatureProcess(securityHeader, signatureProcessId, itemsToBeProcessed);
            this.logReturn("updateSignatureProcess", new Object[0]);
        }
        catch (SignMeException e) {
            this.LOG.info("usage error at endpoint=" + this.getEndpointAddrStr() + " error=" + e.getMessage());
            throw e;
        }
        catch (Exception e) {
            this.LOG.error("unexpected problem with endpoint=" + this.getEndpointAddrStr(), (Throwable)e);
            this.resetService();
            throw e;
        }
    }

    @Override
    public void cancelSignatureProcess(SecurityHeader securityHeader, String signatureProcessId) throws SignMeException {
        try {
            this.logBegin("cancelSignatureProcess", "securityHeader", securityHeader, "signatureProcessId", signatureProcessId);
            ((SignMeApiV2)this.getService()).cancelSignatureProcess(securityHeader, signatureProcessId);
            this.logReturn("cancelSignatureProcess", new Object[0]);
        }
        catch (SignMeException e) {
            this.LOG.info("usage error at endpoint=" + this.getEndpointAddrStr() + " error=" + e.getMessage());
            throw e;
        }
        catch (Exception e) {
            this.LOG.error("unexpected problem with endpoint=" + this.getEndpointAddrStr(), (Throwable)e);
            this.resetService();
            throw e;
        }
    }

    @Override
    public SignatureProcess getSignatureProcess(SecurityHeader securityHeader, String signatureProcessId, boolean getSignedContent, boolean getVerificationReport, boolean getSignerIdentity) throws SignMeException {
        try {
            this.logBegin("getSignatureProcess", "securityHeader", securityHeader, "signatureProcessId", signatureProcessId, "getSignedContent", getSignedContent, "getVerificationReport", getVerificationReport, "getSignerIdentity", getSignerIdentity);
            SignatureProcess signatureProcess = ((SignMeApiV2)this.getService()).getSignatureProcess(securityHeader, signatureProcessId, getSignedContent, getVerificationReport, getSignerIdentity);
            this.logReturn("getSignatureProcess", "signatureProcess", signatureProcess);
            return signatureProcess;
        }
        catch (SignMeException e) {
            this.LOG.info("usage error at endpoint=" + this.getEndpointAddrStr() + " error=" + e.getMessage());
            throw e;
        }
        catch (Exception e) {
            this.LOG.error("unexpected problem with endpoint=" + this.getEndpointAddrStr(), (Throwable)e);
            this.resetService();
            throw e;
        }
    }

    @Override
    public SignerStatus getSignerStatus(SecurityHeader securityHeader, String signatureType, String signerUsername, String signerIdentityId, XMLGregorianCalendar validAtTimestamp, BigInteger minimumValidityDurationSec, BigInteger maxActiveSignatureProcesses, BigInteger maxFinalSignatureProcesses) throws SignMeException {
        try {
            this.logBegin("getSignerStatus", "securityHeader", securityHeader, "signatureType", signatureType, "signerUsername", signerUsername, "signerIdentityId", signerIdentityId, "validAtTimestamp", validAtTimestamp, "minimumValidityDurationSec", minimumValidityDurationSec, "maxActiveSignatureProcesses", maxActiveSignatureProcesses, "maxFinalSignatureProcesses", maxFinalSignatureProcesses);
            SignerStatus signerStatus = ((SignMeApiV2)this.getService()).getSignerStatus(securityHeader, signatureType, signerUsername, signerIdentityId, validAtTimestamp, minimumValidityDurationSec, maxActiveSignatureProcesses, maxFinalSignatureProcesses);
            this.logReturn("getSignerStatus", "signerStatus", signerStatus);
            return signerStatus;
        }
        catch (SignMeException e) {
            this.LOG.info("usage error at endpoint=" + this.getEndpointAddrStr() + " error=" + e.getMessage());
            throw e;
        }
        catch (Exception e) {
            this.LOG.error("unexpected problem with endpoint=" + this.getEndpointAddrStr(), (Throwable)e);
            this.resetService();
            throw e;
        }
    }

    @Override
    public SignatureTemplate getSignatureTemplate(SecurityHeader securityHeader, String signatureTemplateId, Boolean includeCoins) throws SignMeException {
        try {
            this.logBegin("getSignatureTemplate", "securityHeader", securityHeader, "signatureTemplateId", signatureTemplateId, "includeCoins", includeCoins);
            SignatureTemplate signatureTemplate = ((SignMeApiV2)this.getService()).getSignatureTemplate(securityHeader, signatureTemplateId, includeCoins);
            this.logReturn("getSignatureTemplate", "signatureTemplate", signatureTemplate);
            return signatureTemplate;
        }
        catch (SignMeException e) {
            this.LOG.info("usage error at endpoint=" + this.getEndpointAddrStr() + " error=" + e.getMessage());
            throw e;
        }
        catch (Exception e) {
            this.LOG.error("unexpected problem with endpoint=" + this.getEndpointAddrStr(), (Throwable)e);
            this.resetService();
            throw e;
        }
    }

    @Override
    public AccessTokenGrant authorizeProcess(SecurityHeader securityHeader, String roleName, AuthenticationTokenSelector authenticationTokenSelector, String processId) throws SignMeException {
        try {
            this.logBegin("authorizeProcess", "securityHeader", securityHeader, "roleName", roleName, "authenticationTokenSelector", authenticationTokenSelector, "processId", processId);
            AccessTokenGrant accessTokenGrant = ((SignMeApiV2)this.getService()).authorizeProcess(securityHeader, roleName, authenticationTokenSelector, processId);
            this.logReturn("authorizeProcess", "accessTokenGrant", accessTokenGrant);
            return accessTokenGrant;
        }
        catch (SignMeException e) {
            this.LOG.info("usage error at endpoint=" + this.getEndpointAddrStr() + " error=" + e.getMessage());
            throw e;
        }
        catch (Exception e) {
            this.LOG.error("unexpected problem with endpoint=" + this.getEndpointAddrStr(), (Throwable)e);
            this.resetService();
            throw e;
        }
    }

    @Override
    public AccessTokenGrant authorizeProcessStep2(SecurityHeader securityHeader, List<byte[]> authenticationData) throws SignMeException {
        try {
            this.logBegin("authorizeProcessStep2", "securityHeader", securityHeader, "authenticationData", authenticationData);
            AccessTokenGrant accessTokenGrant = ((SignMeApiV2)this.getService()).authorizeProcessStep2(securityHeader, authenticationData);
            this.logReturn("authorizeProcessStep2", "accessTokenGrant", accessTokenGrant);
            return accessTokenGrant;
        }
        catch (SignMeException e) {
            this.LOG.info("usage error at endpoint=" + this.getEndpointAddrStr() + " error=" + e.getMessage());
            throw e;
        }
        catch (Exception e) {
            this.LOG.error("unexpected problem with endpoint=" + this.getEndpointAddrStr(), (Throwable)e);
            this.resetService();
            throw e;
        }
    }

    @Override
    public void revokeCertificateOfTokenActivationProcess(SecurityHeader securityHeader, String activationProcessId) throws SignMeException {
        try {
            this.logBegin("revokeCertificateOfTokenActivationProcess", "securityHeader", securityHeader, "activationProcessId", activationProcessId);
            ((SignMeApiV2)this.getService()).revokeCertificateOfTokenActivationProcess(securityHeader, activationProcessId);
            this.logReturn("revokeCertificateOfTokenActivationProcess", new Object[0]);
        }
        catch (SignMeException e) {
            this.LOG.info("usage error at endpoint=" + this.getEndpointAddrStr() + " error=" + e.getMessage());
            throw e;
        }
        catch (Exception e) {
            this.LOG.error("unexpected problem with endpoint=" + this.getEndpointAddrStr(), (Throwable)e);
            this.resetService();
            throw e;
        }
    }

    @Override
    public List<Certificate> getCertificate(SecurityHeader securityHeader, String certificateId, boolean includeChain) throws SignMeException {
        try {
            this.logBegin("getCertificate", "securityHeader", securityHeader, "certificateId", certificateId, "includeChain", includeChain);
            List<Certificate> certificates = ((SignMeApiV2)this.getService()).getCertificate(securityHeader, certificateId, includeChain);
            this.logReturn("getCertificate", "certificates", certificates);
            return certificates;
        }
        catch (SignMeException e) {
            this.LOG.info("usage error at endpoint=" + this.getEndpointAddrStr() + " error=" + e.getMessage());
            throw e;
        }
        catch (Exception e) {
            this.LOG.error("unexpected problem with endpoint=" + this.getEndpointAddrStr(), (Throwable)e);
            this.resetService();
            throw e;
        }
    }

    @Override
    public CertificateTemplate getCertificateTemplate(SecurityHeader securityHeader, String certificateTemplateId) throws SignMeException {
        try {
            return ((SignMeApiV2)this.getService()).getCertificateTemplate(securityHeader, certificateTemplateId);
        }
        catch (SignMeException e) {
            this.LOG.info("usage error at endpoint=" + this.getEndpointAddrStr() + " error=" + e.getMessage());
            throw e;
        }
        catch (Exception e) {
            this.LOG.error("unexpected problem with endpoint=" + this.getEndpointAddrStr(), (Throwable)e);
            this.resetService();
            throw e;
        }
    }

    @Override
    public List<String> getAuthenticationTokenTypesForIdentity(SecurityHeader securityHeader, IdentitySelector identitySelector) throws SignMeException {
        try {
            this.logBegin("getAuthenticationTokenTypesForIdentity", "securityHeader", securityHeader, "identitySelector", identitySelector);
            List<String> authenticationTokenTypesForIdentity = ((SignMeApiV2)this.getService()).getAuthenticationTokenTypesForIdentity(securityHeader, identitySelector);
            this.logReturn("getAuthenticationTokenTypesForIdentity", "authenticationTokenTypesForIdentity", authenticationTokenTypesForIdentity);
            return authenticationTokenTypesForIdentity;
        }
        catch (SignMeException e) {
            this.LOG.info("usage error at endpoint=" + this.getEndpointAddrStr() + " error=" + e.getMessage());
            throw e;
        }
        catch (Exception e) {
            this.LOG.error("unexpected problem with endpoint=" + this.getEndpointAddrStr(), (Throwable)e);
            this.resetService();
            throw e;
        }
    }

    @Override
    public List<Token> getTokensForIdentity(SecurityHeader securityHeader, IdentitySelector identitySelector, List<TokenCapability> havingTokenCapabilities, Boolean includeOnlyIfDefaultToken, Boolean includeOnlyIfHasValidCertificateOnly, Boolean includeSubjectCertificateIfAny, Boolean includeActivationProcessIfAny) throws SignMeException {
        try {
            this.logBegin("getTokensForIdentity", "securityHeader", securityHeader, "identitySelector", identitySelector, "havingTokenCapabilities", havingTokenCapabilities, " includeOnlyIfDefaultToken", includeOnlyIfDefaultToken, " includeOnlyIfHasValidCertificateOnly", includeOnlyIfHasValidCertificateOnly, "includeSubjectCertificateIfAny", includeSubjectCertificateIfAny, "includeActivationProcessIfAny", includeActivationProcessIfAny);
            List<Token> tokensForIdentity = ((SignMeApiV2)this.getService()).getTokensForIdentity(securityHeader, identitySelector, havingTokenCapabilities, includeOnlyIfDefaultToken, includeOnlyIfHasValidCertificateOnly, includeSubjectCertificateIfAny, includeActivationProcessIfAny);
            this.logReturn("getTokensForIdentity", "tokensForIdentity", tokensForIdentity);
            return tokensForIdentity;
        }
        catch (SignMeException e) {
            this.LOG.info("usage error at endpoint=" + this.getEndpointAddrStr() + " error=" + e.getMessage());
            throw e;
        }
        catch (Exception e) {
            this.LOG.error("unexpected problem with endpoint=" + this.getEndpointAddrStr(), (Throwable)e);
            this.resetService();
            throw e;
        }
    }

    @Override
    public Token getToken(SecurityHeader securityHeader, String tokenId, Boolean includeSubjectCertificateIfAny, Boolean includeActivationProcessIfAny) throws SignMeException {
        try {
            this.logBegin("getToken", "securityHeader", securityHeader, "tokenId", tokenId, "includeSubjectCertificateIfAny", includeSubjectCertificateIfAny, "includeActivationProcessIfAny", includeActivationProcessIfAny);
            Token token = ((SignMeApiV2)this.getService()).getToken(securityHeader, tokenId, includeSubjectCertificateIfAny, includeActivationProcessIfAny);
            this.logReturn("getToken", "token", token);
            return token;
        }
        catch (SignMeException e) {
            this.LOG.info("usage error at endpoint=" + this.getEndpointAddrStr() + " error=" + e.getMessage());
            throw e;
        }
        catch (Exception e) {
            this.LOG.error("unexpected problem with endpoint=" + this.getEndpointAddrStr(), (Throwable)e);
            this.resetService();
            throw e;
        }
    }

    @Override
    public RegistrationProcess createRegistrationProcess(SecurityHeader securityHeader, RedirectURLs redirectURLs, Person person) throws SignMeException {
        try {
            this.logBegin("createRegistrationProcess", "securityHeader", securityHeader, "redirectURLs", redirectURLs, "person", person);
            RegistrationProcess registrationProcess = ((SignMeApiV2)this.getService()).createRegistrationProcess(securityHeader, redirectURLs, person);
            this.logReturn("createRegistrationProcess", "registrationProcess", registrationProcess);
            return registrationProcess;
        }
        catch (SignMeException e) {
            this.LOG.info("usage error at endpoint=" + this.getEndpointAddrStr() + " error=" + e.getMessage());
            throw e;
        }
        catch (Exception e) {
            this.LOG.error("unexpected problem with endpoint=" + this.getEndpointAddrStr(), (Throwable)e);
            this.resetService();
            throw e;
        }
    }

    @Override
    public void updateRegistrationProcess(SecurityHeader securityHeader, String registrationProcessId, Person person, Boolean complete, Boolean suppressConfirmationEmail) throws SignMeException {
        try {
            this.logBegin("updateRegistrationProcess", "securityHeader", securityHeader, "registrationProcessId", registrationProcessId, "person", person, "complete", complete, "suppressConfirmationEmail", suppressConfirmationEmail);
            ((SignMeApiV2)this.getService()).updateRegistrationProcess(securityHeader, registrationProcessId, person, complete, suppressConfirmationEmail);
            this.logReturn("updateRegistrationProcess", new Object[0]);
        }
        catch (SignMeException e) {
            this.LOG.info("usage error at endpoint=" + this.getEndpointAddrStr() + " error=" + e.getMessage());
            throw e;
        }
        catch (Exception e) {
            this.LOG.error("unexpected problem with endpoint=" + this.getEndpointAddrStr(), (Throwable)e);
            this.resetService();
            throw e;
        }
    }

    @Override
    public RegistrationProcess getRegistrationProcess(SecurityHeader securityHeader, String registrationProcessId) throws SignMeException {
        try {
            this.logBegin("getRegistrationProcess", "securityHeader", securityHeader, "registrationProcessId", registrationProcessId);
            RegistrationProcess registrationProcess = ((SignMeApiV2)this.getService()).getRegistrationProcess(securityHeader, registrationProcessId);
            this.logReturn("getRegistrationProcess", "registrationProcess", registrationProcess);
            return registrationProcess;
        }
        catch (SignMeException e) {
            this.LOG.info("usage error at endpoint=" + this.getEndpointAddrStr() + " error=" + e.getMessage());
            throw e;
        }
        catch (Exception e) {
            this.LOG.error("unexpected problem with endpoint=" + this.getEndpointAddrStr(), (Throwable)e);
            this.resetService();
            throw e;
        }
    }

    @Override
    public RegisterIdentityResponse registerIdentity(RegisterIdentity parameters) throws SignMeException {
        try {
            this.logBegin("registerIdentity", "parameters", parameters);
            RegisterIdentityResponse response = ((SignMeApiV2)this.getService()).registerIdentity(parameters);
            this.logReturn("registerIdentity", "response", response);
            return response;
        }
        catch (SignMeException e) {
            this.LOG.info("usage error at endpoint=" + this.getEndpointAddrStr() + " error=" + e.getMessage());
            throw e;
        }
        catch (Exception e) {
            this.LOG.error("unexpected problem with endpoint=" + this.getEndpointAddrStr(), (Throwable)e);
            this.resetService();
            throw e;
        }
    }

    @Override
    public GetIdentityResponse getIdentity(GetIdentity parameters) throws SignMeException {
        try {
            this.logBegin("getIdentity", "parameters", parameters);
            GetIdentityResponse response = ((SignMeApiV2)this.getService()).getIdentity(parameters);
            this.logReturn("getIdentity", "response", response);
            return response;
        }
        catch (SignMeException e) {
            this.LOG.info("usage error at endpoint=" + this.getEndpointAddrStr() + " error=" + e.getMessage());
            throw e;
        }
        catch (Exception e) {
            this.LOG.error("unexpected problem with endpoint=" + this.getEndpointAddrStr(), (Throwable)e);
            this.resetService();
            throw e;
        }
    }

    @Override
    public void confirmCommunication(SecurityHeader securityHeader, String code) throws SignMeException {
        try {
            this.logBegin("confirmCommunication", "securityHeader", securityHeader, "code", code);
            ((SignMeApiV2)this.getService()).confirmCommunication(securityHeader, code);
            this.logReturn("confirmCommunication", new Object[0]);
        }
        catch (SignMeException e) {
            this.LOG.info("usage error at endpoint=" + this.getEndpointAddrStr() + " error=" + e.getMessage());
            throw e;
        }
        catch (Exception e) {
            this.LOG.error("unexpected problem with endpoint=" + this.getEndpointAddrStr(), (Throwable)e);
            this.resetService();
            throw e;
        }
    }

    @Override
    public IdentificationTemplate getIdentificationTemplate(SecurityHeader securityHeader, String identificationTemplateId) throws SignMeException {
        try {
            return ((SignMeApiV2)this.getService()).getIdentificationTemplate(securityHeader, identificationTemplateId);
        }
        catch (SignMeException e) {
            this.LOG.info("usage error at endpoint=" + this.getEndpointAddrStr() + " error=" + e.getMessage());
            throw e;
        }
        catch (Exception e) {
            this.LOG.error("unexpected problem with endpoint=" + this.getEndpointAddrStr(), (Throwable)e);
            this.resetService();
            throw e;
        }
    }

    @Override
    public IdentityVerificationProcess createIdentityVerificationProcess(SecurityHeader securityHeader, String preferredIdentityVerificationType, String username, String identityId, Person person, Boolean suppressConfirmationEmail, RedirectURLs redirectURLs) throws SignMeException {
        try {
            this.logBegin("createIdentityVerificationProcess", "securityHeader", securityHeader, "preferredIdentityVerificationType", preferredIdentityVerificationType, "username", username, "identityId", identityId, "person", person, "suppressConfirmationEmail", suppressConfirmationEmail, "redirectURLs", redirectURLs);
            IdentityVerificationProcess identityVerificationProcess = ((SignMeApiV2)this.getService()).createIdentityVerificationProcess(securityHeader, preferredIdentityVerificationType, username, identityId, person, suppressConfirmationEmail, redirectURLs);
            this.logReturn("createIdentityVerificationProcess", "identityVerificationProcess", identityVerificationProcess);
            return identityVerificationProcess;
        }
        catch (SignMeException e) {
            this.LOG.info("usage error at endpoint=" + this.getEndpointAddrStr() + " error=" + e.getMessage());
            throw e;
        }
        catch (Exception e) {
            this.LOG.error("unexpected problem with endpoint=" + this.getEndpointAddrStr(), (Throwable)e);
            this.resetService();
            throw e;
        }
    }

    @Override
    public void cancelIdentityVerificationProcess(SecurityHeader securityHeader, String identityVerificationProcessId) throws SignMeException {
        try {
            this.logBegin("cancelIdentityVerificationProcess", "securityHeader", securityHeader, "identityVerificationProcessId", identityVerificationProcessId);
            ((SignMeApiV2)this.getService()).cancelIdentityVerificationProcess(securityHeader, identityVerificationProcessId);
            this.logReturn("cancelIdentityVerificationProcess", new Object[0]);
        }
        catch (SignMeException e) {
            this.LOG.info("usage error at endpoint=" + this.getEndpointAddrStr() + " error=" + e.getMessage());
            throw e;
        }
        catch (Exception e) {
            this.LOG.error("unexpected problem with endpoint=" + this.getEndpointAddrStr(), (Throwable)e);
            this.resetService();
            throw e;
        }
    }

    @Override
    public IdentityVerificationProcess getIdentityVerificationProcess(SecurityHeader securityHeader, String identityVerificationProcessId, Boolean includeCoins, List<byte[]> authenticationData) throws SignMeException {
        try {
            this.logBegin("getIdentityVerificationProcess", "securityHeader", securityHeader, "identityVerificationProcessId", identityVerificationProcessId, "includeCoins", includeCoins, "authenticationData", authenticationData);
            IdentityVerificationProcess identityVerificationProcess = ((SignMeApiV2)this.getService()).getIdentityVerificationProcess(securityHeader, identityVerificationProcessId, includeCoins, authenticationData);
            this.logReturn("getIdentityVerificationProcess", "identityVerificationProcess", identityVerificationProcess);
            return identityVerificationProcess;
        }
        catch (SignMeException e) {
            this.LOG.info("usage error at endpoint=" + this.getEndpointAddrStr() + " error=" + e.getMessage());
            throw e;
        }
        catch (Exception e) {
            this.LOG.error("unexpected problem with endpoint=" + this.getEndpointAddrStr(), (Throwable)e);
            this.resetService();
            throw e;
        }
    }

    @Override
    public void manageIdentity(SecurityHeader securityHeader, String identityId, String username, ManageIdentityChangeSet changeSet) throws SignMeException {
        try {
            this.logBegin("manageIdentity", "securityHeader", securityHeader, "identityId", identityId, "username", username, "changeSet", changeSet);
            ((SignMeApiV2)this.getService()).manageIdentity(securityHeader, identityId, username, changeSet);
            this.logReturn("manageIdentity", new Object[0]);
        }
        catch (SignMeException e) {
            this.LOG.info("usage error at endpoint=" + this.getEndpointAddrStr() + " error=" + e.getMessage());
            throw e;
        }
        catch (Exception e) {
            this.LOG.error("unexpected problem with endpoint=" + this.getEndpointAddrStr(), (Throwable)e);
            this.resetService();
            throw e;
        }
    }

    @Override
    public Subscription manageSubscription(SecurityHeader securityHeader, String identityId, String username, int startingOffset, int duration) throws SignMeException {
        try {
            this.logBegin("manageSubscription", "securityHeader", securityHeader, "identityId", identityId, "username", username, "startingOffset", startingOffset, "duration", duration);
            Subscription subscription = ((SignMeApiV2)this.getService()).manageSubscription(securityHeader, identityId, username, startingOffset, duration);
            this.logReturn("manageSubscription", "subscription", subscription);
            return subscription;
        }
        catch (SignMeException e) {
            this.LOG.info("usage error at endpoint=" + this.getEndpointAddrStr() + " error=" + e.getMessage());
            throw e;
        }
        catch (Exception e) {
            this.LOG.error("unexpected problem with endpoint=" + this.getEndpointAddrStr(), (Throwable)e);
            this.resetService();
            throw e;
        }
    }

    @Override
    public ManageTokenResult manageToken(SecurityHeader securityHeader, String identityId, ManageTokenParameters manageTokenParameters) throws SignMeException {
        try {
            this.logBegin("manageToken", "securityHeader", securityHeader, "identityId", identityId, "manageTokenParameters", manageTokenParameters);
            ManageTokenResult manageTokenResult = ((SignMeApiV2)this.getService()).manageToken(securityHeader, identityId, manageTokenParameters);
            this.logReturn("manageToken", "manageTokenResult", manageTokenResult);
            return manageTokenResult;
        }
        catch (SignMeException e) {
            this.LOG.info("usage error at endpoint=" + this.getEndpointAddrStr() + " error=" + e.getMessage());
            throw e;
        }
        catch (Exception e) {
            this.LOG.error("unexpected problem with endpoint=" + this.getEndpointAddrStr(), (Throwable)e);
            this.resetService();
            throw e;
        }
    }

    @Override
    public AccessTokenGrant login(SecurityHeader optAppProviderSecurityHeader, String clientIpAddress, String roleName, AuthenticationTokenSelector authenticationTokenSelector, String requiredIfRevision) throws SignMeException {
        try {
            this.logBegin("login", "optAppProviderSecurityHeader", optAppProviderSecurityHeader, "clientIpAddress", clientIpAddress, "roleName", roleName, "authenticationTokenSelector", authenticationTokenSelector, "requiredIfRevision", requiredIfRevision);
            AccessTokenGrant accessTokenGrant = ((SignMeApiV2)this.getService()).login(optAppProviderSecurityHeader, clientIpAddress, roleName, authenticationTokenSelector, requiredIfRevision);
            this.logReturn("login", "accessTokenGrant", accessTokenGrant);
            return accessTokenGrant;
        }
        catch (SignMeException e) {
            this.LOG.info("usage error at endpoint=" + this.getEndpointAddrStr() + " error=" + e.getMessage());
            throw e;
        }
        catch (Exception e) {
            this.LOG.error("unexpected problem with endpoint=" + this.getEndpointAddrStr(), (Throwable)e);
            this.resetService();
            throw e;
        }
    }

    @Override
    public AccessTokenGrant loginStep2(SecurityHeader securityHeader, List<byte[]> authenticationData) throws SignMeException {
        try {
            this.logBegin("loginStep2", "securityHeader", securityHeader, "authenticationData", authenticationData);
            AccessTokenGrant accessTokenGrant = ((SignMeApiV2)this.getService()).loginStep2(securityHeader, authenticationData);
            this.logReturn("loginStep2", "accessTokenGrant", accessTokenGrant);
            return accessTokenGrant;
        }
        catch (SignMeException e) {
            this.LOG.info("usage error at endpoint=" + this.getEndpointAddrStr() + " error=" + e.getMessage());
            throw e;
        }
        catch (Exception e) {
            this.LOG.error("unexpected problem with endpoint=" + this.getEndpointAddrStr(), (Throwable)e);
            this.resetService();
            throw e;
        }
    }

    @Override
    public AccessTokenGrant refreshLogin(SecurityHeader securityHeader) throws SignMeException {
        try {
            this.logBegin("refreshLogin", "securityHeader", securityHeader);
            AccessTokenGrant accessTokenGrant = ((SignMeApiV2)this.getService()).refreshLogin(securityHeader);
            this.logReturn("refreshLogin", "accessTokenGrant", accessTokenGrant);
            return accessTokenGrant;
        }
        catch (SignMeException e) {
            this.LOG.info("usage error at endpoint=" + this.getEndpointAddrStr() + " error=" + e.getMessage());
            throw e;
        }
        catch (Exception e) {
            this.LOG.error("unexpected problem with endpoint=" + this.getEndpointAddrStr(), (Throwable)e);
            this.resetService();
            throw e;
        }
    }

    @Override
    public void logout(SecurityHeader securityHeader) throws SignMeException {
        try {
            this.logBegin("logout", "securityHeader", securityHeader);
            ((SignMeApiV2)this.getService()).logout(securityHeader);
            this.logReturn("logout", new Object[0]);
        }
        catch (SignMeException e) {
            this.LOG.info("usage error at endpoint=" + this.getEndpointAddrStr() + " error=" + e.getMessage());
            throw e;
        }
        catch (Exception e) {
            this.LOG.error("unexpected problem with endpoint=" + this.getEndpointAddrStr(), (Throwable)e);
            this.resetService();
            throw e;
        }
    }

    @Override
    public VersionAndDate getVersion(SecurityHeader securityHeader) throws SignMeException {
        try {
            this.logBegin("getVersion", "securityHeader", securityHeader);
            VersionAndDate versionAndDate = ((SignMeApiV2)this.getService()).getVersion(securityHeader);
            this.logReturn("getVersion", "versionAndDate", versionAndDate);
            return versionAndDate;
        }
        catch (SignMeException e) {
            this.LOG.info("usage error at endpoint=" + this.getEndpointAddrStr() + " error=" + e.getMessage());
            throw e;
        }
        catch (Exception e) {
            this.LOG.error("unexpected problem with endpoint=" + this.getEndpointAddrStr(), (Throwable)e);
            this.resetService();
            throw e;
        }
    }

    private void logBegin(String mn, Object ... namesAndValues) {
        this.LOG.info(mn + "#begin#EIF " + this.appendNonEmptyNamesAndValues(namesAndValues));
    }

    private void logReturn(String mn, Object ... namesAndValues) {
        this.LOG.info(mn + "#return#EIF " + this.appendNonEmptyNamesAndValues(namesAndValues));
    }

    private String appendNonEmptyNamesAndValues(Object ... namesAndValues) {
        return namesAndValues != null && namesAndValues.length > 1 ? this.apiStringifier.toString(namesAndValues) : "";
    }
}

