/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authorization.method;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.function.Function;
import org.springframework.aop.support.AopUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.expression.Expression;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.security.authorization.method.AbstractExpressionAttributeRegistry;
import org.springframework.security.authorization.method.AuthorizationAnnotationUtils;
import org.springframework.security.authorization.method.ExpressionAttribute;
import org.springframework.security.authorization.method.HandleAuthorizationDenied;
import org.springframework.security.authorization.method.MethodAuthorizationDeniedHandler;
import org.springframework.security.authorization.method.PostAuthorizeExpressionAttribute;
import org.springframework.security.authorization.method.ThrowingMethodAuthorizationDeniedHandler;
import org.springframework.util.Assert;
import reactor.util.annotation.NonNull;

final class PostAuthorizeExpressionAttributeRegistry
extends AbstractExpressionAttributeRegistry<ExpressionAttribute> {
    private final MethodAuthorizationDeniedHandler defaultHandler = new ThrowingMethodAuthorizationDeniedHandler();
    private Function<Class<? extends MethodAuthorizationDeniedHandler>, MethodAuthorizationDeniedHandler> handlerResolver = clazz -> this.defaultHandler;

    PostAuthorizeExpressionAttributeRegistry() {
    }

    @Override
    @NonNull
    ExpressionAttribute resolveAttribute(Method method, Class<?> targetClass) {
        Method specificMethod = AopUtils.getMostSpecificMethod((Method)method, targetClass);
        PostAuthorize postAuthorize = this.findPostAuthorizeAnnotation(specificMethod, targetClass);
        if (postAuthorize == null) {
            return ExpressionAttribute.NULL_ATTRIBUTE;
        }
        Expression expression = this.getExpressionHandler().getExpressionParser().parseExpression(postAuthorize.value());
        MethodAuthorizationDeniedHandler deniedHandler = this.resolveHandler(method, targetClass);
        return new PostAuthorizeExpressionAttribute(expression, deniedHandler);
    }

    private MethodAuthorizationDeniedHandler resolveHandler(Method method, Class<?> targetClass) {
        Function<AnnotatedElement, HandleAuthorizationDenied> lookup = AuthorizationAnnotationUtils.withDefaults(HandleAuthorizationDenied.class);
        HandleAuthorizationDenied deniedHandler = lookup.apply(method);
        if (deniedHandler != null) {
            return this.handlerResolver.apply(deniedHandler.handlerClass());
        }
        deniedHandler = lookup.apply(this.targetClass(method, targetClass));
        if (deniedHandler != null) {
            return this.handlerResolver.apply(deniedHandler.handlerClass());
        }
        return this.defaultHandler;
    }

    private PostAuthorize findPostAuthorizeAnnotation(Method method, Class<?> targetClass) {
        Function<AnnotatedElement, PostAuthorize> lookup = this.findUniqueAnnotation(PostAuthorize.class);
        PostAuthorize postAuthorize = lookup.apply(method);
        return postAuthorize != null ? postAuthorize : lookup.apply(this.targetClass(method, targetClass));
    }

    void setApplicationContext(ApplicationContext context) {
        Assert.notNull((Object)context, (String)"context cannot be null");
        this.handlerResolver = clazz -> this.resolveHandler(context, (Class<? extends MethodAuthorizationDeniedHandler>)clazz);
    }

    private MethodAuthorizationDeniedHandler resolveHandler(ApplicationContext context, Class<? extends MethodAuthorizationDeniedHandler> handlerClass) {
        if (handlerClass == this.defaultHandler.getClass()) {
            return this.defaultHandler;
        }
        Object[] beanNames = context.getBeanNamesForType(handlerClass);
        if (beanNames.length == 0) {
            throw new IllegalStateException("Could not find a bean of type " + handlerClass.getName());
        }
        if (beanNames.length > 1) {
            throw new IllegalStateException("Expected to find a single bean of type " + handlerClass.getName() + " but found " + Arrays.toString(beanNames));
        }
        return (MethodAuthorizationDeniedHandler)context.getBean(beanNames[0], handlerClass);
    }
}

