/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.document.type.pkcs7;

import de.intarsys.asn1.cms.CMS;
import de.intarsys.asn1.cms.SignedData;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.stream.StreamTools;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;

public class PKCS7DocumentTools {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getFileExtension(byte[] content) {
        String string;
        ByteArrayInputStream is = null;
        try {
            is = new ByteArrayInputStream(content);
            CMS cms = CMS.createFromInputStream((InputStream)is);
            string = PKCS7DocumentTools.getFileExtension(cms);
        }
        catch (IOException iOException) {
            StreamTools.close(is);
            return null;
        }
        catch (Throwable throwable) {
            StreamTools.close(is);
            throw throwable;
        }
        StreamTools.close((Closeable)is);
        return string;
    }

    public static String getFileExtension(CMS cms) {
        if (cms == null) {
            return null;
        }
        if (cms.isSignedData()) {
            SignedData signedData = cms.getSignedData();
            if (signedData.getEncapContentInfo() == null) {
                return "p7s";
            }
            return "p7m";
        }
        if (cms.isEnvelopedData()) {
            return "p7m";
        }
        return null;
    }

    public static String getFileExtension(ILocator locator) {
        try {
            CMS cms = CMS.createFromLocator((ILocator)locator);
            return PKCS7DocumentTools.getFileExtension(cms);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private PKCS7DocumentTools() {
    }
}

