/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.document.type.pkcs7;

import de.intarsys.asn1.cms.CMS;
import de.intarsys.document.common.CommonDocumentType;
import de.intarsys.document.model.IDocumentType;
import de.intarsys.document.type.pkcs7.PACKAGE;
import de.intarsys.document.type.pkcs7.PKCS7Document;
import de.intarsys.document.type.pkcs7.PKCS7EnvelopeDocument;
import de.intarsys.document.type.pkcs7.PKCS7SignatureDocument;
import de.intarsys.security.method.cms.signature.CMSSignature;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.message.IMessageBundle;
import java.io.IOException;

public class PKCS7DocumentType
extends CommonDocumentType<PKCS7Document, CMS> {
    public static final String BASE_TYPE = "PKCS#7";
    public static final String ID = PKCS7DocumentType.class.getName();
    public static final IDocumentType INSTANCE = new PKCS7DocumentType();
    private static final IMessageBundle Msg = PACKAGE.Messages;

    protected PKCS7Document basicCreateFromImpl(ILocator locator, Object impl) {
        CMS cms = null;
        if (impl instanceof CMS) {
            cms = (CMS)impl;
        }
        if (impl instanceof CMSSignature) {
            cms = ((CMSSignature)impl).getCMS();
        }
        return this.createDocument(locator, cms);
    }

    protected PKCS7Document basicCreateFromLocator(ILocator locator, IArgs args) throws IOException {
        return this.createDocument(locator, CMS.createFromLocator((ILocator)locator));
    }

    protected PKCS7SignatureDocument basicCreateNew(IArgs args) {
        return null;
    }

    protected PKCS7Document createDocument(ILocator locator, CMS cms) {
        if (cms == null) {
            return null;
        }
        if (cms.isSignedData()) {
            return new PKCS7SignatureDocument((IDocumentType)this, locator, cms);
        }
        if (cms.isEnvelopedData()) {
            return new PKCS7EnvelopeDocument((IDocumentType)this, locator, cms);
        }
        return new PKCS7SignatureDocument((IDocumentType)this, locator, cms);
    }

    protected String getBaseName(Object impl) {
        return Msg.getString("PKCS7Document.BaseName", new Object[0]);
    }

    protected String getBaseType(Object impl) {
        return BASE_TYPE;
    }

    protected String getDefaultDefaultExtension() {
        return "p7s";
    }

    protected String getDefaultDefaultMimeType() {
        return "application/pkcs7-mime";
    }

    public String getLabel() {
        return BASE_TYPE;
    }
}

