/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.document.type.pkcs7;

import de.intarsys.asn1.cms.CMS;
import de.intarsys.asn1.cms.EnvelopedData;
import de.intarsys.asn1.cms.RecipientInfo;
import de.intarsys.asn1.cms.RecipientInfos;
import de.intarsys.document.common.DocumentTools;
import de.intarsys.document.model.IDocument;
import de.intarsys.document.type.pkcs7.PACKAGE;
import de.intarsys.document.type.pkcs7.PKCS7EnvelopeDocument;
import de.intarsys.security.app.crypt.IDecryptedData;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.filter.IX509CertificateFilter;
import de.intarsys.security.certificate.provider.ICertificateProvider;
import de.intarsys.security.certificate.provider.ICertificateProviderSupport;
import de.intarsys.security.document.type.pkcs7.common.CommonDocumentExtractor;
import de.intarsys.security.method.cms.decryption.PKCS7DecryptionTools;
import de.intarsys.security.processor.decryption.DecryptionEnvironment;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.factory.InstanceSpec;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.FunctorTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.reporter.Reporter;
import java.io.IOException;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PKCS7EnvelopeDocumentExtractor
extends CommonDocumentExtractor<PKCS7EnvelopeDocument> {
    private static final Logger Log = LoggerFactory.getLogger(PKCS7EnvelopeDocumentExtractor.class);
    private static final IMessageBundle Msg = PACKAGE.Messages;

    public static IArgs searchDevice(PKCS7EnvelopeDocument doc) throws IOException {
        try {
            EnvelopedData data = ((CMS)doc.getImpl()).getEnvelopedData();
            RecipientInfos infos = data.getRecipientInfos();
            for (int j = 0; j < infos.size(); ++j) {
                RecipientInfo recipientInfo = infos.get(j);
                try {
                    IArgs result = PKCS7EnvelopeDocumentExtractor.searchDevice(recipientInfo);
                    if (result == null) continue;
                    return result;
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            Log.warn(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    protected static IArgs searchDevice(RecipientInfo recipientInfo) throws IOException {
        IX509CertificateFilter selector = PKCS7DecryptionTools.createCertificateSelector((RecipientInfo)recipientInfo);
        for (IFactory factory : DecryptionEnvironment.get().getDecryptorFactories()) {
            ICertificateProvider provider;
            Iterator certificates;
            if (!(factory instanceof ICertificateProviderSupport) || !(certificates = (provider = ((ICertificateProviderSupport)factory).getCertificateProvider()).lookupCertificates(selector)).hasNext()) continue;
            IX509Certificate certificate = (IX509Certificate)certificates.next();
            InstanceSpec tempSpec = InstanceSpec.createFromFactory(Object.class, (Object)factory, (Object)Args.create());
            tempSpec.getArgs().put("decryptorIdentifier", (Object)certificate);
            return InstanceSpec.put((IArgs)Args.create(), (String)"cekDecryptor", (Object)tempSpec);
        }
        return null;
    }

    public PKCS7EnvelopeDocumentExtractor(IFactory factory, IDocument doc) {
        super(factory, doc);
    }

    @Override
    protected IDocument extractDocument(PKCS7EnvelopeDocument baseDoc) throws Exception {
        IDecryptedData decryptedData = null;
        Args decryptArgs = Args.create();
        decryptArgs.put("document", (Object)baseDoc);
        IArgs device = null;
        try {
            device = PKCS7EnvelopeDocumentExtractor.searchDevice(baseDoc);
            ArgTools.putAll((IArgs)decryptArgs, (IArgs)device);
        }
        catch (IOException e) {
            throw new IOException("can't extract document, device no found", e);
        }
        try {
            if (device != null) {
                decryptedData = (IDecryptedData)FunctorTools.perform((Object)"de.intarsys.security.document.type.pkcs7.decryption.PKCS7DocumentDecryptorFactory", (IArgs)decryptArgs);
            }
        }
        catch (Exception e) {
            Throwable cause = ExceptionTools.unwrap((Throwable)e);
            if (ExceptionTools.isKnownReason((Throwable)cause) || ExceptionTools.isCancellation((Throwable)cause)) {
                Reporter.get().reportMessage(Msg.getString("PKCS7EnvelopeViewerFactory.reportError.title", new Object[0]), cause.getLocalizedMessage(), 0);
                return null;
            }
            throw new IOException("can't extract document", cause);
        }
        if (decryptedData == null) {
            throw new IOException("can't extract document");
        }
        Args loaderArgs = Args.create();
        loaderArgs.put("locatorRecentContext", null);
        return DocumentTools.createFromLocator((ILocator)decryptedData.getLocator(), (IArgs)loaderArgs);
    }
}

