/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.document.type.pkcs7;

import de.intarsys.asn1.cms.CMS;
import de.intarsys.document.model.IDocument;
import de.intarsys.security.method.cms.signature.CMSSignature;
import de.intarsys.security.processor.validation.FileBasedSignatureContainerResolver;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.locator.ILocator;
import java.io.IOException;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PKCS7SignatureContainerResolver
extends FileBasedSignatureContainerResolver {
    private static final Logger Log = LoggerFactory.getLogger(PKCS7SignatureContainerResolver.class);

    public Stream<Object> collectSignatureContainers(IDocument document, IArgs args) {
        Stream externalSignatureLocators = this.searchContainers(document.getLocator());
        Stream<ILocator> result = externalSignatureLocators.filter(locator -> {
            try {
                CMSSignature cmsSignature;
                CMS cms = CMS.createFromLocator((ILocator)locator);
                if (cms.isSignedData() && !(cmsSignature = new CMSSignature(cms)).hasSignedContent()) {
                    return true;
                }
            }
            catch (IOException e) {
                Log.warn(e.getMessage(), (Throwable)e);
            }
            return false;
        });
        return result;
    }
}

