/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.document.type.pkcs7;

import de.intarsys.asn1.cms.CMS;
import de.intarsys.document.model.IDocumentType;
import de.intarsys.document.type.pkcs7.PKCS7Document;
import de.intarsys.document.type.pkcs7.PKCS7DocumentTools;
import de.intarsys.security.method.cms.signature.CMSSignature;
import de.intarsys.tools.file.MagicFileNumberTest;
import de.intarsys.tools.file.PathTools;
import de.intarsys.tools.locator.ByteArrayLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.LocatorTools;

public class PKCS7SignatureDocument
extends PKCS7Document {
    protected static final String SUFFIX_UNKNOWN = "unknown";
    private CMSSignature cmsSignature;
    private ILocator signedContentLocator;

    protected PKCS7SignatureDocument(IDocumentType type, ILocator locator, CMS cms) {
        super(type, locator, cms);
    }

    protected ILocator getEmbeddedLocator() {
        byte[] content = this.getCMSSignature().getSignedContent();
        String targetExtension = PKCS7DocumentTools.getFileExtension(content);
        if (targetExtension == null) {
            targetExtension = MagicFileNumberTest.guessFileSuffix((byte[])content);
        }
        String baseName = LocatorTools.getBaseName((ILocator)this.getLocator());
        String targetName = PathTools.getBaseName((String)baseName);
        if (targetExtension == null) {
            targetExtension = MagicFileNumberTest.isText((byte[])content) ? "txt" : PathTools.getExtension((String)baseName, null, (String)SUFFIX_UNKNOWN);
        }
        ByteArrayLocator result = new ByteArrayLocator(content, targetName, targetExtension);
        result.setReadOnly();
        return result;
    }

    public CMSSignature getCMSSignature() {
        if (this.cmsSignature == null) {
            this.cmsSignature = new CMSSignature((CMS)this.getImpl());
        }
        return this.cmsSignature;
    }

    public ILocator getSignedContentLocator() {
        if (this.signedContentLocator == null && this.hasEmbeddedContent()) {
            this.signedContentLocator = this.getEmbeddedLocator();
        }
        return this.signedContentLocator;
    }

    protected boolean hasEmbeddedContent() {
        return this.getCMSSignature().hasSignedContent();
    }

    public void setSignedContentLocator(ILocator signedContent) {
        this.signedContentLocator = signedContent;
    }
}

