/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.document.type.pkcs7.decryption;

import de.intarsys.document.model.IDocument;
import de.intarsys.document.type.pkcs7.PKCS7DocumentTools;
import de.intarsys.security.app.crypt.DecryptedData;
import de.intarsys.security.app.crypt.IDecryptedData;
import de.intarsys.security.method.cms.decryption.PKCS7EnvelopedDataDecoder;
import de.intarsys.security.processor.decryption.DeviceBasedDocumentDecryptor;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.locator.ILocator;
import java.io.IOException;

public class PKCS7DocumentDecryptor
extends DeviceBasedDocumentDecryptor {
    public PKCS7DocumentDecryptor(IFactory factory, IDocument doc) {
        super(factory, doc);
    }

    protected IDecryptedData decrypt(IDocument document, ILocator targetLocator) throws Exception {
        PKCS7EnvelopedDataDecoder cmsDecoder = new PKCS7EnvelopedDataDecoder();
        cmsDecoder.setDecryptor(this.getDecryptor());
        cmsDecoder.decrypt(this.getDocument().getLocator(), targetLocator);
        return new DecryptedData(targetLocator);
    }

    protected String guessLocatorType(ILocator locator) throws IOException {
        String cmsType = PKCS7DocumentTools.getFileExtension(locator);
        if (cmsType != null) {
            return cmsType;
        }
        return super.guessLocatorType(locator);
    }
}

