/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.document.type.pkcs7.encryption;

import de.intarsys.asn1.cms.CMS;
import de.intarsys.asn1.cms.EnvelopedData;
import de.intarsys.asn1.cms.RecipientInfo;
import de.intarsys.asn1.cms.RecipientInfos;
import de.intarsys.asn1.model.ASN1Tools;
import de.intarsys.document.model.IDocument;
import de.intarsys.security.app.crypt.IEncryptedData;
import de.intarsys.security.app.crypt.symmetric.common.ISymmetricCryptHandler;
import de.intarsys.security.app.crypt.symmetric.common.SymmetricCryptHandlerRegistry;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.document.type.pkcs7.encryption.PKCS7EncryptedData;
import de.intarsys.security.method.cms.encryption.PKCS7EnvelopedDataEncoder;
import de.intarsys.security.processor.encryption.DeviceBasedDocumentEncryptor;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.functor.IArgsSupport;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.stream.StreamTools;
import java.io.Closeable;
import java.io.OutputStream;
import java.util.List;
import javax.crypto.SecretKey;
import org.bouncycastle.asn1.ASN1Encodable;

public class PKCS7DocumentEncryptor
extends DeviceBasedDocumentEncryptor {
    public static final String SUFFIX_P7M = "p7m";
    public static final String ARG_CONTENTENCRYPTOR = "contentEncryptor";
    protected static final String ALGORITHM_PKCS7 = "PKCS#7";
    public static final String ARG_APPEND = "append";
    public static final boolean DEFAULT_APPEND = true;
    public static final String ARG_CONTENTENCRYPTIONKEY = "contentEncryptionKey";
    private ISymmetricCryptHandler contentEncryptor;
    private List<IX509PublicKeyCertificate> recipients;

    public static byte[] getContentEncryptionKey(IArgs args) {
        return (byte[])args.get(ARG_CONTENTENCRYPTIONKEY);
    }

    public static ISymmetricCryptHandler getContentEncryptor(IArgs args, Object defaultContentEncryptor) throws ObjectCreationException {
        Object value = args.get(ARG_CONTENTENCRYPTOR);
        if (value == null) {
            value = defaultContentEncryptor;
        }
        ISymmetricCryptHandler result = null;
        if (value instanceof ISymmetricCryptHandler) {
            result = (ISymmetricCryptHandler)value;
        } else if (value instanceof String) {
            result = SymmetricCryptHandlerRegistry.get().lookupHandler((String)value);
        }
        if (result == null) {
            throw new ObjectCreationException("missing argument 'contentEncryptor'");
        }
        return result;
    }

    public static boolean isAppend(IArgs args) {
        return ArgTools.getBoolStrict((IArgs)args, (String)ARG_APPEND, (boolean)true);
    }

    public PKCS7DocumentEncryptor(IFactory factory, IDocument doc) {
        super(factory, doc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IEncryptedData encrypt(IDocument document, ILocator targetLocator) throws Exception {
        Object cekEncryptorArgs = null;
        cekEncryptorArgs = this.getCekEncryptor() instanceof IArgsSupport ? ((IArgsSupport)this.getCekEncryptor()).getArgs() : Args.create();
        byte[] key = this.getContentEncryptionKey();
        if (this.isAppend() && targetLocator.exists() && key != null) {
            CMS cms = CMS.createFromLocator((ILocator)targetLocator);
            EnvelopedData envelopedData = cms.getEnvelopedData();
            RecipientInfos recipientInfos = envelopedData.getRecipientInfos();
            for (IX509PublicKeyCertificate recipient : this.getRecipients()) {
                RecipientInfo recipientInfo = PKCS7EnvelopedDataEncoder.encodeRecipient((byte[])key, (IX509PublicKeyCertificate)recipient, (IArgs)cekEncryptorArgs);
                recipientInfos.add(recipientInfo);
            }
            OutputStream os = null;
            try {
                os = targetLocator.getOutputStream();
                ASN1Tools.writeOn((OutputStream)os, (ASN1Encodable[])new ASN1Encodable[]{cms});
            }
            finally {
                StreamTools.close((Closeable)os);
            }
        } else {
            PKCS7EnvelopedDataEncoder encryptor = new PKCS7EnvelopedDataEncoder();
            encryptor.setRecipients(this.getRecipients());
            SecretKey contentEncryptionKey = this.getContentEncryptor().generateKey();
            encryptor.setContentEncryptionKey(contentEncryptionKey);
            encryptor.setDataEncryptor(this.getContentEncryptor());
            encryptor.encrypt(document.getLocator(), targetLocator);
            key = contentEncryptionKey.getEncoded();
        }
        PKCS7EncryptedData result = new PKCS7EncryptedData(targetLocator);
        result.setAlgorithmName(ALGORITHM_PKCS7);
        result.setContentEncryptionKey(key);
        return result;
    }

    protected byte[] getContentEncryptionKey() {
        return PKCS7DocumentEncryptor.getContentEncryptionKey(this.getArgs());
    }

    public ISymmetricCryptHandler getContentEncryptor() {
        return this.contentEncryptor;
    }

    protected String getDefaultExtension() {
        return SUFFIX_P7M;
    }

    public List<IX509PublicKeyCertificate> getRecipients() throws Exception {
        if (this.recipients == null) {
            this.recipients = this.getCekEncryptor().getRecipients();
        }
        return this.recipients;
    }

    protected boolean isAppend() {
        return PKCS7DocumentEncryptor.isAppend(this.getArgs());
    }

    public void setContentEncryptor(ISymmetricCryptHandler dataEncryptor) {
        this.contentEncryptor = dataEncryptor;
    }
}

