/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.document.type.pkcs7.encryption;

import de.intarsys.document.model.IDocument;
import de.intarsys.document.type.pkcs7.PKCS7Document;
import de.intarsys.security.app.crypt.symmetric.common.ISymmetricCryptHandler;
import de.intarsys.security.app.crypt.symmetric.common.SymmetricCryptHandlerRegistry;
import de.intarsys.security.document.type.pkcs7.encryption.PACKAGE;
import de.intarsys.security.document.type.pkcs7.encryption.PKCS7DocumentEncryptor;
import de.intarsys.security.processor.encryption.DeviceBasedDocumentEncryptor;
import de.intarsys.security.processor.encryption.DeviceBasedDocumentEncryptorFactory;
import de.intarsys.tools.adapter.AdapterTools;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.preferences.IPreferences;
import de.intarsys.tools.reflect.ObjectCreationException;

public class PKCS7DocumentEncryptorFactory
extends DeviceBasedDocumentEncryptorFactory {
    public static final String ID = PKCS7DocumentEncryptorFactory.class.getName();
    private static final IMessageBundle Msg = PACKAGE.Messages;

    public static ISymmetricCryptHandler getDefaultEncryptor() {
        return SymmetricCryptHandlerRegistry.get().lookupHandler("2.16.840.1.101.3.4.1.2");
    }

    protected DeviceBasedDocumentEncryptor basicCreateEncryptor(IDocument doc, IArgs args) throws ObjectCreationException {
        PKCS7Document pkcs7Doc = (PKCS7Document)((Object)AdapterTools.getAdapter((Object)doc, PKCS7Document.class, null));
        if (pkcs7Doc != null) {
            doc = pkcs7Doc;
        }
        PKCS7DocumentEncryptor encryptor = new PKCS7DocumentEncryptor((IFactory)this, (IDocument)doc);
        encryptor.setContentEncryptor(this.getDataEncryptor(args));
        return encryptor;
    }

    protected ISymmetricCryptHandler getDataEncryptor(IArgs args) throws ObjectCreationException {
        return PKCS7DocumentEncryptor.getContentEncryptor(args, this.getPreferences().get("contentEncryptor", PKCS7DocumentEncryptorFactory.getDefaultEncryptor().getAlgorithmOID()));
    }

    protected void preferencesInit(IPreferences preferences) {
        super.preferencesInit(preferences);
        if (PKCS7DocumentEncryptorFactory.getDefaultEncryptor() != null) {
            preferences.put("contentEncryptor", PKCS7DocumentEncryptorFactory.getDefaultEncryptor().getAlgorithmOID());
        }
    }
}

