/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.document.type.pkcs7.signature;

import de.intarsys.asn1.cms.CMS;
import de.intarsys.document.model.IDocument;
import de.intarsys.security.document.type.pkcs7.signature.PACKAGE;
import de.intarsys.security.document.type.pkcs7.signature.PKCS7DocumentSignerFactory;
import de.intarsys.security.method.cms.signature.CMSExtender;
import de.intarsys.security.method.cms.signature.CMSSignatureContainer;
import de.intarsys.security.method.cms.signature.CMSSignatureContainerBuilder;
import de.intarsys.security.method.cms.signature.CMSSignatureContainerBuilderFactoryCAdES;
import de.intarsys.security.method.cms.signature.ICMSSignatureContainerBuilder;
import de.intarsys.security.processor.signature.AttachmentLocatorStrategy;
import de.intarsys.security.processor.signature.DeviceBasedDocumentSigner;
import de.intarsys.security.processor.signature.DocumentSignerException;
import de.intarsys.security.processor.signature.SignatureLocatorCreationStrategy;
import de.intarsys.security.signature.ISignatureContainer;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.impl.Conversation;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.digest.IDigester;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.LocatorTools;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.stream.StreamTools;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;

public class PKCS7DocumentSigner
extends DeviceBasedDocumentSigner {
    private final IMessageBundle Msg = PACKAGE.Messages;

    public static boolean isEmbedDocument(IArgs args) {
        return ArgTools.getBoolStrict((IArgs)args, (String)"embedDocument", (boolean)false);
    }

    public PKCS7DocumentSigner(PKCS7DocumentSignerFactory factory, IDocument<?> doc) {
        super((IFactory)factory, doc);
    }

    protected void appendCMS(CMSSignatureContainer container, ILocator destination) throws DocumentSignerException {
        InputStream is = null;
        try {
            is = destination.getInputStream();
            CMS cms = CMS.createFromInputStream((InputStream)is);
            if (!cms.isSignedData()) {
                throw new DocumentSignerException(this.Msg.getString("PKCS7DocumentSigner.ExNotSignatureFile", new Object[]{destination.getPath()}));
            }
            CMSExtender extender = new CMSExtender(container.getCms());
            extender.addSignatures(cms);
            container.clearCaches();
        }
        catch (IOException e) {
            String msg = this.Msg.getString("PKCS7DocumentSigner.ExIORead", new Object[]{destination.getPath()});
            throw new DocumentSignerException(msg, (Throwable)e);
        }
        finally {
            StreamTools.close((Closeable)is);
        }
    }

    protected IConversation<ISignatureContainer> basicSign(IDigester digester) {
        try {
            this.checkSignedDocumentConsistency();
            ILocator source = this.getDocument().getLocator();
            ILocator destination = this.createDestinationLocator(source);
            IDigest digest = LocatorTools.digest((ILocator)source, (IDigester)digester);
            IArgs args = this.getArgs().copy();
            args.put("hash", (Object)digest);
            if (this.isEmbedDocument()) {
                args.put("content", (Object)source);
            }
            args.put("signer", (Object)this.getDigestSigner());
            args.put("attributeCertificates", (Object)this.getAttributeCertificates());
            args.put("timestampDevice", this.getTimestampDevice());
            IFactory factory = CMSSignatureContainerBuilder.getFactory((IArgs)args, (Object)CMSSignatureContainerBuilderFactoryCAdES.get());
            ICMSSignatureContainerBuilder builder = (ICMSSignatureContainerBuilder)factory.createInstance(args);
            IConversation conversation = builder.run();
            return conversation.thenApply(container -> {
                container.setSignedContentLocator(source);
                if (this.isAppend(destination)) {
                    this.appendCMS((CMSSignatureContainer)container, destination);
                }
                this.saveToDestination((CMSSignatureContainer)container, destination);
                return container;
            });
        }
        catch (DocumentSignerException e) {
            return Conversation.failed((Throwable)e);
        }
        catch (Exception e) {
            Object msg = this.Msg.getString("PKCS7DocumentSigner.ExUnexpected", new Object[0]);
            msg = (String)msg + " - " + ExceptionTools.getMessage((Throwable)e);
            return Conversation.failed((Throwable)new DocumentSignerException((String)msg, (Throwable)e));
        }
    }

    protected SignatureLocatorCreationStrategy getLocatorCreationStrategy() {
        AttachmentLocatorStrategy strategy = AttachmentLocatorStrategy.create((IArgs)this.getArgs());
        strategy.setExtension(AttachmentLocatorStrategy.getLocatorExtension((IArgs)this.getArgs(), (String)this.getLocatorExtensionDefault()));
        return strategy;
    }

    protected String getLocatorExtensionDefault() {
        if (this.isEmbedDocument()) {
            return "p7m";
        }
        return "p7s";
    }

    protected String getSignedDocManipulationMessage() {
        return this.Msg.getString("PKCS7DocumentSigner.ErrorDocInconsistency", new Object[0]);
    }

    protected boolean isAppend(ILocator destination) throws IOException {
        return destination.exists() && destination.getLength() > 0L && AttachmentLocatorStrategy.isAppend((IArgs)this.getArgs());
    }

    protected boolean isEmbedDocument() {
        return PKCS7DocumentSigner.isEmbedDocument(this.getArgs());
    }

    protected void saveToDestination(CMSSignatureContainer container, ILocator destination) throws DocumentSignerException {
        ILocator sourceLocator = container.getLocator();
        try {
            LocatorTools.copy((ILocator)sourceLocator, (ILocator)destination);
        }
        catch (IOException e) {
            String msg = this.Msg.getString("PKCS7DocumentSigner.ExIOWrite", new Object[]{destination.getPath()});
            throw new DocumentSignerException(msg, (Throwable)e);
        }
        container.setLocator(destination);
    }
}

