/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.awt.environment;

import de.intarsys.cwt.awt.environment.CwtAwtGraphicsEnvironment;
import de.intarsys.cwt.awt.image.IAwtImage;
import de.intarsys.cwt.common.BlendMode;
import de.intarsys.cwt.common.IPaint;
import de.intarsys.cwt.environment.IGraphicsContext;
import de.intarsys.cwt.environment.IGraphicsEnvironment;
import de.intarsys.cwt.image.IImage;
import de.intarsys.cwt.image.ImageConvertOption;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.util.Map;

public class CwtAwtGraphicsContext
implements IGraphicsContext {
    private BlendMode blendMode = (BlendMode)BlendMode.META.getDefault();
    private Graphics2D graphics;
    private Paint paintActive;
    private Paint paintBackground;
    private Paint paintForeground;

    public CwtAwtGraphicsContext(Graphics2D graphics) {
        this.graphics = graphics;
    }

    public void clip(Shape shape) {
        if (shape == null) {
            return;
        }
        if (shape.getPathIterator(null).isDone()) {
            return;
        }
        this.graphics.clip(shape);
    }

    public void dispose() {
    }

    public void disposeClip(Object clip) {
    }

    public void draw(Shape s) {
        if (this.paintActive != this.paintForeground) {
            this.graphics.setPaint(this.paintForeground);
            this.paintActive = this.paintForeground;
        }
        this.graphics.draw(s);
    }

    public void drawImage(IImage image, float x, float y) {
        ((IAwtImage)image.asImage(IAwtImage.class, new ImageConvertOption[0])).drawGraphics2D(this.graphics, x, y);
    }

    public void drawString(String s, float x, float y) {
        if (this.paintActive != this.paintForeground) {
            this.graphics.setPaint(this.paintForeground);
            this.paintActive = this.paintForeground;
        }
        this.graphics.drawString(s, x, y);
    }

    public void fill(Shape s) {
        if (this.paintActive != this.paintBackground) {
            this.graphics.setPaint(this.paintBackground);
            this.paintActive = this.paintBackground;
        }
        this.graphics.fill(s);
    }

    public Color getBackgroundColor() {
        if (this.paintBackground instanceof Color) {
            return (Color)this.paintBackground;
        }
        return this.graphics.getBackground();
    }

    public BlendMode getBlendMode() {
        return this.blendMode;
    }

    public Shape getClip() {
        return this.graphics.getClip();
    }

    public Font getFont() {
        return this.graphics.getFont();
    }

    public FontRenderContext getFontRenderContext() {
        return this.graphics.getFontRenderContext();
    }

    public Color getForegroundColor() {
        if (this.paintForeground instanceof Color) {
            return (Color)this.paintForeground;
        }
        return this.graphics.getColor();
    }

    public Graphics2D getGraphics() {
        return this.graphics;
    }

    public IGraphicsEnvironment getGraphicsEnvironment() {
        return CwtAwtGraphicsEnvironment.get();
    }

    public RenderingHints getRenderingHints() {
        return this.graphics.getRenderingHints();
    }

    public AffineTransform getTransform() {
        return this.graphics.getTransform();
    }

    public void resetAdvanced() {
    }

    public void rotate(float theta) {
        this.graphics.rotate(theta);
    }

    public void scale(float x, float y) {
        this.graphics.scale(x, y);
    }

    public void setBackgroundColor(Color color) {
        this.graphics.setBackground(color);
        this.paintBackground = color;
    }

    public void setBackgroundPaint(IPaint paint) {
        paint.setBackgroundPaintFromGraphicsContext((IGraphicsContext)this);
    }

    public void setBackgroundPaint(Paint paint) {
        this.paintBackground = paint;
    }

    public void setBlendMode(BlendMode blendMode) {
        this.blendMode = blendMode;
    }

    public void setClip(Shape shape) {
        if (shape == null) {
            this.graphics.setClip(null);
            return;
        }
        if (shape.getPathIterator(null).isDone()) {
            this.graphics.setClip(0, 0, 0, 0);
            return;
        }
        this.graphics.setClip(shape);
    }

    public void setFont(Font font) {
        this.graphics.setFont(font);
    }

    public void setForegroundColor(Color c) {
        this.paintForeground = c;
    }

    public void setForegroundPaint(IPaint paint) {
        paint.setForegroundPaintFromGraphicsContext((IGraphicsContext)this);
    }

    public void setForegroundPaint(Paint paint) {
        this.paintForeground = paint;
    }

    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
        this.graphics.setRenderingHint(hintKey, hintValue);
    }

    public void setRenderingHints(Map hints) {
        this.graphics.setRenderingHints(hints);
    }

    public void setStroke(Stroke s) {
        this.graphics.setStroke(s);
    }

    public void setTransform(AffineTransform Tx) {
        this.graphics.setTransform(Tx);
    }

    public void transform(AffineTransform Tx) {
        this.graphics.transform(Tx);
    }

    public void translate(float x, float y) {
        this.graphics.translate(x, y);
    }
}

