/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.awt.image;

import de.intarsys.cwt.awt.environment.CwtAwtGraphicsContext;
import de.intarsys.cwt.awt.image.IAwtImage;
import de.intarsys.cwt.environment.IGraphicsContext;
import de.intarsys.cwt.image.CommonImage;
import de.intarsys.cwt.image.ImageErrorGraphics;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;

public class CwtAwtImage
extends CommonImage<IAwtImage, BufferedImage>
implements IAwtImage {
    private static final int ERROR_WIDTH = 400;
    private static final int ERROR_HEIGHT = 400;
    private int height;
    private int width;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CwtAwtImage createErrorImage(Throwable t) {
        BufferedImage image = new BufferedImage(400, 400, 10);
        Graphics2D graphics = image.createGraphics();
        try {
            graphics.setColor(Color.WHITE);
            graphics.fillRect(0, 0, 400, 400);
            CwtAwtGraphicsContext graphicsContext = new CwtAwtGraphicsContext(graphics);
            new ImageErrorGraphics(400, 400, t).drawGraphics((IGraphicsContext)graphicsContext, 0.0f, 0.0f);
        }
        finally {
            graphics.dispose();
        }
        return new CwtAwtImage(image);
    }

    private static AffineTransform createTransform(BufferedImage bufferedImage, int width, int height) {
        if (bufferedImage.getWidth() == width && bufferedImage.getHeight() == height) {
            return null;
        }
        AffineTransform transform = AffineTransform.getScaleInstance((double)width / (double)bufferedImage.getWidth(), (double)height / (double)bufferedImage.getHeight());
        return transform;
    }

    public CwtAwtImage(BufferedImage bufferedImage) {
        super((Object)bufferedImage, IAwtImage.class);
        this.setWidth(bufferedImage.getWidth());
        this.setHeight(bufferedImage.getHeight());
    }

    public CwtAwtImage(BufferedImage bufferedImage, int width, int height) {
        super((Object)bufferedImage, IAwtImage.class, CwtAwtImage.createTransform(bufferedImage, width, height));
        this.setWidth(width);
        this.setHeight(height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drawGraphics2D(Graphics2D graphics, float x, float y) {
        AffineTransform transform = this.getTransform();
        AffineTransform previousTransform = null;
        if (transform != null) {
            previousTransform = graphics.getTransform();
            graphics.transform(transform);
        }
        try {
            IAwtImage.drawGraphics2D(this.getBufferedImage(), graphics, x, y);
        }
        finally {
            if (previousTransform != null) {
                graphics.setTransform(previousTransform);
            }
        }
    }

    @Override
    public BufferedImage getBufferedImage() {
        return (BufferedImage)this.getBaseImage();
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    protected void setHeight(int paramHeight) {
        this.height = paramHeight;
    }

    protected void setWidth(int paramWidth) {
        this.width = paramWidth;
    }
}

