/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.awt.image;

import de.intarsys.cwt.image.IImage;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;

public interface IAwtImage
extends IImage {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawGraphics2D(BufferedImage image, Graphics2D graphics, float x, float y) {
        int actualY;
        int actualX;
        Image actualImage;
        AffineTransform transform = graphics.getTransform();
        AffineTransform previousTransform = null;
        if (Math.abs(transform.getDeterminant()) < 1.0) {
            int height;
            double factorY;
            double factorX;
            previousTransform = transform;
            double scaleX = previousTransform.getScaleX();
            double shearY = previousTransform.getShearY();
            double shearX = previousTransform.getShearX();
            double scaleY = previousTransform.getScaleY();
            if (scaleX == 0.0) {
                factorX = Math.abs(shearY);
                shearY = Math.signum(shearY);
            } else if (shearY == 0.0) {
                factorX = Math.abs(scaleX);
                scaleX = Math.signum(scaleX);
            } else {
                factorX = Math.sqrt(scaleX * scaleX + shearY * shearY);
                scaleX /= factorX;
                shearY /= factorX;
            }
            if (scaleY == 0.0) {
                factorY = Math.abs(shearX);
                shearX = Math.signum(shearX);
            } else if (shearX == 0.0) {
                factorY = Math.abs(scaleY);
                scaleY = Math.signum(scaleY);
            } else {
                factorY = Math.sqrt(scaleY * scaleY + shearX * shearX);
                scaleY /= factorY;
                shearX /= factorY;
            }
            double[] dstPts = new double[2];
            previousTransform.transform(new double[]{x, y}, 0, dstPts, 0, 1);
            graphics.setTransform(new AffineTransform(scaleX, shearY, shearX, scaleY, (double)((int)Math.round(dstPts[0])), (double)((int)Math.round(dstPts[1]))));
            int width = (int)Math.round((double)image.getWidth() * factorX);
            if (width < 1) {
                width = 1;
            }
            if ((height = (int)Math.round((double)image.getHeight() * factorY)) < 1) {
                height = 1;
            }
            actualImage = image.getScaledInstance(width, height, 4);
            actualX = 0;
            actualY = 0;
        } else {
            actualImage = image;
            actualX = Math.round(x);
            actualY = Math.round(y);
        }
        try {
            graphics.drawImage(actualImage, actualX, actualY, null);
        }
        finally {
            if (previousTransform != null) {
                graphics.setTransform(previousTransform);
            }
        }
    }

    public void drawGraphics2D(Graphics2D var1, float var2, float var3);

    public BufferedImage getBufferedImage();
}

