/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.awt.image;

import de.intarsys.cwt.awt.image.CwtAwtImage;
import de.intarsys.cwt.awt.image.IAwtImage;
import de.intarsys.cwt.awt.image.ImageIOImageEntry;
import de.intarsys.cwt.image.IImageContainer;
import de.intarsys.cwt.image.ImageContainer;
import de.intarsys.cwt.image.ImageMetadata;
import de.intarsys.tools.exception.UnreachableCodeError;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.LocatorTools;
import de.intarsys.tools.stream.StreamTools;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;

public class ImageIOImageContainer
extends ImageContainer {
    private int count = -1;
    private final List<ImageIOImageEntry> imageEntries = new ArrayList<ImageIOImageEntry>();
    private ImageReader imageReader;
    private ImageInputStream imageStream;
    private InputStream inputStream;
    private final ILocator locator;
    private ImageMetadata metadata;

    public static ImageIOImageContainer createFromLocator(ILocator locator) throws IOException {
        return ImageIOImageContainer.createFromLocator(locator, null);
    }

    public static ImageIOImageContainer createFromLocator(ILocator locator, String formatName) throws IOException {
        ImageIOImageContainer container = new ImageIOImageContainer(locator);
        container.open(formatName);
        return container;
    }

    protected ImageIOImageContainer(ILocator locator) {
        this.locator = locator;
    }

    protected void basicClose() throws IOException {
        if (this.imageReader != null) {
            try {
                this.imageReader.dispose();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.imageReader = null;
        }
        if (this.imageStream != null) {
            try {
                this.imageStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.imageStream = null;
        }
        StreamTools.close((Closeable)this.inputStream);
    }

    protected ImageReader findImageReader(Iterator<ImageReader> candidates) {
        while (candidates.hasNext()) {
            ImageReader candidate = candidates.next();
            if (candidate.getInput() == null) {
                candidate.setInput(this.imageStream, false, true);
            }
            try {
                this.count = candidate.getNumImages(true);
                for (int i = 0; i < this.count; ++i) {
                    this.imageEntries.add(new ImageIOImageEntry((IImageContainer)this, i));
                }
                return candidate;
            }
            catch (IOException iOException) {
            }
        }
        return null;
    }

    public ImageIOImageEntry getImageAt(int index) {
        if (index >= this.getImageCount()) {
            throw new IllegalArgumentException("invalid index");
        }
        return this.imageEntries.get(index);
    }

    public int getImageCount() {
        return this.count;
    }

    protected int getHeight(int index) throws IOException {
        if (this.imageReader == null) {
            throw new IOException("Stream closed");
        }
        return this.imageReader.getHeight(index);
    }

    public ILocator getLocator() {
        return this.locator;
    }

    public synchronized ImageMetadata getMetadata() throws IOException {
        if (this.metadata == null) {
            DOMImplementation domImplementation;
            if (this.imageReader == null) {
                throw new IOException("Stream closed");
            }
            try {
                domImplementation = DOMImplementationRegistry.newInstance().getDOMImplementation("");
            }
            catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException e1) {
                throw new UnreachableCodeError();
            }
            Document document = domImplementation.createDocument(null, "root", null);
            Element root = document.getDocumentElement();
            IIOMetadata streamMetadata = this.imageReader.getStreamMetadata();
            if (streamMetadata != null) {
                this.importNode(root, streamMetadata.getAsTree(streamMetadata.getNativeMetadataFormatName()));
                this.importNode(root, streamMetadata.getAsTree("javax_imageio_1.0"));
            }
            int numImages = this.imageReader.getNumImages(true);
            for (int index = 0; index < numImages; ++index) {
                Element node = document.createElement("image_" + index);
                root.appendChild(node);
                IIOMetadata imageMetadata = this.imageReader.getImageMetadata(index);
                this.importNode(node, imageMetadata.getAsTree(imageMetadata.getNativeMetadataFormatName()));
                this.importNode(node, imageMetadata.getAsTree("javax_imageio_1.0"));
            }
            this.metadata = new ImageMetadata(document);
        }
        return this.metadata;
    }

    protected int getWidth(int index) throws IOException {
        if (this.imageReader == null) {
            throw new IOException("Stream closed");
        }
        return this.imageReader.getWidth(index);
    }

    protected void importNode(Node parentNode, Node node) {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.transform(new DOMSource(node), new DOMResult(parentNode));
        }
        catch (TransformerException | TransformerFactoryConfigurationError e) {
            throw new UnreachableCodeError();
        }
    }

    protected IAwtImage loadImage(int index) throws IOException {
        BufferedImage bufferedImage;
        if (index >= this.getImageCount()) {
            throw new IllegalArgumentException("invalid index");
        }
        if (this.imageReader == null) {
            throw new IOException("Stream closed");
        }
        if ((bufferedImage = this.imageReader.read(index++)) == null) {
            return null;
        }
        return new CwtAwtImage(bufferedImage);
    }

    protected void open(String formatName) throws IOException {
        try {
            this.inputStream = this.getLocator().getInputStream();
            this.imageStream = ImageIO.createImageInputStream(this.inputStream);
            if (formatName == null) {
                this.imageReader = this.findImageReader(ImageIO.getImageReadersBySuffix(LocatorTools.getExtension((ILocator)this.locator)));
                if (this.imageReader == null) {
                    this.imageReader = this.findImageReader(ImageIO.getImageReaders(this.imageStream));
                }
            } else {
                Iterator<ImageReader> candidates = ImageIO.getImageReadersByFormatName(formatName);
                if (!candidates.hasNext()) {
                    throw new IllegalArgumentException("unknown format name");
                }
                this.imageReader = this.findImageReader(candidates);
            }
            if (this.imageReader == null) {
                throw new IllegalArgumentException("no image reader for input");
            }
        }
        catch (IOException | RuntimeException ex) {
            this.basicClose();
            throw ex;
        }
        catch (Exception e) {
            this.basicClose();
            throw new IOException("unexpected exception opening file");
        }
    }
}

