/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.awt.image;

import de.intarsys.cwt.awt.image.CwtAwtImage;
import de.intarsys.cwt.awt.image.IAwtImage;
import de.intarsys.cwt.awt.image.ImageIOImageContainer;
import de.intarsys.cwt.environment.IGraphicsContext;
import de.intarsys.cwt.image.IImage;
import de.intarsys.cwt.image.IImageContainer;
import de.intarsys.cwt.image.IImageConverter;
import de.intarsys.cwt.image.ImageConvertOption;
import de.intarsys.cwt.image.ImageEntry;
import de.intarsys.tools.provider.Providers;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ImageIOImageEntry
extends ImageEntry<IAwtImage>
implements IAwtImage {
    private static final Logger Log = LoggerFactory.getLogger(ImageIOImageEntry.class);
    private String colorSpaceType = null;
    private String compressionTypeName = null;
    private final int index;
    private int numComponents;
    private Point2D pixelSize = null;
    private Point2D resolution = null;

    protected static Element getDirectChild(Element element, String name) {
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Element child;
            if (children.item(i).getNodeType() != 1 || !name.equals((child = (Element)children.item(i)).getNodeName())) continue;
            return child;
        }
        return null;
    }

    protected ImageIOImageEntry(IImageContainer container, int index) {
        super(container);
        this.index = index;
    }

    protected ImageIOImageEntry(IImageContainer container, int index, CwtAwtImage image) {
        this(container, index);
        this.setDelegate(image);
    }

    public <T extends IImage> T asImage(Class<T> type, ImageConvertOption ... options) {
        Iterator iterator = Providers.get().lookupProviders(IImageConverter.class);
        while (iterator.hasNext()) {
            IImageConverter candidate = (IImageConverter)iterator.next();
            if (!candidate.acceptSourceImage((IImage)this) || !candidate.acceptTargetType(type)) continue;
            IImageConverter imageConverter = candidate;
            return (T)imageConverter.convertImage((IImage)this, options);
        }
        return (T)((IAwtImage)this.getDelegate()).asImage(type, options);
    }

    public void drawGraphics(IGraphicsContext graphicsContext, float x, float y) {
        graphicsContext.drawImage(this.getDelegate(), x, y);
    }

    @Override
    public void drawGraphics2D(Graphics2D graphics, float x, float y) {
        IAwtImage.drawGraphics2D(this.getBufferedImage(), graphics, x, y);
    }

    @Override
    public BufferedImage getBufferedImage() {
        return ((IAwtImage)this.getDelegate()).getBufferedImage();
    }

    public String getColorSpaceType() {
        if (this.colorSpaceType == null) {
            try {
                Element colorSpaceTypeElement;
                Element chromaNode = this.getNeutralChromaNode();
                if (chromaNode != null && (colorSpaceTypeElement = ImageIOImageEntry.getDirectChild(chromaNode, "ColorSpaceType")) != null) {
                    this.colorSpaceType = colorSpaceTypeElement.getAttribute("name");
                }
            }
            catch (IOException ex) {
                Log.warn("Error reading compression type: " + ex.getMessage(), (Throwable)ex);
            }
            if (this.colorSpaceType == null) {
                this.colorSpaceType = "YcbCr";
            }
        }
        return this.colorSpaceType;
    }

    public String getCompressionTypeName() {
        if (this.compressionTypeName == null) {
            try {
                Element compressionTypeElement;
                Element compressionNode = this.getNeutralCompressionNode();
                if (compressionNode != null && (compressionTypeElement = ImageIOImageEntry.getDirectChild(compressionNode, "CompressionTypeName")) != null) {
                    this.compressionTypeName = compressionTypeElement.getAttribute("value");
                }
            }
            catch (IOException ex) {
                Log.warn("Error reading compression type: " + ex.getMessage(), (Throwable)ex);
            }
            if (this.compressionTypeName == null) {
                this.compressionTypeName = "None";
            }
        }
        return this.compressionTypeName;
    }

    protected IAwtImage getErrorImage(Throwable t) {
        return CwtAwtImage.createErrorImage(t);
    }

    public int getHeight() {
        if (!this.isRealized()) {
            try {
                return this.myContainer().getHeight(this.index);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return super.getHeight();
    }

    public int getIndex() {
        return this.index;
    }

    protected Element getMetadataNode() throws IOException {
        if (this.myContainer() == null) {
            return null;
        }
        Document metadataDoc = this.myContainer().getMetadata().getDocument();
        Element root = metadataDoc.getDocumentElement();
        return ImageIOImageEntry.getDirectChild(root, "image_" + this.getIndex());
    }

    protected Element getNeutralChromaNode() throws IOException {
        Element metadataNode = this.getNeutralMetadataNode();
        if (metadataNode == null) {
            return null;
        }
        return ImageIOImageEntry.getDirectChild(metadataNode, "Chroma");
    }

    protected Element getNeutralCompressionNode() throws IOException {
        Element metadataNode = this.getNeutralMetadataNode();
        if (metadataNode == null) {
            return null;
        }
        return ImageIOImageEntry.getDirectChild(metadataNode, "Compression");
    }

    protected Element getNeutralDimensionNode() throws IOException {
        Element metadataNode = this.getNeutralMetadataNode();
        if (metadataNode == null) {
            return null;
        }
        return ImageIOImageEntry.getDirectChild(metadataNode, "Dimension");
    }

    protected Element getNeutralMetadataNode() throws IOException {
        Element metadataNode = this.getMetadataNode();
        if (metadataNode == null) {
            return null;
        }
        return ImageIOImageEntry.getDirectChild(metadataNode, "javax_imageio_1.0");
    }

    public int getNumComponents() {
        if (this.numComponents == 0) {
            try {
                Element numComponentsElement;
                Element chromaNode = this.getNeutralChromaNode();
                if (chromaNode != null && (numComponentsElement = ImageIOImageEntry.getDirectChild(chromaNode, "NumComponents")) != null) {
                    this.numComponents = Integer.parseInt(numComponentsElement.getAttribute("value"));
                }
            }
            catch (IOException ex) {
                Log.warn("Error reading number of components: " + ex.getMessage(), (Throwable)ex);
            }
            if (this.numComponents == 0) {
                this.numComponents = 3;
            }
        }
        return this.numComponents;
    }

    public Point2D getPixelSize() {
        if (this.pixelSize == null) {
            BufferedImage img = this.getBufferedImage();
            float width = img.getWidth();
            float height = img.getHeight();
            this.pixelSize = new Point2D.Float(width, height);
        }
        return this.pixelSize;
    }

    public Point2D getResolution() {
        if (this.resolution == null) {
            float hRes = 72.0f;
            float vRes = 72.0f;
            try {
                Element dimNode = this.getNeutralDimensionNode();
                if (dimNode != null) {
                    Element verticalPixelSize;
                    Element horizontalPixelSize = ImageIOImageEntry.getDirectChild(dimNode, "HorizontalPixelSize");
                    if (horizontalPixelSize != null) {
                        hRes = Math.round(25.4f / Float.parseFloat(horizontalPixelSize.getAttribute("value")));
                    }
                    if ((verticalPixelSize = ImageIOImageEntry.getDirectChild(dimNode, "VerticalPixelSize")) != null) {
                        vRes = Math.round(25.4f / Float.parseFloat(verticalPixelSize.getAttribute("value")));
                    }
                }
            }
            catch (IOException e) {
                Log.warn("Error reading resolution: " + e.getMessage(), (Throwable)e);
            }
            if (this.resolution == null) {
                this.resolution = new Point2D.Float(hRes, vRes);
            }
        }
        return this.resolution;
    }

    public Point2D getScaledPixelSize(float targetDpi) {
        float width = (float)this.getPixelSize().getX();
        float height = (float)this.getPixelSize().getY();
        float horizontalResolution = (float)this.getResolution().getX();
        float verticalResolution = (float)this.getResolution().getY();
        width = width * targetDpi / horizontalResolution;
        height = height * targetDpi / verticalResolution;
        return new Point2D.Float(width, height);
    }

    public Class<IAwtImage> getType() {
        return IAwtImage.class;
    }

    public int getWidth() {
        if (!this.isRealized()) {
            try {
                return this.myContainer().getWidth(this.index);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return super.getWidth();
    }

    protected IAwtImage loadContent() throws IOException {
        return this.myContainer().loadImage(this.getIndex());
    }

    private ImageIOImageContainer myContainer() {
        return (ImageIOImageContainer)this.getContainer();
    }
}

