/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.bridglet.meeting;

import de.intarsys.cloudsuite.meeting.bridglet.BridgletHandler;
import de.intarsys.cloudsuite.meeting.core.IMeeting;
import de.intarsys.security.algorithm.common.PpkTools;
import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.tools.collection.ByteArrayTools;
import de.intarsys.tools.exception.EncodedException;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import java.security.PublicKey;

public class AuthenticatorHandler
extends BridgletHandler {
    private static final String EX_AUTHENTICATION_FAILED = "AuthenticationFailed";
    private byte[] challenge = ByteArrayTools.createRandomBytes((int)32);

    public AuthenticatorHandler(IArgs args) {
        super(args);
    }

    public byte[] getChallenge() {
        return this.challenge;
    }

    protected int getRequiredParticipantCount() {
        return 3;
    }

    protected void hookOutcomeOk(IMeeting meeting) throws Exception {
        IArgs tmpResult = this.getResult();
        byte[] response = ArgTools.getByteArray((IArgs)tmpResult, (String)"response", null);
        if (response == null) {
            throw new EncodedException(EX_AUTHENTICATION_FAILED, "'response' required");
        }
        byte[] certBytes = ArgTools.getByteArray((IArgs)tmpResult, (String)"certificate", null);
        if (certBytes == null) {
            throw new EncodedException(EX_AUTHENTICATION_FAILED, "'certificate' required");
        }
        IX509Certificate cert = CertificateTools.createCertificate((Object)certBytes);
        if (!(cert instanceof IX509PublicKeyCertificate)) {
            throw new EncodedException(EX_AUTHENTICATION_FAILED, "'certificate' not a public key certificate");
        }
        IX509PublicKeyCertificate pubCert = (IX509PublicKeyCertificate)cert;
        if (!this.validateBytes(this.getChallenge(), response, pubCert)) {
            throw new EncodedException(EX_AUTHENTICATION_FAILED, "authentication response invalid");
        }
    }

    protected IArgs onGetParameters() {
        IArgs params = super.onGetParameters();
        ArgTools.putPath((IArgs)params, (String)"bridglet.factory", (Object)"de.intarsys.cloudsuite.bridge.control.portal.AuthenticationBridglet");
        ArgTools.putPath((IArgs)params, (String)"bridglet.args.deviceProvider.smartcard.principalValidation.notAfter.action", (Object)"warning");
        ArgTools.putPath((IArgs)params, (String)"bridglet.args.challenge", (Object)this.challenge);
        return params;
    }

    public void setChallenge(byte[] challenge) {
        this.challenge = challenge;
    }

    protected boolean validateBytes(byte[] challenge, byte[] response, IX509PublicKeyCertificate certificate) throws Exception {
        try {
            PublicKey publicKey = certificate.getPublicKey();
            return PpkTools.validate((byte[])response, (PublicKey)publicKey, null, (byte[])challenge);
        }
        catch (Exception e) {
            return false;
        }
    }
}

