/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.bridglet.meeting;

import de.intarsys.cloudsuite.bridglet.meeting.AuthenticatorHandler;
import de.intarsys.cloudsuite.bridglet.meeting.CredentialManagerHandler;
import de.intarsys.cloudsuite.bridglet.meeting.ImporterHandler;
import de.intarsys.cloudsuite.bridglet.meeting.MonitorHandler;
import de.intarsys.cloudsuite.meeting.bridglet.BridgletHandler;
import de.intarsys.cloudsuite.meeting.core.ConnectOptionsParticipant;
import de.intarsys.cloudsuite.meeting.core.IMeeting;
import de.intarsys.cloudsuite.meeting.core.IMeetingFactory;
import de.intarsys.cloudsuite.meeting.core.IMeetingHandler;
import de.intarsys.cloudsuite.meeting.core.IParticipant;
import de.intarsys.cloudsuite.meeting.core.MeetingInfo;
import de.intarsys.cloudsuite.meeting.core.ParticipantInfo;
import de.intarsys.cloudsuite.meeting.impl.NullMessageChannel;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.exception.InvalidRequestException;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.jaxrs.ServiceImplementor;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Path(value="/v1/bridglet")
@Component
@ServiceImplementor
public class SvcBridglet {
    @Autowired
    private IMeetingFactory meetingFactory;
    private String participantId = "svcbridglet-" + UUID.randomUUID().toString();

    @POST
    @Path(value="/authenticator/create")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public MeetingInfo createAuthenticator(IArgs args) throws Exception {
        IArgs meetingArgs = ArgTools.getArgs((IArgs)args, (String)"meeting", (IArgs)Args.create());
        IMeeting meeting = this.meetingFactory.createMeeting((IMeetingHandler)new AuthenticatorHandler(args), meetingArgs);
        ParticipantInfo pi = new ParticipantInfo(this.participantId);
        ConnectOptionsParticipant options = new ConnectOptionsParticipant();
        options.setMessageChannel((Object)new NullMessageChannel());
        meeting.connect(pi, options);
        return MeetingInfo.create((IMeeting)meeting);
    }

    @POST
    @Path(value="/credential-manager/create")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public MeetingInfo createCredentialManager(IArgs args) throws Exception {
        IArgs meetingArgs = ArgTools.getArgs((IArgs)args, (String)"meeting", (IArgs)Args.create());
        IMeeting meeting = this.meetingFactory.createMeeting((IMeetingHandler)new CredentialManagerHandler(args), meetingArgs);
        ParticipantInfo pi = new ParticipantInfo(this.participantId);
        ConnectOptionsParticipant options = new ConnectOptionsParticipant();
        options.setMessageChannel((Object)new NullMessageChannel());
        meeting.connect(pi, options);
        return MeetingInfo.create((IMeeting)meeting);
    }

    @POST
    @Path(value="/importer/create")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public MeetingInfo createImporter(IArgs args) throws Exception {
        IArgs meetingArgs = ArgTools.getArgs((IArgs)args, (String)"meeting", (IArgs)Args.create());
        IMeeting meeting = this.meetingFactory.createMeeting((IMeetingHandler)new ImporterHandler(args), meetingArgs);
        ParticipantInfo pi = new ParticipantInfo(this.participantId);
        ConnectOptionsParticipant options = new ConnectOptionsParticipant();
        options.setMessageChannel((Object)new NullMessageChannel());
        meeting.connect(pi, options);
        return MeetingInfo.create((IMeeting)meeting);
    }

    @POST
    @Path(value="/monitor/create")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public MeetingInfo createMonitor(IArgs args) throws Exception {
        IArgs meetingArgs = ArgTools.getArgs((IArgs)args, (String)"meeting", (IArgs)Args.create());
        IMeeting meeting = this.meetingFactory.createMeeting((IMeetingHandler)new MonitorHandler(args), meetingArgs);
        ParticipantInfo pi = new ParticipantInfo(this.participantId);
        ConnectOptionsParticipant options = new ConnectOptionsParticipant();
        options.setMessageChannel((Object)new NullMessageChannel());
        meeting.connect(pi, options);
        return MeetingInfo.create((IMeeting)meeting);
    }

    @GET
    @Path(value="/{meeting}/result")
    @Produces(value={"application/json"})
    public Object getResult(@PathParam(value="meeting") String meetingId) throws Exception {
        IMeeting meeting = this.meetingFactory.lookupMeeting(meetingId);
        IParticipant participant = meeting.lookupParticipant(this.participantId);
        BridgletHandler handler = (BridgletHandler)meeting.getHandler();
        if (handler.isDone()) {
            try {
                if (handler.isOk()) {
                    IArgs iArgs = handler.getResult();
                    return iArgs;
                }
                if (handler.isCanceled()) {
                    throw ExceptionTools.cancellation();
                }
                throw handler.getOutcomeException();
            }
            finally {
                meeting.disconnect(participant);
            }
        }
        throw new InvalidRequestException("result not yet available");
    }
}

