/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.bridge.app.signature;

import de.intarsys.cloudsuite.meeting.bridglet.BridgletHandler;
import de.intarsys.cloudsuite.meeting.core.IMeeting;
import de.intarsys.cloudsuite.meeting.core.IMeetingHandler;
import de.intarsys.cloudsuite.meeting.core.IParticipant;
import de.intarsys.security.algorithm.common.AlgorithmTools;
import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.app.signature.CommonBatchSigner;
import de.intarsys.security.app.signature.SignatureItemEvidence;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.X509CertificateFactory;
import de.intarsys.security.device.IPrincipal;
import de.intarsys.security.device.bridge.app.signature.BridgeSignerParams;
import de.intarsys.security.device.bridge.app.signature.PACKAGE;
import de.intarsys.security.device.bridge.app.signature.ResponseSetSignerParameters;
import de.intarsys.security.device.bridge.device.BridgeDevice;
import de.intarsys.security.device.common.CommonDevice;
import de.intarsys.security.signature.common.ISignatureData;
import de.intarsys.security.signature.common.SignatureData;
import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.attribute.IAttributeSupport;
import de.intarsys.tools.collection.ListTools;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.IReplyStage;
import de.intarsys.tools.conversation.impl.Conversation;
import de.intarsys.tools.conversation.impl.HttpRedirectStage;
import de.intarsys.tools.encoding.Base64;
import de.intarsys.tools.exception.EncodedException;
import de.intarsys.tools.exception.EncodedRuntimeException;
import de.intarsys.tools.exception.RestartException;
import de.intarsys.tools.format.Format;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.jaxrs.RequestContext;
import de.intarsys.tools.license.License;
import de.intarsys.tools.loadbalance.LoadBalanceContext;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.nls.NlsContext;
import de.intarsys.tools.string.StringTools;
import jakarta.annotation.PostConstruct;
import jakarta.ws.rs.core.UriBuilder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.InvalidAlgorithmParameterException;
import java.util.Collection;
import java.util.List;
import java.util.Locale;

public class BridgeSigner
extends CommonBatchSigner {
    private static final String PARAM_DESCRIPTION = "description";
    private static final String PARAM_LABEL = "label";
    private static final String PARAM_STATE = "state";
    private static final String PARAM_LANG = "lang";
    private static final String PARAM_URL_SERVER = "urlServer";
    private static final String DEFAULT_BRIDGLET = "de.intarsys.cloudsuite.bridge.control.workflow.MeetingSignatureBridglet";
    public static final String STATE_CANCEL = "cancel";
    public static final String STATE_FAIL = "fail";
    public static final String STATE_OK = "ok";
    private static final String PATH_SIGN = "sign";
    private static final String ARG_DEBUG_BRIDGE_URL_CLIENT = "bridge.urlClient";
    private static final Attribute ATTR_BRIDGESIGNER = new Attribute("BridgeSigner");
    private static final IMessageBundle MSG = PACKAGE.Messages;
    private String encryptionAlgorithmName;
    private Collection<String> supportedHashAlgorithmNames;
    private String preferredHashAlgorithmName;
    private IConversation<?> conversationSignCommit;
    private BridgeSignerState state;
    private ILocator license;
    private IReplyStage replyStage;
    private UriBuilder uriBuilderUi = null;
    private IArgs bridgeArgs;
    private IArgs bridgletArgs;
    private IArgs meetingArgs;
    private IArgs debugArgs;

    public static BridgeSigner get(IAttributeSupport as) {
        if (as == null) {
            return null;
        }
        return (BridgeSigner)((Object)as.getAttribute((Object)ATTR_BRIDGESIGNER));
    }

    public static void set(IAttributeSupport as, BridgeSigner value) {
        if (as == null) {
            return;
        }
        as.setAttribute((Object)ATTR_BRIDGESIGNER, (Object)value);
    }

    public BridgeSigner(CommonDevice device) {
        super(device);
    }

    protected IConversation<?> basicSignAuthorized() {
        if (this.conversationSignCommit == null) {
            this.conversationSignCommit = this.createConversationSignCommit();
        }
        return this.getConversationSignCommit();
    }

    protected IX509PublicKeyCertificate createCertificate(String certificateString) throws Exception {
        byte[] certificateBytes = Base64.decode((String)certificateString);
        return X509CertificateFactory.get().createPublicKeyCertificate((InputStream)new ByteArrayInputStream(certificateBytes));
    }

    protected IConversation<?> createConversationSignCommit() {
        Conversation conversation = new Conversation("BridgeSignerCommit");
        return conversation;
    }

    protected IConversation createConversationSignPrepare() {
        this.toStatePrepared();
        Conversation conversation = new Conversation("BridgeSignerPrepare");
        this.replyStage = new HttpRedirectStage(this.uriBuilderUi.toString(), false, true);
        this.replyStage.onAck(ignore -> {
            IConversation tmpConversation = this.getConversationSignPrepare();
            if (tmpConversation != null && !tmpConversation.isDone()) {
                IllegalStateException reentry = new IllegalStateException("Bridge not correctly started");
                this.doFail(reentry);
            }
        });
        conversation.setReplyStage(this.replyStage);
        return conversation;
    }

    protected IMeeting createMeeting() {
        Args argsHandler = Args.create();
        ArgTools.putPath((IArgs)argsHandler, (String)"bridge", (Object)this.getBridgeArgs());
        this.createMeetingSetDefaultArgsBridge(this.getBridgeArgs());
        ArgTools.putPath((IArgs)argsHandler, (String)"bridglet", (Object)this.getBridgletArgs());
        this.createMeetingSetDefaultArgsBridglet(this.getBridgletArgs());
        BridgletHandler meetingHandler = new BridgletHandler((IArgs)argsHandler){

            protected Object basicCall(IMeeting meeting, IParticipant participant, String name, IArgs args) throws Exception {
                if ("setSignerParameters".equals(name)) {
                    return this.onSetSignerParameters(BridgeSignerParams.create(args));
                }
                if ("setSignerResult".equals(name)) {
                    return this.onSetResult(args);
                }
                return super.basicCall(meeting, participant, name, args);
            }

            protected Collection<License> getAdditionalLicenses() {
                return BridgeSigner.this.getDevice().getActiveLicenses();
            }

            protected void hookOutcomeCancel(IMeeting meeting) throws Exception {
                BridgeSigner.this.doCancel();
            }

            protected void hookOutcomeFail(IMeeting meeting) throws Exception {
                BridgeSigner.this.doFail(this.getOutcomeException());
            }

            protected void hookOutcomeOk(IMeeting meeting) throws Exception {
                BridgeSigner.this.doOk(this.getResult());
            }

            protected IArgs onGetParameters() {
                IArgs params = super.onGetParameters();
                ArgTools.putPathIfAbsent((IArgs)params, (String)"bridge.license", (Object)this.getLicense());
                ArgTools.putPathIfAbsent((IArgs)params, (String)"bridglet.factory", (Object)BridgeSigner.DEFAULT_BRIDGLET);
                Args documentsArgs = Args.create();
                BridgeSigner.this.getSignatureEvidence().getItems().stream().forEach(arg_0 -> 1.lambda$onGetParameters$0((IArgs)documentsArgs, arg_0));
                ArgTools.putPath((IArgs)params, (String)"bridglet.args.documents", (Object)documentsArgs);
                return params;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected ResponseSetSignerParameters onSetSignerParameters(BridgeSignerParams params) throws Exception {
                IConversation tmpConversation = BridgeSigner.this.getConversationSignPrepare();
                Object object = BridgeSigner.this.lock;
                synchronized (object) {
                    if (tmpConversation != null && tmpConversation.isDone()) {
                        BridgeSigner.this.doFail((Exception)new RestartException());
                    }
                    if (params == null) {
                        throw new IllegalArgumentException("signer parameters required");
                    }
                    if (params.getCertificatePath() == null || params.getCertificatePath().isEmpty()) {
                        throw new IllegalArgumentException("certificatePath required");
                    }
                    if (StringTools.isEmpty((String)params.getEncryptionAlgorithm())) {
                        throw new IllegalArgumentException("encryptionAlgorithm required");
                    }
                    if (StringTools.isEmpty((String)params.getHashAlgorithm())) {
                        throw new IllegalArgumentException("hashAlgorithm required");
                    }
                    try {
                        BridgeSigner.this.setAlgorithmParameterSpec(AlgorithmTools.toAlgorithmParameterSpec((Object)params.getAlgorithmParameterSpec()));
                    }
                    catch (InvalidAlgorithmParameterException e) {
                        String msg = Format.simple((String)"algorithmParameterSpec invalid ({})", (Object[])new Object[]{e.getMessage()});
                        throw new IllegalArgumentException(msg, e);
                    }
                    try {
                        BridgeSigner.this.setEncryptionAlgorithmName(params.getEncryptionAlgorithm());
                    }
                    catch (Exception e) {
                        String msg = Format.simple((String)"encryptionAlgorithm invalid ({})", (Object[])new Object[]{e.getMessage()});
                        throw new IllegalArgumentException(msg, e);
                    }
                    try {
                        BridgeSigner.this.setPreferredHashAlgorithmName(params.getHashAlgorithm());
                    }
                    catch (Exception e) {
                        String msg = Format.simple((String)"hashAlgorithm invalid ({})", (Object[])new Object[]{e.getMessage()});
                        throw new IllegalArgumentException(msg, e);
                    }
                    try {
                        BridgeSigner.this.setSupportedHashAlgorithmNames(ListTools.with((Object[])new String[]{params.getHashAlgorithm()}));
                    }
                    catch (Exception e) {
                        String msg = Format.simple((String)"hashAlgorithm invalid ({})", (Object[])new Object[]{e.getMessage()});
                        throw new IllegalArgumentException(msg, e);
                    }
                    try {
                        String certificateString = params.getCertificatePath().get(0);
                        BridgeSigner.this.setCertificatePath(new IX509PublicKeyCertificate[]{BridgeSigner.this.createCertificate(certificateString)});
                    }
                    catch (Exception e) {
                        String msg = Format.simple((String)"certificate invalid ({})", (Object[])new Object[]{e.getMessage()});
                        throw new IllegalArgumentException(msg, e);
                    }
                    BridgeSigner.this.validate();
                    BridgeSigner.this.toStateParameterized();
                }
                tmpConversation.complete(null);
                BridgeSigner.this.setConversationSignPrepare(null);
                if (BridgeSigner.this.isDisposed()) {
                    throw new IllegalStateException("Server error - process terminated.");
                }
                ResponseSetSignerParameters response = new ResponseSetSignerParameters();
                List<byte[]> hashes = BridgeSigner.this.tasksGetToBeSignedData().stream().map(data -> data.getEncodedDigest()).toList();
                response.setHashes(hashes);
                return response;
            }

            private static /* synthetic */ void lambda$onGetParameters$0(IArgs documentsArgs, SignatureItemEvidence item) {
                documentsArgs.add((Object)Args.createNamed((Object[])new Object[]{"name", item.getLabel()}));
            }
        };
        return this.getDevice().getMeetingFactory().createMeeting((IMeetingHandler)meetingHandler, this.getMeetingArgs());
    }

    protected void createMeetingSetDefaultArgsBridge(IArgs argsBridge) {
    }

    protected void createMeetingSetDefaultArgsBridglet(IArgs argsBridglet) {
        ArgTools.putPathIfAbsent((IArgs)argsBridglet, (String)"args.ui.reduced", (Object)true);
    }

    protected IPrincipal createPrincipal(IX509PublicKeyCertificate certificate) {
        return this.getDevice().createPrincipal(certificate);
    }

    protected UriBuilder createUriBuilder(IMeeting meeting) {
        UriBuilder result;
        String debugUrlClient = ArgTools.getString((IArgs)this.getDebugArgs(), (String)ARG_DEBUG_BRIDGE_URL_CLIENT, null);
        if (StringTools.isEmpty((String)debugUrlClient)) {
            URI uriUi = this.getDevice().getUrlUi();
            if (uriUi.isAbsolute()) {
                result = UriBuilder.fromUri((URI)uriUi);
                LoadBalanceContext.get().processUri(result);
                UriBuilder uriBuilderServer = RequestContext.get().getUriBuilderContext();
                result.queryParam(PARAM_URL_SERVER, new Object[]{uriBuilderServer.build(new Object[0]).toString()});
            } else {
                result = RequestContext.get().getUriBuilderContext();
                result.path(uriUi.toString());
            }
        } else {
            result = UriBuilder.fromUri((String)debugUrlClient);
            LoadBalanceContext.get().processUri(result);
            UriBuilder uriBuilderServer = RequestContext.get().getUriBuilderContext();
            result.queryParam(PARAM_URL_SERVER, new Object[]{uriBuilderServer.build(new Object[0]).toString()});
        }
        result.path(PATH_SIGN);
        result.queryParam(PARAM_STATE, new Object[]{meeting.getId()});
        Locale locale = NlsContext.get().getLocale();
        if (locale != null) {
            result.queryParam(PARAM_LANG, new Object[]{locale.getLanguage()});
        }
        String label = MSG.getString("BridgeSigner.bridglet.label", new Object[0]);
        result.queryParam(PARAM_LABEL, new Object[]{ArgTools.getString((IArgs)this.getBridgletArgs(), (String)PARAM_LABEL, (String)label)});
        String description = MSG.getString("BridgeSigner.bridglet.description", new Object[0]);
        result.queryParam(PARAM_DESCRIPTION, new Object[]{ArgTools.getString((IArgs)this.getBridgletArgs(), (String)PARAM_DESCRIPTION, (String)description)});
        return result;
    }

    protected void doCancel() {
        this.tasksCancel();
        IConversation<?> tmpConversation = null;
        tmpConversation = this.getConversationSignPrepare();
        this.setConversationSignPrepare(null);
        if (tmpConversation != null) {
            tmpConversation.cancel(false);
        }
        tmpConversation = this.getConversationSignCommit();
        this.conversationSignCommit = null;
        if (tmpConversation != null) {
            tmpConversation.cancel(false);
        }
    }

    protected void doFail(Exception e) {
        IConversation<?> tmpConversation = null;
        tmpConversation = this.getConversationSignPrepare();
        this.setConversationSignPrepare(null);
        if (tmpConversation != null) {
            tmpConversation.completeExceptionally((Throwable)e);
        }
        tmpConversation = this.getConversationSignCommit();
        this.conversationSignCommit = null;
        if (tmpConversation != null) {
            tmpConversation.completeExceptionally((Throwable)e);
        }
    }

    protected void doOk(IArgs result) throws EncodedException, SecurityApplicationException {
        IConversation<?> tmpConversation = null;
        this.setConversationSignPrepare(null);
        List signatureList = ArgTools.getList((IArgs)result, (String)"signatures", null);
        if (signatureList == null) {
            throw new EncodedException("ProcessFailed", "'signatures' required");
        }
        List<ISignatureData> signatures = signatureList.stream().map(signature -> {
            try {
                return SignatureData.create((byte[])Base64.decode((String)((String)signature)));
            }
            catch (IOException e) {
                throw new EncodedRuntimeException("ProcessFailed", "'signatures' encoding invalid");
            }
        }).toList();
        this.tasksComplete(signatures);
        tmpConversation = this.getConversationSignCommit();
        this.conversationSignCommit = null;
        if (tmpConversation != null) {
            tmpConversation.complete(null);
        }
    }

    public IArgs getBridgeArgs() {
        return this.bridgeArgs;
    }

    public IArgs getBridgletArgs() {
        return this.bridgletArgs;
    }

    protected IConversation<?> getConversationSignCommit() {
        return this.conversationSignCommit;
    }

    public IArgs getDebugArgs() {
        return this.debugArgs;
    }

    public BridgeDevice getDevice() {
        return (BridgeDevice)super.getDevice();
    }

    public String getEncryptionAlgorithmName() {
        return this.encryptionAlgorithmName;
    }

    public IArgs getMeetingArgs() {
        return this.meetingArgs;
    }

    public String getPreferredHashAlgorithmName() {
        return this.preferredHashAlgorithmName;
    }

    public Collection<String> getSupportedHashAlgorithmNames() {
        return this.supportedHashAlgorithmNames;
    }

    @PostConstruct
    public void init() {
        this.toStateInitialized();
        IMeeting meeting = this.createMeeting();
        this.uriBuilderUi = this.createUriBuilder(meeting);
    }

    public boolean isBasic() {
        return true;
    }

    public void setBridgeArgs(IArgs bridgeArgs) {
        this.bridgeArgs = bridgeArgs;
    }

    public void setBridgletArgs(IArgs bridgletArgs) {
        this.bridgletArgs = bridgletArgs;
    }

    public void setDebugArgs(IArgs debugArgs) {
        this.debugArgs = debugArgs;
    }

    private void setEncryptionAlgorithmName(String encryptionAlgorithmName) {
        this.encryptionAlgorithmName = encryptionAlgorithmName;
    }

    public void setLicense(ILocator license) {
        this.license = license;
    }

    public void setMeetingArgs(IArgs meetingArgs) {
        this.meetingArgs = meetingArgs;
    }

    private void setPreferredHashAlgorithmName(String preferredHashAlgorithmName) {
        this.preferredHashAlgorithmName = preferredHashAlgorithmName;
    }

    private void setSupportedHashAlgorithmNames(Collection<String> supportedHashAlgorithmNames) {
        this.supportedHashAlgorithmNames = supportedHashAlgorithmNames;
    }

    protected void tasksRelease() {
        this.toStateInitialized();
        super.tasksRelease();
    }

    protected void toStateInitialized() {
        this.state = BridgeSignerState.INITIALIZED;
    }

    protected void toStateParameterized() {
        this.state = BridgeSignerState.PARAMETERIZED;
    }

    protected void toStatePrepared() {
        if (this.state != BridgeSignerState.INITIALIZED) {
            return;
        }
        this.state = BridgeSignerState.PREPARED;
    }

    public static enum BridgeSignerState {
        INITIALIZED,
        PREPARED,
        PARAMETERIZED;

    }
}

