/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.bridge.device;

import de.intarsys.cloudsuite.meeting.core.IMeetingFactory;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.device.IPrincipal;
import de.intarsys.security.device.bridge.device.BridgeDeviceProvider;
import de.intarsys.security.device.common.CommonDevice;
import de.intarsys.security.device.common.CommonDeviceProvider;
import de.intarsys.tools.factory.FactoredBy;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.license.License;
import de.intarsys.tools.license.LicenseException;
import de.intarsys.tools.license.LicenseRepository;
import de.intarsys.tools.license.LicenseTools;
import de.intarsys.tools.locator.FileLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.string.StringTools;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@FactoredBy(factory=BridgeDeviceProvider.class)
public class BridgeDevice
extends CommonDevice<BridgeDeviceProvider> {
    private static final Logger Log = LoggerFactory.getLogger(BridgeDevice.class);
    public static final String LIC_PRODUCT = "de.intarsys.security.device.bridge";
    private Collection<License> activeLicenses;
    private String agentLicense;
    private URI urlUi = URI.create("bridge");
    @Autowired
    private IMeetingFactory meetingFactory;

    protected BridgeDevice(BridgeDeviceProvider deviceProvider, String name) {
        super((CommonDeviceProvider)deviceProvider, name);
    }

    protected void collectClientLicenseDevice(LicenseRepository licenseRepo) {
        if (StringTools.isEmpty((String)this.getAgentLicense())) {
            return;
        }
        FileLocator locator = new FileLocator(this.getAgentLicense());
        List licenses = LicenseTools.loadLicense((ILocator)locator);
        for (License license : licenses) {
            licenseRepo.addLicense(license);
        }
    }

    public void configure(IArgs args) throws Exception {
        super.configure(args);
        this.setAgentLicense(ArgTools.getString((IArgs)args, (String)"agentLicense", (String)this.getAgentLicense()));
        try {
            this.setUrlUi(new URI(ArgTools.getString((IArgs)args, (String)"urlUi", (String)this.getUrlUi().toString())));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("'urlUi' invalid", e);
        }
    }

    public IPrincipal createPrincipal(IX509PublicKeyCertificate cert) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<License> getActiveLicenses() {
        Object object = this.lock;
        synchronized (object) {
            if (this.activeLicenses == null) {
                try {
                    if (!StringTools.isEmpty((String)this.getAgentLicense())) {
                        FileLocator locator = new FileLocator(this.getAgentLicense());
                        this.activeLicenses = LicenseTools.loadLicense((ILocator)locator);
                    }
                }
                catch (LicenseException ex) {
                    Log.warn(ex.getMessage(), (Throwable)ex);
                }
                if (this.activeLicenses == null) {
                    this.activeLicenses = Collections.emptySet();
                }
            }
            return this.activeLicenses;
        }
    }

    public String getAgentLicense() {
        return this.agentLicense;
    }

    public IMeetingFactory getMeetingFactory() {
        return this.meetingFactory;
    }

    public URI getUrlUi() {
        return this.urlUi;
    }

    public void setAgentLicense(String agentLicense) {
        this.agentLicense = agentLicense;
    }

    public void setMeetingFactory(IMeetingFactory meetingFactory) {
        this.meetingFactory = meetingFactory;
    }

    public void setUrlUi(URI uriUi) {
        this.urlUi = uriUi;
    }
}

