/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.bridge.device;

import de.intarsys.security.app.IApplicationDescriptor;
import de.intarsys.security.app.IApplicationPolicy;
import de.intarsys.security.app.signature.CommonSignerPolicy;
import de.intarsys.security.app.signature.ISigner;
import de.intarsys.security.device.DeviceProviderRegistry;
import de.intarsys.security.device.IDeviceProvider;
import de.intarsys.security.device.bridge.app.signature.BridgeSignerFactory;
import de.intarsys.security.device.bridge.device.BridgeDevice;
import de.intarsys.security.device.common.CommonDeviceProvider;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.license.ILicenseAccount;
import de.intarsys.tools.license.LicenseProduct;
import de.intarsys.tools.license.LicensePropertyUnit;
import de.intarsys.tools.license.LicenseTools;
import de.intarsys.tools.reflect.ObjectCreationException;
import jakarta.annotation.PostConstruct;
import java.util.List;

public class BridgeDeviceProvider
extends CommonDeviceProvider<BridgeDevice> {
    protected BridgeDevice basicCreateInstance(IArgs args) throws ObjectCreationException {
        BridgeDevice device = new BridgeDevice(this, this.getId(args));
        return device;
    }

    protected void declareApplicationDescriptors(List<IApplicationDescriptor> apps) {
        super.declareApplicationDescriptors(apps);
        BridgeSignerFactory descriptor = new BridgeSignerFactory();
        descriptor.setDeviceProvider(this);
        descriptor.setLicenseAccountSupplier(() -> this.declareLicenseAccountSign());
        CommonSignerPolicy signerPolicy = new CommonSignerPolicy((CommonDeviceProvider)this);
        descriptor.setPolicy((IApplicationPolicy)signerPolicy);
        descriptor.setType(ISigner.class);
        apps.add((IApplicationDescriptor)descriptor);
    }

    protected ILicenseAccount declareLicenseAccountSignBasic() {
        ILicenseAccount account = this.getLicenseProduct().getAccount("de.intarsys.security.app.sign.account");
        account.setDefaultValueUnit(10, LicensePropertyUnit.PER_MINUTE);
        return account;
    }

    protected LicenseProduct declareLicenseProduct() {
        return LicenseTools.createProduct((Object)((Object)this), (String)"de.intarsys.security.device.bridge");
    }

    @PostConstruct
    public void init() {
        super.init();
        DeviceProviderRegistry.get().registerDeviceProvider((IDeviceProvider)this);
    }
}

