/*
 * Decompiled with CFR 0.152.
 */
package com.cabaret.security.certificate.export.certificate;

import com.cabaret.security.certstore.export.StreamCertificateExporter;
import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.provider.keystore.KeyStoreFacade;
import de.intarsys.security.certificate.provider.keystore.KeyStoreFactory;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.stream.StreamTools;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;

public class CertificateExporter
extends StreamCertificateExporter {
    public CertificateExporter(IFactory factory) {
        super(factory);
    }

    protected void basicRun() throws Exception {
        this.writeCertificate(this.getCertificate(), this.getLocator());
        this.ok();
    }

    protected void writeCertificate(IX509Certificate certificate, ILocator target) throws GeneralSecurityException, IOException {
        boolean append = false;
        if (certificate instanceof IX509PublicKeyCertificate && KeyStoreFacade.isJKS((ILocator)target)) {
            append = this.isAppend();
        }
        if (!append && !this.isOverwrite()) {
            target = StreamCertificateExporter.makeUnique(target);
        }
        if (certificate instanceof IX509PublicKeyCertificate) {
            this.writeKeystore((IX509PublicKeyCertificate)certificate, target, append);
        } else {
            this.writePlain(certificate, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeKeystore(IX509PublicKeyCertificate certificate, ILocator target, boolean append) throws GeneralSecurityException, IOException {
        KeyStoreFacade facade = (KeyStoreFacade)KeyStoreFactory.get().create(target);
        if (append && target.exists()) {
            facade.load();
        } else {
            facade.create();
        }
        KeyStore keyStore = facade.getKeyStore();
        keyStore.setCertificateEntry(CertificateTools.getSubjectLabel((IX509Certificate)certificate), certificate.toJavaCertificate());
        OutputStream os = null;
        try {
            os = target.getOutputStream();
            keyStore.store(os, new char[0]);
        }
        finally {
            StreamTools.close((Closeable)os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writePlain(IX509Certificate certificate, ILocator target) throws GeneralSecurityException, IOException {
        OutputStream os = null;
        try {
            os = target.getOutputStream();
            os.write(certificate.getEncoded());
        }
        finally {
            StreamTools.close((Closeable)os);
        }
    }
}

